/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph.Settings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.LayoutStyle;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.IZyGraphLayoutSettingsListener;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphCircularSettings;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphHierarchicalSettings;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphOrthogonalSettings;
import com.google.security.zynamics.binnavi.config.GraphSettingsConfigItem;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyLayoutCreator;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.settings.ILayoutSettings;
import y.f.c;

public final class ZyGraphLayoutSettings
implements ILayoutSettings {
    private int m_visibilityWarningThreshold;
    private boolean m_automaticLayouting;
    private int m_autoLayoutDeactivationThreshold;
    private int m_animateLayoutNodeThreshold;
    private int m_animateLayoutEdgeThreshold;
    private int m_layoutCalculationTimeWarningThreshold;
    private boolean m_layoutAnimation;
    private LayoutStyle m_defaultGraphLayout;
    private final GraphSettingsConfigItem m_type;
    private c m_currentLayouter;
    private final ListenerProvider<IZyGraphLayoutSettingsListener> m_listeners = new ListenerProvider();
    private final ZyGraphCircularSettings m_circularSettings;
    private final ZyGraphHierarchicalSettings m_hierarchicalSettings;
    private final ZyGraphOrthogonalSettings m_orthogonalSettings;

    public ZyGraphLayoutSettings(GraphSettingsConfigItem graphSettingsConfigItem) {
        Preconditions.checkNotNull(graphSettingsConfigItem, "IE02023: Type argument can't be null");
        this.m_type = graphSettingsConfigItem;
        this.m_circularSettings = new ZyGraphCircularSettings(graphSettingsConfigItem);
        this.m_hierarchicalSettings = new ZyGraphHierarchicalSettings(graphSettingsConfigItem);
        this.m_orthogonalSettings = new ZyGraphOrthogonalSettings(graphSettingsConfigItem);
    }

    public ZyGraphLayoutSettings(ZyGraphLayoutSettings zyGraphLayoutSettings) {
        this.m_type = null;
        this.m_defaultGraphLayout = zyGraphLayoutSettings.getDefaultGraphLayout();
        this.m_animateLayoutEdgeThreshold = zyGraphLayoutSettings.getAnimateLayoutEdgeThreshold();
        this.m_animateLayoutNodeThreshold = zyGraphLayoutSettings.getAnimateLayoutNodeThreshold();
        this.m_autoLayoutDeactivationThreshold = zyGraphLayoutSettings.getAutolayoutDeactivationThreshold();
        this.m_automaticLayouting = zyGraphLayoutSettings.getAutomaticLayouting();
        this.m_layoutAnimation = zyGraphLayoutSettings.getAnimateLayout();
        this.m_layoutCalculationTimeWarningThreshold = zyGraphLayoutSettings.getLayoutCalculationTimeWarningThreshold();
        this.m_visibilityWarningThreshold = zyGraphLayoutSettings.getVisibilityWarningTreshold();
        this.m_circularSettings = new ZyGraphCircularSettings(zyGraphLayoutSettings.getCircularSettings());
        this.m_hierarchicalSettings = new ZyGraphHierarchicalSettings(zyGraphLayoutSettings.getHierarchicalSettings());
        this.m_orthogonalSettings = new ZyGraphOrthogonalSettings(zyGraphLayoutSettings.getOrthogonalSettings());
        this.updateLayouter();
    }

    private static LayoutStyle getDefaultLayout(GraphSettingsConfigItem graphSettingsConfigItem) {
        try {
            return LayoutStyle.parseInt(graphSettingsConfigItem.getDefaultGraphLayout());
        }
        catch (IllegalStateException illegalStateException) {
            CUtilityFunctions.logException(illegalStateException);
            return LayoutStyle.CIRCULAR;
        }
    }

    private void setCurrentLayouter(c c2) {
        this.m_currentLayouter = Preconditions.checkNotNull(c2, "IE02249: Layouter argument can't be null");
    }

    private void updateLayouter() {
        if (this.getDefaultGraphLayout() == LayoutStyle.HIERARCHIC) {
            this.setCurrentLayouter(ZyLayoutCreator.getHierarchicLayout(this));
        } else if (this.getDefaultGraphLayout() == LayoutStyle.ORTHOGONAL) {
            this.setCurrentLayouter(ZyLayoutCreator.getOrthogonalLayout(this));
        } else {
            this.setCurrentLayouter(ZyLayoutCreator.getCircularLayout(this));
        }
    }

    public void addListener(IZyGraphLayoutSettingsListener iZyGraphLayoutSettingsListener) {
        this.m_listeners.addListener(iZyGraphLayoutSettingsListener);
    }

    @Override
    public boolean getAnimateLayout() {
        return this.m_type == null ? this.m_layoutAnimation : this.m_type.isLayoutAnimation();
    }

    @Override
    public int getAnimateLayoutEdgeThreshold() {
        return this.m_type == null ? this.m_animateLayoutEdgeThreshold : this.m_type.getAnimateLayoutEdgeThreshold();
    }

    @Override
    public int getAnimateLayoutNodeThreshold() {
        return this.m_type == null ? this.m_animateLayoutNodeThreshold : this.m_type.getAnimateLayoutNodeThreshold();
    }

    public int getAutolayoutDeactivationThreshold() {
        return this.m_type == null ? this.m_autoLayoutDeactivationThreshold : this.m_type.getAutoLayoutDeactivationThreshold();
    }

    @Override
    public boolean getAutomaticLayouting() {
        return this.m_type == null ? this.m_automaticLayouting : this.m_type.isAutomaticLayouting();
    }

    public ZyGraphCircularSettings getCircularSettings() {
        return this.m_circularSettings;
    }

    @Override
    public c getCurrentLayouter() {
        return this.m_currentLayouter;
    }

    public LayoutStyle getDefaultGraphLayout() {
        return this.m_type == null ? this.m_defaultGraphLayout : ZyGraphLayoutSettings.getDefaultLayout(this.m_type);
    }

    public ZyGraphHierarchicalSettings getHierarchicalSettings() {
        return this.m_hierarchicalSettings;
    }

    public int getLayoutCalculationTimeWarningThreshold() {
        return this.m_type == null ? this.m_layoutCalculationTimeWarningThreshold : this.m_type.getLayoutCalculationThreshold();
    }

    public ZyGraphOrthogonalSettings getOrthogonalSettings() {
        return this.m_orthogonalSettings;
    }

    public int getVisibilityWarningTreshold() {
        return this.m_type == null ? this.m_visibilityWarningThreshold : this.m_type.getVisibilityWarningThreshold();
    }

    public void removeListener(IZyGraphLayoutSettingsListener iZyGraphLayoutSettingsListener) {
        this.m_listeners.removeListener(iZyGraphLayoutSettingsListener);
    }

    public void setAnimateLayout(boolean bl2) {
        if (bl2 == this.getAnimateLayout()) {
            return;
        }
        if (this.m_type == null) {
            this.m_layoutAnimation = bl2;
        } else {
            this.m_type.setLayoutAnimation(bl2);
        }
    }

    public void setAutolayoutActivisionThreshold(int n2) {
        Preconditions.checkArgument(n2 >= 0, "IE00901: Threshold value must not be negative");
        if (n2 == this.getAutolayoutDeactivationThreshold()) {
            return;
        }
        if (this.m_type == null) {
            this.m_autoLayoutDeactivationThreshold = n2;
        } else {
            this.m_type.setAnimationSpeed(n2);
        }
    }

    public void setAutomaticLayouting(boolean bl2) {
        if (bl2 == this.getAutomaticLayouting()) {
            return;
        }
        if (this.m_type == null) {
            this.m_automaticLayouting = bl2;
        } else {
            this.m_type.setAutomaticLayouting(bl2);
        }
        for (IZyGraphLayoutSettingsListener iZyGraphLayoutSettingsListener : this.m_listeners) {
            try {
                iZyGraphLayoutSettingsListener.changedAutomaticLayouting(bl2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setDefaultGraphLayout(LayoutStyle layoutStyle) {
        Preconditions.checkNotNull(layoutStyle, "IE00876: Graph layout argument can't be null");
        if (this.m_type == null) {
            this.m_defaultGraphLayout = layoutStyle;
        } else {
            this.m_type.setDefaultGraphLayout(layoutStyle.ordinal());
        }
        this.updateLayouter();
    }

    public void setLayoutCalculationTimeWarningThreshold(int n2) {
        Preconditions.checkArgument(n2 >= 0, "IE00880: Threshold argument must not be negative");
        if (n2 == this.getLayoutCalculationTimeWarningThreshold()) {
            return;
        }
        if (this.m_type == null) {
            this.m_layoutCalculationTimeWarningThreshold = n2;
        } else {
            this.m_type.setLayoutCalculationThreshold(n2);
        }
    }

    public void setVisibilityWarningThreshold(int n2) {
        Preconditions.checkArgument(n2 >= 0, "IE00893: Threshold argument must not be negative");
        if (n2 == this.getVisibilityWarningTreshold()) {
            return;
        }
        if (this.m_type == null) {
            this.m_visibilityWarningThreshold = n2;
        } else {
            this.m_type.setVisibilityWarningThreshold(n2);
        }
    }
}

