/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Model;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.CGraphSearchResultsCursor;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.CGraphSearchSettings;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.CNodeSearcher;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.CResultFilter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.CSearchResultComparator;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.IGraphSearchSettingsListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Model.CEdgeSearcher;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GraphSearcher {
    private final CGraphSearchSettings m_settings = new CGraphSearchSettings();
    private final CGraphSearchResultsCursor m_cursor = new CGraphSearchResultsCursor();
    private final List<SearchResult> m_results = new ArrayList<SearchResult>();
    private boolean m_changed = true;
    private String m_lastSearchString;
    private final IGraphSearchSettingsListener m_internalSettingsListener = new InternalSettingsListener();

    public GraphSearcher() {
        this.m_settings.addListener(this.m_internalSettingsListener);
    }

    private void searchAll(List<NaviNode> list, List<NaviEdge> list2, String string2) {
        for (NaviNode object : list) {
            this.searchNode(object, string2);
        }
        for (NaviEdge naviEdge : list2) {
            this.searchEdge(naviEdge, string2);
        }
    }

    private void searchEdge(NaviEdge naviEdge, String string2) {
        this.m_results.addAll(CEdgeSearcher.search(naviEdge, string2, this.m_settings.isRegEx(), this.m_settings.isCaseSensitive()));
        if (!this.m_results.isEmpty()) {
            this.m_cursor.reset();
        }
    }

    private void searchNode(NaviNode naviNode, String string2) {
        this.m_results.addAll(CNodeSearcher.search(naviNode, string2, this.m_settings.isRegEx(), this.m_settings.isCaseSensitive()));
        if (!this.m_results.isEmpty()) {
            this.m_cursor.reset();
        }
    }

    public void clearResults() {
        for (SearchResult searchResult : this.m_results) {
            if (searchResult.getObject() instanceof NaviNode) {
                ((NaviNode)searchResult.getObject()).setBackgroundColor(searchResult.getLine(), searchResult.getPosition(), searchResult.getLength(), null);
                continue;
            }
            if (!(searchResult.getObject() instanceof NaviEdge)) continue;
            NaviEdge naviEdge = (NaviEdge)searchResult.getObject();
            ZyLabelContent zyLabelContent = naviEdge.getLabelContent();
            zyLabelContent.getLineContent(searchResult.getLine()).setBackgroundColor(searchResult.getPosition(), searchResult.getLength(), null);
        }
        this.m_results.clear();
        this.m_cursor.clear();
        this.m_changed = false;
    }

    public void dispose() {
        this.m_settings.removeListener(this.m_internalSettingsListener);
    }

    public CGraphSearchResultsCursor getCursor() {
        return this.m_cursor;
    }

    public String getLastSearchString() {
        return this.m_lastSearchString;
    }

    public List<SearchResult> getResults() {
        return new ArrayList<SearchResult>(this.m_results);
    }

    public CGraphSearchSettings getSettings() {
        return this.m_settings;
    }

    public boolean hasChanged() {
        return this.m_changed;
    }

    public void search(List<NaviNode> list, List<NaviEdge> list2, String string2) {
        this.m_lastSearchString = string2;
        this.clearResults();
        List<NaviNode> list3 = CResultFilter.filteredNodes(list, this.m_settings.isOnlySelected(), this.m_settings.isOnlyVisible());
        List<NaviEdge> list4 = CResultFilter.filteredEdges(list2, this.m_settings.isOnlySelected(), this.m_settings.isOnlyVisible());
        this.searchAll(list3, list4, string2);
        Collections.sort(this.m_results, new CSearchResultComparator());
        this.m_cursor.setResults(this.m_results);
    }

    private class InternalSettingsListener
    implements IGraphSearchSettingsListener {
        private InternalSettingsListener() {
        }

        @Override
        public void changedCaseSensitive() {
            GraphSearcher.this.m_changed = true;
        }

        @Override
        public void changedOnlySelected() {
            GraphSearcher.this.m_changed = true;
        }

        @Override
        public void changedOnlyVisible() {
            GraphSearcher.this.m_changed = true;
        }

        @Override
        public void changedRegEx() {
            GraphSearcher.this.m_changed = true;
        }
    }
}

