/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Gui;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Gui.IGraphSearchFieldListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Gui.CGraphSearchField;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.gui.tables.CMonospaceRenderer;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public final class CSearchResultsDialog
extends JDialog {
    private static final long serialVersionUID = -1650099126739368424L;
    private final CGraphSearchField m_searchField;
    private static JLabel m_resultsLabel = new JLabel("");
    private final JTable m_table = new JTable();
    private final IGraphSearchFieldListener m_searchListener = new InternalSearchListener();

    public CSearchResultsDialog(Window window, CGraphSearchField cGraphSearchField) {
        super(window, "Search Results");
        this.m_searchField = cGraphSearchField;
        this.setResults(this.m_searchField.getGraphSearcher().getResults());
        this.setLayout(new BorderLayout());
        this.m_searchField.addListener(this.m_searchListener);
        this.m_table.setDefaultRenderer(Object.class, new CMonospaceRenderer());
        this.m_table.setSelectionMode(0);
        this.add(new JScrollPane(this.m_table));
        JPanel jPanel = new JPanel();
        jPanel.add(m_resultsLabel);
        this.add((Component)jPanel, "South");
        this.setSize(400, 400);
    }

    private void setResults(List<SearchResult> list) {
        Object[][] objectArray = new Object[list.size()][1];
        int n2 = 0;
        for (SearchResult searchResult : list) {
            String string2;
            ZyLabelContent zyLabelContent;
            Object object;
            if (searchResult.getObject() instanceof NaviNode) {
                object = (NaviNode)searchResult.getObject();
                zyLabelContent = ((NaviNode)object).getRealizer().getNodeContent();
                string2 = zyLabelContent.getLineContent(searchResult.getLine()).getText();
                objectArray[n2++][0] = string2;
                continue;
            }
            if (!(searchResult.getObject() instanceof NaviEdge)) continue;
            object = (NaviEdge)searchResult.getObject();
            zyLabelContent = ((NaviEdge)object).getLabelContent();
            string2 = zyLabelContent.getLineContent(searchResult.getLine()).getText();
            objectArray[n2++][0] = string2;
        }
        this.m_table.setModel(new CResultsTableModel(objectArray, new String[]{"Result"}));
        m_resultsLabel.setText(String.format("%d search results", objectArray.length));
    }

    private class InternalSearchListener
    implements IGraphSearchFieldListener {
        private InternalSearchListener() {
        }

        @Override
        public void searched() {
            CSearchResultsDialog.this.setResults(CSearchResultsDialog.this.m_searchField.getGraphSearcher().getResults());
        }
    }

    private static class CResultsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 7199101380632271213L;

        public CResultsTableModel(Object[][] objectArray, String[] stringArray) {
            super(objectArray, stringArray);
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }
    }
}

