/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.NodeTaggingTree.Nodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CAbstractTagTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTagTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Nodes.CTaggedGraphNodesContainerNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ITagContainerNode;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.jtree.TreeHelpers;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class CRootTagTreeNode
extends CAbstractTagTreeNode
implements ITagContainerNode {
    private static final long serialVersionUID = 1594300346621455654L;
    private final JFrame m_parent;
    private final CTagsTree m_tagsTree;
    private final ITagManager m_tagManager;
    private final ITreeNode<CTag> m_rootTag;
    private final ITagManagerListener m_tagManagerListener = new InternalTagManagerListener();

    public CRootTagTreeNode(JFrame jFrame, CTagsTree cTagsTree, ZyGraph zyGraph, ITagManager iTagManager) {
        super(0, zyGraph);
        this.m_parent = Preconditions.checkNotNull(jFrame, "IE02325: Parent argument can not be null");
        this.m_tagsTree = Preconditions.checkNotNull(cTagsTree, "IE02326: Tags tree argument can not be null");
        this.m_tagManager = Preconditions.checkNotNull(iTagManager, "IE01796: Tag manager can not be null");
        this.m_rootTag = iTagManager.getRootTag();
        this.m_tagManager.addListener(this.m_tagManagerListener);
        this.createChildren();
    }

    private void createChildren() {
        for (ITreeNode<CTag> iTreeNode : this.m_rootTag.getChildren()) {
            this.add(new CTagTreeNode(this.m_parent, this.getGraph(), this.m_tagManager, this.m_tagsTree.getModel(), iTreeNode));
        }
    }

    public void addGraphNodeNodeToTree(INaviViewNode iNaviViewNode, CTaggedGraphNodesContainerNode cTaggedGraphNodesContainerNode) {
        cTaggedGraphNodesContainerNode.add(new CTaggedGraphNodeNode(this.getGraph(), (NaviNode)this.getGraph().getNode(iNaviViewNode)));
    }

    @Override
    public void dispose() {
        this.m_tagManager.removeListener(this.m_tagManagerListener);
        this.deleteChildren();
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return null;
    }

    @Override
    public ITreeNode<CTag> getTag() {
        return this.m_rootTag;
    }

    @Override
    @Deprecated
    public void refreshTree(ITreeNode<CTag> iTreeNode) {
        int n2;
        List<DefaultMutableTreeNode> list = TreeHelpers.getLastExpandedNodes(this.m_tagsTree);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (iTreeNode != null && iTreeNode.getParent() != null) {
            arrayList.add(iTreeNode.getParent().getObject().getId());
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : list) {
            if (!(defaultMutableTreeNode.getUserObject() instanceof Integer)) continue;
            n2 = (Integer)defaultMutableTreeNode.getUserObject();
            arrayList.add(n2);
        }
        this.deleteChildren();
        this.createChildren();
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CAbstractTagTreeNode cAbstractTagTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode;
            defaultMutableTreeNode = enumeration.nextElement();
            n2 = -1;
            TreePath treePath = null;
            if (defaultMutableTreeNode instanceof CRootTagTreeNode) {
                cAbstractTagTreeNode = (CRootTagTreeNode)defaultMutableTreeNode;
                n2 = this.m_rootTag.getObject().getId();
                treePath = new TreePath(cAbstractTagTreeNode.getPath());
            } else if (defaultMutableTreeNode instanceof CTagTreeNode) {
                cAbstractTagTreeNode = (CTagTreeNode)defaultMutableTreeNode;
                n2 = ((CTagTreeNode)cAbstractTagTreeNode).getTag().getObject().getId();
                treePath = new TreePath(cAbstractTagTreeNode.getPath());
            } else if (defaultMutableTreeNode instanceof CTaggedGraphNodesContainerNode) {
                cAbstractTagTreeNode = (CTaggedGraphNodesContainerNode)defaultMutableTreeNode;
                n2 = -((CTaggedGraphNodesContainerNode)cAbstractTagTreeNode).getTag().getObject().getId();
                treePath = new TreePath(cAbstractTagTreeNode.getPath());
            }
            if (!arrayList.contains(n2)) continue;
            this.m_tagsTree.expandPath(treePath);
        }
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        @Override
        public void addedTag(CTagManager cTagManager, ITreeNode<CTag> iTreeNode) {
            if (((CTag)CRootTagTreeNode.this.m_rootTag.getObject()).getId() == iTreeNode.getParent().getObject().getId()) {
                CRootTagTreeNode.this.refreshTree(iTreeNode);
                CRootTagTreeNode.this.m_tagsTree.getModel().nodeStructureChanged(CRootTagTreeNode.this);
            }
        }

        @Override
        public void deletedTag(CTagManager cTagManager, ITreeNode<CTag> iTreeNode, ITreeNode<CTag> iTreeNode2) {
            if (((CTag)CRootTagTreeNode.this.m_rootTag.getObject()).getId() == iTreeNode.getObject().getId()) {
                CRootTagTreeNode.this.refreshTree(iTreeNode);
                CRootTagTreeNode.this.m_tagsTree.getModel().nodeStructureChanged(CRootTagTreeNode.this.getRoot());
            }
        }

        @Override
        public void deletedTagSubtree(CTagManager cTagManager, ITreeNode<CTag> iTreeNode, ITreeNode<CTag> iTreeNode2) {
            if (((CTag)CRootTagTreeNode.this.m_rootTag.getObject()).getId() == iTreeNode.getObject().getId()) {
                CRootTagTreeNode.this.refreshTree(iTreeNode);
                CRootTagTreeNode.this.m_tagsTree.getModel().nodeStructureChanged(CRootTagTreeNode.this.getRoot());
            }
        }

        @Override
        public void insertedTag(CTagManager cTagManager, ITreeNode<CTag> iTreeNode, ITreeNode<CTag> iTreeNode2) {
            if (((CTag)CRootTagTreeNode.this.m_rootTag.getObject()).getId() == iTreeNode2.getParent().getObject().getId()) {
                CRootTagTreeNode.this.refreshTree(iTreeNode2);
                CRootTagTreeNode.this.m_tagsTree.getModel().nodeStructureChanged(CRootTagTreeNode.this.getRoot());
            }
        }
    }
}

