/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.RegisterTracker.CTracking;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.InitialTab;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.ICodeNodeExtension;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphOpener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphZoomer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CLineGrayer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CLineHighlighter;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Wrappers.CGlobalNodeCommentWrapper;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.Wrappers.CLocalNodeCommentWrapper;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.CNodeFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.ZyGraphPopupMenus;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Implementations.CGraphDialogs;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.reil.algorithms.mono2.common.enums.AnalysisDirection;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterTrackingOptions;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.disassembly.IReference;
import com.google.security.zynamics.zylib.disassembly.ReferenceType;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyNodeContentHelpers;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPopupMenu;

public final class CNodeClickHandler {
    private final CGraphModel m_model;
    private final CLineGrayer m_grayer = new CLineGrayer();
    private final CLineHighlighter m_highlighter = new CLineHighlighter();

    public CNodeClickHandler(CGraphModel cGraphModel) {
        this.m_model = Preconditions.checkNotNull(cGraphModel, "IE01628: Model argument can not be null");
    }

    private void collectReferences(IOperandTreeNode iOperandTreeNode, Set<IAddress> set) {
        for (IReference object : iOperandTreeNode.getReferences()) {
            if (!ReferenceType.isCodeReference(object.getType())) continue;
            set.add(object.getTarget());
        }
        for (IOperandTreeNode iOperandTreeNode2 : iOperandTreeNode.getChildren()) {
            this.collectReferences(iOperandTreeNode2, set);
        }
    }

    private void handleBreakpointClick(NaviNode naviNode, double d2) {
        if (naviNode.getRawNode() instanceof INaviCodeNode) {
            int n2 = naviNode.positionToRow(d2 - naviNode.getY());
            CGraphDebugger.toggleBreakpoint(this.m_model.getDebuggerProvider(), (INaviCodeNode)naviNode.getRawNode(), n2);
        } else if (naviNode.getRawNode() instanceof INaviFunctionNode) {
            CGraphDebugger.toggleBreakpoint(this.m_model.getDebuggerProvider(), (INaviFunctionNode)naviNode.getRawNode());
        }
    }

    private void handleRightClick(NaviNode naviNode, MouseEvent mouseEvent, double d2, double d3, List<ICodeNodeExtension> list) {
        Object object = ZyNodeContentHelpers.getObject(naviNode, d2, d3);
        if (mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
            this.m_grayer.handleGrayLine(this.m_model, naviNode, d3);
        } else if (mouseEvent.isAltDown() && mouseEvent.isControlDown()) {
            this.m_highlighter.handleHighlightLine(naviNode, d3);
        } else if (mouseEvent.isAltDown()) {
            if (object instanceof CLocalNodeCommentWrapper) {
                CNodeFunctions.editNodeComments(this.m_model, ((CLocalNodeCommentWrapper)object).getNode(), InitialTab.LocalNodeComments);
            } else if (object instanceof CGlobalNodeCommentWrapper) {
                CNodeFunctions.editNodeComments(this.m_model, ((CGlobalNodeCommentWrapper)object).getNode(), InitialTab.GlobalNodeComments);
            } else if (naviNode.getRawNode() instanceof INaviCodeNode) {
                this.handleShowInstructionComment(naviNode, d3);
            }
        } else if (mouseEvent.isShiftDown()) {
            this.handleBreakpointClick(naviNode, d3);
        } else if (mouseEvent.isControlDown() && object instanceof COperandTreeNode) {
            this.handleDoRegisterTrackingDown(naviNode, d3, d2, (COperandTreeNode)object);
        } else if (mouseEvent.isControlDown() && mouseEvent.isShiftDown() && object instanceof COperandTreeNode) {
            this.handleDoRegisterTrackingUp(naviNode, d3, d2, (COperandTreeNode)object);
        } else {
            this.showPopupMenu(naviNode, mouseEvent, object, d3, list);
        }
    }

    private void handleDoRegisterTrackingDown(NaviNode naviNode, double d2, double d3, COperandTreeNode cOperandTreeNode) {
        this.handleRegisterTracking(naviNode, d2, cOperandTreeNode, AnalysisDirection.DOWN);
    }

    private void handleRegisterTracking(NaviNode naviNode, double d2, COperandTreeNode cOperandTreeNode, AnalysisDirection analysisDirection) {
        double d3;
        int n2;
        if (!(naviNode.getRawNode() instanceof INaviCodeNode)) {
            return;
        }
        INaviCodeNode iNaviCodeNode = (INaviCodeNode)naviNode.getRawNode();
        INaviInstruction iNaviInstruction = CCodeNodeHelpers.lineToInstruction(iNaviCodeNode, n2 = naviNode.positionToRow(d3 = d2 - naviNode.getY()));
        if (iNaviInstruction == null) {
            return;
        }
        if (!cOperandTreeNode.getType().equals((Object)ExpressionType.REGISTER)) {
            return;
        }
        HashSet<String> hashSet = Sets.newHashSet();
        if (iNaviInstruction.getArchitecture().equalsIgnoreCase("x86-32")) {
            hashSet.add("eax");
        } else if (iNaviInstruction.getArchitecture().equalsIgnoreCase("x86-64")) {
            hashSet.add("rax");
        } else if (iNaviInstruction.getArchitecture().equalsIgnoreCase("PowerPC-32")) {
            hashSet.addAll(Lists.newArrayList("R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "R11", "R12"));
        } else if (iNaviInstruction.getArchitecture().equalsIgnoreCase("ARM-32")) {
            hashSet.addAll(Lists.newArrayList("r0", "r1", "r2", "r3", "r12", "r14"));
        } else if (iNaviInstruction.getArchitecture().equalsIgnoreCase("MIPS-32")) {
            hashSet.addAll(Lists.newArrayList("$a0", "$a1", "$a2", "$a3", "$t0", "$t1", "$t2", "$t3", "$t4", "$t5", "$t6", "$t7", "$v0", "$v1"));
        } else {
            return;
        }
        boolean bl2 = iNaviInstruction.getOperandPosition(cOperandTreeNode.getOperand()) != 0;
        RegisterTrackingOptions registerTrackingOptions = new RegisterTrackingOptions(false, hashSet, bl2, analysisDirection);
        try {
            CTracking.track(this.m_model.getGraph().getRawView(), iNaviInstruction, cOperandTreeNode.getValue(), registerTrackingOptions);
        }
        catch (InternalTranslationException internalTranslationException) {
            CUtilityFunctions.logException(internalTranslationException);
        }
    }

    private void handleDoRegisterTrackingUp(NaviNode naviNode, double d2, double d3, COperandTreeNode cOperandTreeNode) {
        this.handleRegisterTracking(naviNode, d2, cOperandTreeNode, AnalysisDirection.UP);
    }

    private void handleShowInstructionComment(NaviNode naviNode, double d2) {
        double d3;
        int n2;
        if (!(naviNode.getRawNode() instanceof INaviCodeNode)) {
            return;
        }
        INaviCodeNode iNaviCodeNode = (INaviCodeNode)naviNode.getRawNode();
        INaviInstruction iNaviInstruction = CCodeNodeHelpers.lineToInstruction(iNaviCodeNode, n2 = naviNode.positionToRow(d3 = d2 - naviNode.getY()));
        if (iNaviInstruction == null) {
            return;
        }
        CGraphDialogs.showInstructionCommentDialog(this.m_model.getParent(), this.m_model, iNaviCodeNode, iNaviInstruction);
    }

    private void showPopupMenu(NaviNode naviNode, MouseEvent mouseEvent, Object object, double d2, List<ICodeNodeExtension> list) {
        boolean bl2 = this.m_model.getGraph().getEditMode().getLabelEventHandler().isActiveLabel(naviNode.getRealizer().getNodeContent());
        JPopupMenu jPopupMenu = ZyGraphPopupMenus.getPopupMenu(this.m_model, naviNode, object, d2 - naviNode.getY(), bl2, list);
        if (jPopupMenu != null) {
            jPopupMenu.show(this.m_model.getGraph().getView(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void nodeClicked(NaviNode naviNode, MouseEvent mouseEvent, double d2, double d3, List<ICodeNodeExtension> list) {
        if (mouseEvent.getButton() == 3) {
            this.handleRightClick(naviNode, mouseEvent, d2, d3, list);
        } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && mouseEvent.isControlDown()) {
            INaviViewNode iNaviViewNode = naviNode.getRawNode();
            if (iNaviViewNode instanceof INaviFunctionNode) {
                INaviFunction iNaviFunction = ((INaviFunctionNode)iNaviViewNode).getFunction();
                CGraphOpener.showFunction(this.m_model.getParent(), this.m_model.getViewContainer(), iNaviFunction);
            } else if (iNaviViewNode instanceof INaviCodeNode) {
                INaviCodeNode iNaviCodeNode = (INaviCodeNode)iNaviViewNode;
                int n2 = naviNode.positionToRow(d3 - naviNode.getY());
                INaviInstruction iNaviInstruction = CCodeNodeHelpers.lineToInstruction(iNaviCodeNode, n2);
                if (iNaviInstruction == null) {
                    return;
                }
                HashSet<IAddress> hashSet = new HashSet<IAddress>();
                for (INaviOperandTree object2 : iNaviInstruction.getOperands()) {
                    this.collectReferences(object2.getRootNode(), hashSet);
                }
                List<INaviFunction> list2 = this.m_model.getViewContainer().getFunctions();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    INaviFunction iNaviFunction = (INaviFunction)iterator.next();
                    for (IAddress iAddress : hashSet) {
                        if (!iNaviFunction.getAddress().equals(iAddress)) continue;
                        CGraphOpener.showFunction(this.m_model.getParent(), this.m_model.getViewContainer(), iNaviFunction);
                    }
                }
            }
        } else if (!this.m_model.getGraph().getEditMode().getLabelEventHandler().isActive() && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            if (naviNode.getRawNode() instanceof INaviGroupNode && mouseEvent.isShiftDown()) {
                INaviGroupNode iNaviGroupNode;
                iNaviGroupNode.setCollapsed(!(iNaviGroupNode = (INaviGroupNode)naviNode.getRawNode()).isCollapsed());
            } else {
                CGraphZoomer.zoomNode(this.m_model.getGraph(), naviNode);
            }
        }
    }
}

