/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.ICodeNodeExtension;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CNodeHoverer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Menu.CGraphWindowMenuBar;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.CProximityFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CEdgeMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Menus.CProximityNodeMenu;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CNodeUpdaterInitializer;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.CNodeClickHandler;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviGraphListenerAdapter;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public final class CGraphPanelSynchronizer {
    private final CGraphModel m_model;
    private final CGraphWindowMenuBar m_menuBar;
    private final CNodeClickHandler m_clickHandler;
    private final InternalViewListener m_viewListener = new InternalViewListener();
    private final InternalGraphListener m_graphListener = new InternalGraphListener();
    private boolean closing = false;
    private final List<ICodeNodeExtension> m_codeNodeExtensions = new ArrayList<ICodeNodeExtension>();

    public CGraphPanelSynchronizer(CGraphModel cGraphModel, CGraphWindowMenuBar cGraphWindowMenuBar) {
        this.m_model = Preconditions.checkNotNull(cGraphModel, "IE01618: Model argument can not be null");
        this.m_menuBar = Preconditions.checkNotNull(cGraphWindowMenuBar, "IE01620: Menu bar argument can not be null");
        this.m_clickHandler = new CNodeClickHandler(cGraphModel);
        this.m_model.getGraph().addListener(this.m_graphListener);
        this.m_model.getGraph().getRawView().addListener(this.m_viewListener);
    }

    public void dispose() {
        this.closing = true;
        this.m_model.getGraph().getRawView().removeListener(this.m_viewListener);
        this.m_model.getGraph().removeListener(this.m_graphListener);
    }

    public void registerCodeNodeContextMenuExtension(ICodeNodeExtension iCodeNodeExtension) {
        Preconditions.checkNotNull(iCodeNodeExtension, "IE01621: Extension argument can not be null");
        this.m_codeNodeExtensions.add(iCodeNodeExtension);
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        @Override
        public boolean closingView(INaviView iNaviView) {
            return iNaviView != CGraphPanelSynchronizer.this.m_model.getGraph().getRawView() || CGraphPanelSynchronizer.this.closing;
        }
    }

    private class InternalGraphListener
    extends NaviGraphListenerAdapter {
        private final CNodeHoverer m_nodeHoverer = new CNodeHoverer();
        private final CProximityFunctions m_proximityFunctions = new CProximityFunctions();

        private InternalGraphListener() {
        }

        @Override
        public void addedNode(ZyGraph zyGraph, NaviNode naviNode) {
            CNodeUpdaterInitializer.addUpdaters(CGraphPanelSynchronizer.this.m_model, naviNode);
        }

        @Override
        public void changedModel(ZyGraph zyGraph, NaviNode naviNode) {
            CNodeUpdaterInitializer.addUpdaters(CGraphPanelSynchronizer.this.m_model, naviNode);
        }

        @Override
        public void changedView(INaviView iNaviView, INaviView iNaviView2) {
            iNaviView.removeListener(CGraphPanelSynchronizer.this.m_viewListener);
            iNaviView2.addListener(CGraphPanelSynchronizer.this.m_viewListener);
            CGraphPanelSynchronizer.this.m_menuBar.updateGui();
        }

        @Override
        public void edgeClicked(NaviEdge naviEdge, MouseEvent mouseEvent, double d2, double d3) {
            if (mouseEvent.getButton() == 3) {
                CEdgeMenu cEdgeMenu = new CEdgeMenu(CGraphPanelSynchronizer.this.m_model.getParent(), CGraphPanelSynchronizer.this.m_model.getGraph(), naviEdge);
                cEdgeMenu.show(CGraphPanelSynchronizer.this.m_model.getGraph().getView(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void nodeClicked(NaviNode naviNode, MouseEvent mouseEvent, double d2, double d3) {
            CGraphPanelSynchronizer.this.m_clickHandler.nodeClicked(naviNode, mouseEvent, d2, d3, CGraphPanelSynchronizer.this.m_codeNodeExtensions);
        }

        @Override
        public void nodeHovered(NaviNode naviNode, double d2, double d3) {
            this.m_nodeHoverer.nodeHovered(naviNode, d3);
            CGraphPanelSynchronizer.this.m_model.getGraph().updateViews();
        }

        @Override
        public void nodeLeft(NaviNode naviNode) {
            if (this.m_nodeHoverer.clear(naviNode)) {
                CGraphPanelSynchronizer.this.m_model.getGraph().updateViews();
            }
        }

        @Override
        public void proximityBrowserNodeClicked(ZyProximityNode<?> zyProximityNode, MouseEvent mouseEvent, double d2, double d3) {
            if (mouseEvent.getButton() == 1) {
                if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                    this.m_proximityFunctions.showHiddenNodes(CGraphPanelSynchronizer.this.m_model.getParent(), CGraphPanelSynchronizer.this.m_model.getGraph(), zyProximityNode);
                } else if (mouseEvent.isShiftDown()) {
                    this.m_proximityFunctions.unhideAndSelect(CGraphPanelSynchronizer.this.m_model.getGraph(), zyProximityNode);
                } else if (mouseEvent.isControlDown()) {
                    this.m_proximityFunctions.unhideAndSelectOnly(CGraphPanelSynchronizer.this.m_model.getGraph(), zyProximityNode);
                }
            } else if (mouseEvent.getButton() == 3) {
                CProximityNodeMenu cProximityNodeMenu = new CProximityNodeMenu(CGraphPanelSynchronizer.this.m_model.getParent(), CGraphPanelSynchronizer.this.m_model.getGraph(), zyProximityNode);
                cProximityNodeMenu.show(CGraphPanelSynchronizer.this.m_model.getGraph().getView(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

