/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.IView2DListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewContainer;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.ZyGraph.INaviGraphListener;
import com.google.security.zynamics.binnavi.ZyGraph.LayoutStyle;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.awt.event.MouseEvent;
import java.util.List;
import y.i.N;

public final class View2D {
    private final IDatabase m_database;
    private final IViewContainer m_container;
    private final ZyGraph m_graph;
    private View m_view;
    private final BiMap<INaviViewNode, ViewNode> m_nodeMap = HashBiMap.create();
    private final InternalGraphListener m_listener = new InternalGraphListener();
    private final IPluginInterface m_pluginInterface;
    private final ListenerProvider<IView2DListener> m_listeners = new ListenerProvider();
    private final ViewContainer m_apiContainer;

    public View2D(IDatabase iDatabase, IViewContainer iViewContainer, ZyGraph zyGraph, IPluginInterface iPluginInterface) {
        Preconditions.checkNotNull(iViewContainer, "Error: container argument can not be null");
        Preconditions.checkNotNull(zyGraph, "Error: graph argument can not be null");
        Preconditions.checkNotNull(iPluginInterface, "Error: pluginInterface argument can not be null");
        if (!iViewContainer.isLoaded()) {
            throw new IllegalStateException("View container is not loaded");
        }
        this.m_database = iDatabase;
        this.m_container = iViewContainer;
        this.m_graph = zyGraph;
        this.m_view = View2D.findView(iDatabase, zyGraph.getRawView(), iPluginInterface.getDatabaseManager().getDatabases());
        this.m_apiContainer = View2D.findContainer(iDatabase, iViewContainer, iPluginInterface.getDatabaseManager().getDatabases());
        Preconditions.checkNotNull(this.m_apiContainer, "Error: Can not determine view container");
        this.m_pluginInterface = iPluginInterface;
        for (ViewNode viewNode : this.m_view.getGraph().getNodes()) {
            this.m_nodeMap.put(viewNode.getNative(), viewNode);
        }
        this.m_graph.addListener(this.m_listener);
    }

    private static ViewContainer findContainer(IDatabase iDatabase, IViewContainer iViewContainer, List<Database> list) {
        Database database = ObjectFinders.getObject(iDatabase, list);
        if (iViewContainer.getAddressSpaces() == null) {
            return ObjectFinders.getObject(iViewContainer.getNative(), database.getModules());
        }
        return ObjectFinders.getObject(iViewContainer.getNative(), database.getProjects());
    }

    private static View findView(IDatabase iDatabase, INaviView iNaviView, List<Database> list) {
        Database database = ObjectFinders.getObject(iDatabase, list);
        View view = null;
        for (Module viewContainer : database.getModules()) {
            if (!viewContainer.isLoaded() || (view = ObjectFinders.getObject(iNaviView, viewContainer.getViews())) == null) continue;
            return view;
        }
        for (Project project : database.getProjects()) {
            if (!project.isLoaded() || (view = ObjectFinders.getObject(iNaviView, project.getViews())) == null) continue;
            return view;
        }
        throw new IllegalStateException("Error: Unknown view");
    }

    public void addListener(IView2DListener iView2DListener) {
        this.m_listeners.addListener(iView2DListener);
    }

    public void doCircularLayout() {
        this.m_graph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.CIRCULAR);
        this.m_graph.doLayout();
    }

    public void doHierarchicalLayout() {
        this.m_graph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.HIERARCHIC);
        this.m_graph.doLayout();
    }

    public void doOrthogonalLayout() {
        this.m_graph.getSettings().getLayoutSettings().setDefaultGraphLayout(LayoutStyle.ORTHOGONAL);
        this.m_graph.doLayout();
    }

    public ViewContainer getContainer() {
        return this.m_apiContainer;
    }

    public ViewNode getNode(INaviViewNode iNaviViewNode) {
        return (ViewNode)this.m_nodeMap.get(iNaviViewNode);
    }

    public View getView() {
        return this.m_view;
    }

    public void removeListener(IView2DListener iView2DListener) {
        this.m_listeners.removeListener(iView2DListener);
    }

    public void save() {
        try {
            this.m_graph.save();
        }
        catch (CouldntSaveDataException couldntSaveDataException) {
            throw new com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException(couldntSaveDataException);
        }
    }

    public void saveAs(String string2, String string3) {
        try {
            this.m_graph.saveAs(this.m_container, string2, string3);
        }
        catch (CouldntSaveDataException couldntSaveDataException) {
            throw new com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException(couldntSaveDataException);
        }
    }

    public void setProximityBrowsing(boolean bl2) {
        this.m_graph.getSettings().getProximitySettings().setProximityBrowsing(bl2);
    }

    public String toString() {
        return String.format("View2D '%s'", this.m_view.getName());
    }

    public void updateUI() {
        this.m_graph.updateViews();
    }

    public void zoomToScreen() {
        ZoomFunctions.zoomToScreen(this.m_graph);
    }

    private class InternalGraphListener
    implements INaviGraphListener {
        private InternalGraphListener() {
        }

        @Override
        public void addedNode(ZyGraph zyGraph, NaviNode naviNode) {
        }

        @Override
        public void changedModel(ZyGraph zyGraph, NaviNode naviNode) {
        }

        @Override
        public void changedView(INaviView iNaviView, INaviView iNaviView2) {
            View view = View2D.this.m_view;
            View2D.this.m_view = View2D.findView(View2D.this.m_database, View2D.this.m_graph.getRawView(), View2D.this.m_pluginInterface.getDatabaseManager().getDatabases());
            for (IView2DListener iView2DListener : View2D.this.m_listeners) {
                try {
                    iView2DListener.changedView2D(View2D.this, view, View2D.this.m_view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void edgeClicked(NaviEdge naviEdge, MouseEvent mouseEvent, double d2, double d3) {
        }

        @Override
        public void edgeLabelEntered(N n2, MouseEvent mouseEvent) {
        }

        @Override
        public void edgeLabelExited(N n2) {
        }

        @Override
        public void nodeClicked(NaviNode naviNode, MouseEvent mouseEvent, double d2, double d3) {
        }

        @Override
        public void nodeEntered(NaviNode naviNode, MouseEvent mouseEvent) {
        }

        @Override
        public void nodeHovered(NaviNode naviNode, double d2, double d3) {
        }

        @Override
        public void nodeLeft(NaviNode naviNode) {
        }

        @Override
        public void proximityBrowserNodeClicked(ZyProximityNode<?> zyProximityNode, MouseEvent mouseEvent, double d2, double d3) {
        }

        @Override
        public void taggedNode(INaviView iNaviView, INaviViewNode iNaviViewNode, CTag cTag) {
        }

        @Override
        public void untaggedNode(INaviView iNaviView, INaviViewNode iNaviViewNode, CTag cTag) {
        }
    }
}

