/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.pathfinder;

import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.helpers.Logger;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.FilteredTreeModel;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.FunctionTree;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeBlockNode;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.FunctionTreeFunctionNode;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.TextPatternFilter;
import com.google.security.zynamics.binnavi.standardplugins.utils.CDialogEscaper;
import com.google.security.zynamics.binnavi.standardplugins.utils.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreePath;

public final class PathfindingDialog
extends JDialog {
    private final FunctionTree startBlockTree;
    private final FunctionTree endBlockTree;
    private Function startFunction;
    private Function endFunction;
    private BasicBlock startBlock;
    private BasicBlock endBlock;
    private boolean wasCancelled = true;
    private final InternalListener m_listener = new InternalListener();

    public PathfindingDialog(JFrame parent, Module module) {
        super(parent, "Pathfinding", true);
        new CDialogEscaper(this);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        this.startBlockTree = new FunctionTree(this, module);
        this.endBlockTree = new FunctionTree(this, module);
        JTextArea startBlockAsmField = this.createAsmField();
        JTextArea endBlockAsmField = this.createAsmField();
        JTextArea searchFieldStart = new JTextArea(1, 10);
        JTextArea searchFieldEnd = new JTextArea(1, 10);
        searchFieldStart.getDocument().addDocumentListener(new InternalDocumentListener(this.startBlockTree));
        searchFieldEnd.getDocument().addDocumentListener(new InternalDocumentListener(this.endBlockTree));
        this.startBlockTree.addTreeSelectionListener(new InternalTreeSelectionListener(startBlockAsmField));
        this.endBlockTree.addTreeSelectionListener(new InternalTreeSelectionListener(endBlockAsmField));
        JSplitPane splitPaneSearch = new JSplitPane(1, true, new JScrollPane(searchFieldStart), new JScrollPane(searchFieldEnd));
        splitPaneSearch.setResizeWeight(0.5);
        JSplitPane splitPane = new JSplitPane(1, true, new JScrollPane(this.startBlockTree), new JScrollPane(this.endBlockTree));
        splitPane.setResizeWeight(0.5);
        JPanel upperPanel = new JPanel(new BorderLayout());
        upperPanel.add(splitPane);
        upperPanel.add((Component)splitPaneSearch, "North");
        JPanel previewPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane2 = new JSplitPane(1, true, new JScrollPane(startBlockAsmField), new JScrollPane(endBlockAsmField));
        splitPane2.setResizeWeight(0.5);
        previewPanel.add(splitPane2);
        upperPanel.add((Component)previewPanel, "South");
        topPanel.add(upperPanel);
        splitPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)topPanel, "Center");
        this.add((Component)new CPanelTwoButtons(this.m_listener, "OK", "Cancel"), "South");
        this.setPreferredSize(new Dimension(800, 500));
        this.pack();
    }

    private JTextArea createAsmField() {
        JTextArea asmField = new JTextArea(10, 30);
        asmField.setFont(GuiHelper.MONOSPACED_FONT);
        asmField.setEditable(false);
        return asmField;
    }

    public BasicBlock getEndBlock() {
        return this.endBlock;
    }

    public Function getEndFunction() {
        return this.endFunction;
    }

    public BasicBlock getStartBlock() {
        return this.startBlock;
    }

    public Function getStartFunction() {
        return this.startFunction;
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private static class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private final JTextArea m_field;

        public InternalTreeSelectionListener(JTextArea field) {
            this.m_field = field;
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath path = event.getPath();
            if (path == null) {
                return;
            }
            Object selectedNode = path.getLastPathComponent();
            if (selectedNode instanceof FunctionTreeBlockNode) {
                FunctionTreeBlockNode blockNode = (FunctionTreeBlockNode)selectedNode;
                BasicBlock basicBlock = blockNode.getBasicBlock();
                StringBuilder text2 = new StringBuilder("");
                for (Instruction instruction : basicBlock.getInstructions()) {
                    text2.append(String.valueOf(instruction.toString()).concat("\n"));
                }
                this.m_field.setText(text2.toString());
                this.m_field.setCaretPosition(0);
            } else {
                this.m_field.setText("");
            }
        }
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        private BasicBlock getSelectedBlock(FunctionTree tree) {
            TreePath path = tree.getSelectionPath();
            if (path == null) {
                return null;
            }
            Object component = path.getLastPathComponent();
            if (component instanceof FunctionTreeBlockNode) {
                return ((FunctionTreeBlockNode)component).getBasicBlock();
            }
            return null;
        }

        private Function getSelectedFunction(FunctionTree tree) {
            TreePath path = tree.getSelectionPath();
            if (path == null) {
                return null;
            }
            Object component = path.getLastPathComponent();
            if (component instanceof FunctionTreeFunctionNode) {
                return ((FunctionTreeFunctionNode)component).getFunction();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (e2.getActionCommand().equals("OK")) {
                PathfindingDialog.this.startBlock = this.getSelectedBlock(PathfindingDialog.this.startBlockTree);
                PathfindingDialog.this.endBlock = this.getSelectedBlock(PathfindingDialog.this.endBlockTree);
                PathfindingDialog.this.startFunction = this.getSelectedFunction(PathfindingDialog.this.startBlockTree);
                PathfindingDialog.this.endFunction = this.getSelectedFunction(PathfindingDialog.this.endBlockTree);
                PathfindingDialog.this.wasCancelled = false;
            }
            PathfindingDialog.this.startBlockTree.dispose();
            PathfindingDialog.this.endBlockTree.dispose();
            PathfindingDialog.this.dispose();
        }
    }

    private static class InternalDocumentListener
    implements DocumentListener {
        private final JTree m_tree;

        public InternalDocumentListener(JTree tree) {
            this.m_tree = tree;
        }

        private void updateTreeModel(DocumentEvent e2) {
            try {
                String s2 = e2.getDocument().getText(0, e2.getDocument().getLength());
                FilteredTreeModel treeModel = (FilteredTreeModel)this.m_tree.getModel();
                treeModel.setFilter(new TextPatternFilter(s2));
            }
            catch (BadLocationException e1) {
                Logger.logException(e1);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e2) {
            this.updateTreeModel(e2);
        }

        @Override
        public void insertUpdate(DocumentEvent e2) {
            this.updateTreeModel(e2);
        }

        @Override
        public void removeUpdate(DocumentEvent e2) {
            this.updateTreeModel(e2);
        }
    }
}

