/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.pathfinder;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.ModuleListenerAdapter;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.helpers.IProgressThread;
import com.google.security.zynamics.binnavi.API.helpers.Logger;
import com.google.security.zynamics.binnavi.API.helpers.MessageBox;
import com.google.security.zynamics.binnavi.API.helpers.ProgressDialog;
import com.google.security.zynamics.binnavi.API.plugins.IModuleMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.PathFinder;
import com.google.security.zynamics.binnavi.standardplugins.pathfinder.PathfindingDialog;
import com.google.security.zynamics.binnavi.standardplugins.utils.GuiHelper;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public final class PathfinderPlugin
implements IModuleMenuPlugin {
    private IPluginInterface pluginInterface;

    private void showPathfindingDialog(Module module) throws CouldntLoadDataException {
        Preconditions.checkArgument(module.isLoaded(), "Internal Error: Target module is not loaded");
        PathfindingDialog dlg = new PathfindingDialog(this.pluginInterface.getMainWindow().getFrame(), module);
        GuiHelper.centerChildToParent(this.pluginInterface.getMainWindow().getFrame(), dlg, true);
        dlg.setVisible(true);
        if (dlg.wasCancelled()) {
            return;
        }
        BasicBlock sourceBlock = dlg.getStartBlock();
        BasicBlock targetBlock = dlg.getEndBlock();
        Function firstFunction = dlg.getStartFunction();
        Function secondFunction = dlg.getEndFunction();
        firstFunction.load();
        secondFunction.load();
        final CreationThread creationThread = new CreationThread(module, sourceBlock, targetBlock, firstFunction, secondFunction);
        ProgressDialog.show(this.pluginInterface.getMainWindow().getFrame(), "Creating path ...", creationThread);
        if (!creationThread.threwException() && creationThread.getCreatedView() == null) {
            MessageBox.showInformation(this.pluginInterface.getMainWindow().getFrame(), "There is no path between the two selected blocks");
        } else {
            new Thread(){

                @Override
                public void run() {
                    PluginInterface.instance().showInNewWindow(creationThread.getCreatedView());
                }
            }.start();
        }
    }

    @Override
    public List<JComponent> extendModuleMenu(List<Module> modules) {
        ArrayList<JComponent> menus = new ArrayList<JComponent>();
        if (modules.size() == 1) {
            Module targetModule = modules.get(0);
            menus.add(new JMenuItem(new PathfindingAction(targetModule)));
        }
        return menus;
    }

    @Override
    public String getDescription() {
        return "Finds paths between basic blocks of an executable";
    }

    @Override
    public long getGuid() {
        return 4523525670943L;
    }

    @Override
    public String getName() {
        return "Pathfinding Plugin";
    }

    @Override
    public void init(IPluginInterface pluginProvider) {
        this.pluginInterface = pluginProvider;
    }

    @Override
    public void unload() {
    }

    private class PathfindingAction
    extends AbstractAction {
        private final Module m_module;
        private final ActionUpdater m_updater;

        public PathfindingAction(Module module) {
            super("Pathfinder");
            this.m_updater = new ActionUpdater(this);
            this.m_module = module;
            this.setEnabled(module.isLoaded());
            this.m_module.addListener(this.m_updater);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                PathfinderPlugin.this.showPathfindingDialog(this.m_module);
            }
            catch (CouldntLoadDataException exception) {
                Logger.logException(exception);
                MessageBox.showException(PathfinderPlugin.this.pluginInterface.getMainWindow().getFrame(), exception, "Could not create path");
            }
        }
    }

    private class CreationThread
    implements IProgressThread {
        private final Module module;
        private final BasicBlock sourceBlock;
        private final BasicBlock targetBlock;
        private final Function firstFunction;
        private final Function secondFunction;
        private View view;
        private boolean threwException = true;

        public CreationThread(Module module, BasicBlock sourceBlock, BasicBlock targetBlock, Function firstFunction, Function secondFunction) {
            this.module = module;
            this.sourceBlock = sourceBlock;
            this.targetBlock = targetBlock;
            this.firstFunction = firstFunction;
            this.secondFunction = secondFunction;
        }

        @Override
        public boolean close() {
            return false;
        }

        public View getCreatedView() {
            return this.view;
        }

        @Override
        public void run() {
            try {
                this.view = PathFinder.createPath(this.module, this.sourceBlock, this.targetBlock, this.firstFunction, this.secondFunction);
                this.threwException = false;
            }
            catch (Exception e2) {
                Logger.logException(e2);
                MessageBox.showException(PathfinderPlugin.this.pluginInterface.getMainWindow().getFrame(), e2, "Could not create path");
            }
        }

        public boolean threwException() {
            return this.threwException;
        }
    }

    private static class ActionUpdater
    extends ModuleListenerAdapter {
        private final AbstractAction m_action;

        public ActionUpdater(AbstractAction action) {
            this.m_action = action;
        }

        @Override
        public void loadedModule(Module module) {
            this.m_action.setEnabled(true);
        }
    }
}

