/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.pathfinder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.BlockEdge;
import com.google.security.zynamics.binnavi.API.disassembly.Callgraph;
import com.google.security.zynamics.binnavi.API.disassembly.CodeNode;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.EdgeType;
import com.google.security.zynamics.binnavi.API.disassembly.FlowGraph;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionBlock;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionNode;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionType;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Operand;
import com.google.security.zynamics.binnavi.API.disassembly.OperandExpression;
import com.google.security.zynamics.binnavi.API.disassembly.PartialLoadException;
import com.google.security.zynamics.binnavi.API.disassembly.Reference;
import com.google.security.zynamics.binnavi.API.disassembly.ReferenceType;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewEdge;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.API.helpers.GraphAlgorithms;
import com.google.security.zynamics.binnavi.API.helpers.Logger;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PathFinder {
    private static final Color DEFAULT_BLOCK_COLOR = new Color(-68902);
    private static final Color DEFAULT_INLINING_EDGE_COLOR = new Color(-3360768);
    private static final Color DEFAULT_TRUE_JUMP_COLOR = new Color(-16736256);
    private static final Color DEFAULT_FALSE_JUMP_COLOR = new Color(-6291456);

    private static boolean callsFunction(Instruction instruction, Function function) {
        for (Operand operand : instruction.getOperands()) {
            OperandExpression rootNode = operand.getRootNode();
            if (!PathFinder.hasFunctionCallReference(rootNode, function)) continue;
            return true;
        }
        return false;
    }

    private static NodePair connectFunctions(View view, ViewNode startNode, ViewNode targetNode, Collection<FunctionBlock> passedFunctions, Map<Function, ViewNode> entryNodes, ArrayListMultimap<Function, ViewNode> exitNodes, Map<ViewNode, Function> functionMap) {
        boolean splitNode;
        ViewNode realStartNode = startNode;
        ViewNode realTargetNode = targetNode;
        HashSet<ViewNode> handled = new HashSet<ViewNode>();
        block0: do {
            splitNode = false;
            for (ViewNode node : view.getGraph().getNodes()) {
                if (handled.contains(node) || !(node instanceof CodeNode)) continue;
                CodeNode cnode = (CodeNode)node;
                for (Instruction instruction : cnode.getInstructions()) {
                    for (FunctionBlock functionBlock : passedFunctions) {
                        ViewEdge enterEdge;
                        Function function = functionBlock.getFunction();
                        if (!PathFinder.callsFunction(instruction, function)) continue;
                        NodePair result = PathFinder.splitBlock(view, functionMap.get(cnode), cnode, instruction);
                        if (realStartNode == cnode) {
                            realStartNode = result.getFirst();
                        }
                        if (realTargetNode == cnode) {
                            realTargetNode = result.getFirst();
                        }
                        for (FunctionBlock functionBlock2 : passedFunctions) {
                            Function function2 = functionBlock2.getFunction();
                            if (entryNodes.get(function2) == cnode) {
                                entryNodes.put(function2, result.getFirst());
                            }
                            if (!exitNodes.get((Object)function2).contains(cnode) || result.getSecond() == null) continue;
                            exitNodes.remove(function2, cnode);
                            exitNodes.put((Object)function2, (Object)result.getSecond());
                        }
                        if (functionMap.containsKey(cnode)) {
                            Function f2 = functionMap.get(cnode);
                            functionMap.remove(cnode);
                            functionMap.put(result.getFirst(), f2);
                        }
                        handled.add(result.getFirst());
                        if (result.getSecond() == null) {
                            for (ViewEdge edge : node.getOutgoingEdges()) {
                                for (ViewNode currentExitNode : exitNodes.get((Object)function)) {
                                    ViewEdge leaveEdge = view.createEdge(currentExitNode, edge.getTarget(), EdgeType.LeaveInlinedFunction);
                                    leaveEdge.setColor(DEFAULT_INLINING_EDGE_COLOR);
                                }
                                view.deleteEdge(edge);
                            }
                            enterEdge = view.createEdge(result.getFirst(), entryNodes.get(function), EdgeType.EnterInlinedFunction);
                            enterEdge.setColor(DEFAULT_INLINING_EDGE_COLOR);
                            handled.add(cnode);
                        } else {
                            enterEdge = view.createEdge(result.getFirst(), entryNodes.get(function), EdgeType.EnterInlinedFunction);
                            enterEdge.setColor(DEFAULT_INLINING_EDGE_COLOR);
                            for (ViewNode currentExitNode : exitNodes.get((Object)function)) {
                                ViewEdge leaveEdge = view.createEdge(currentExitNode, result.getSecond(), EdgeType.LeaveInlinedFunction);
                                leaveEdge.setColor(DEFAULT_INLINING_EDGE_COLOR);
                            }
                        }
                        splitNode = true;
                        continue block0;
                    }
                }
                handled.add(cnode);
            }
        } while (splitNode);
        return new NodePair(realStartNode, realTargetNode);
    }

    private static void createInitialBlocks(View view, Collection<FunctionBlock> passedFunctions, Map<BasicBlock, ViewNode> nodeMap, Map<ViewNode, Function> functionMap) throws CouldntLoadDataException {
        for (FunctionBlock functionBlock : passedFunctions) {
            Function function = functionBlock.getFunction();
            if (function.getType() == FunctionType.Import) {
                FunctionNode newNode = view.createFunctionNode(function);
                functionMap.put(newNode, function);
                continue;
            }
            function.load();
            for (BasicBlock block : function.getGraph().getNodes()) {
                CodeNode newNode = view.createCodeNode(function, block.getInstructions());
                newNode.setColor(DEFAULT_BLOCK_COLOR);
                nodeMap.put(block, newNode);
                functionMap.put(newNode, function);
            }
        }
    }

    private static void createInitialEdges(View view, Collection<FunctionBlock> passedFunctions, Map<BasicBlock, ViewNode> nodeMap) {
        for (FunctionBlock functionBlock : passedFunctions) {
            Function function = functionBlock.getFunction();
            for (BlockEdge edge : function.getGraph().getEdges()) {
                ViewEdge newEdge = view.createEdge(nodeMap.get(edge.getSource()), nodeMap.get(edge.getTarget()), edge.getType());
                newEdge.setColor(PathFinder.getEdgeColor(edge));
            }
        }
    }

    private static void deleteNodesNotOnPath(View view, ViewNode startNode, ViewNode targetNode) {
        Set<ViewNode> succs = GraphAlgorithms.getSuccessors(startNode);
        Set<ViewNode> preds = GraphAlgorithms.getPredecessors(targetNode);
        HashSet<ViewNode> combined = new HashSet<ViewNode>(succs);
        combined.retainAll(preds);
        combined.add(startNode);
        combined.add(targetNode);
        ArrayList<ViewNode> nodesToDelete = new ArrayList<ViewNode>();
        for (ViewNode node : view.getGraph().getNodes()) {
            if (combined.contains(node)) continue;
            nodesToDelete.add(node);
        }
        for (ViewNode node : nodesToDelete) {
            view.deleteNode(node);
        }
    }

    private static FunctionBlock findBlock(Callgraph callgraph, Function function) {
        for (FunctionBlock callgraphNode : callgraph) {
            if (function != callgraphNode.getFunction()) continue;
            return callgraphNode;
        }
        throw new IllegalStateException("Error: Call graph node of unknown function");
    }

    private static void findEntryExitNodes(Collection<FunctionBlock> passedFunctions, Map<BasicBlock, ViewNode> nodeMap, Map<ViewNode, Function> functionMap, Map<Function, ViewNode> entryNodes, ArrayListMultimap<Function, ViewNode> exitNodes) {
        Function function;
        for (FunctionBlock functionBlock : passedFunctions) {
            function = functionBlock.getFunction();
            if (function.getType() == FunctionType.Import) continue;
            entryNodes.put(function, nodeMap.get(PathFinder.findEntryNode(function)));
            for (BasicBlock block : PathFinder.findExitNode(function.getGraph())) {
                exitNodes.put((Object)function, (Object)nodeMap.get(block));
            }
        }
        for (Map.Entry entry : functionMap.entrySet()) {
            function = (Function)entry.getValue();
            if (function.getType() != FunctionType.Import) continue;
            ViewNode node = (ViewNode)entry.getKey();
            entryNodes.put(function, node);
            exitNodes.put((Object)function, (Object)node);
        }
    }

    private static BasicBlock findEntryNode(Function function) {
        for (BasicBlock block : function.getGraph()) {
            if (!block.getAddress().equals(function.getAddress())) continue;
            return block;
        }
        throw new IllegalStateException("Error: The given function has no block with the same address as the function address which is an illegal state");
    }

    private static List<BasicBlock> findExitNode(FlowGraph graph) {
        ArrayList<BasicBlock> exitNodes = new ArrayList<BasicBlock>();
        for (BasicBlock block : graph) {
            if (block.getChildren().size() != 0) continue;
            exitNodes.add(block);
        }
        return exitNodes;
    }

    private static LinkedHashSet<FunctionBlock> findPassedFunctions(Callgraph callgraph, Function startFunction, Function targetFunction) {
        FunctionBlock sourceCallgraphNode = PathFinder.findBlock(callgraph, startFunction);
        FunctionBlock targetCallgraphNode = PathFinder.findBlock(callgraph, targetFunction);
        Logger.info("Source block: %s\n", sourceCallgraphNode.getFunction().getName());
        Logger.info("Target block: %s\n", targetCallgraphNode.getFunction().getName());
        Set<FunctionBlock> successorFunctions = GraphAlgorithms.getSuccessors(sourceCallgraphNode);
        Set<FunctionBlock> predecessorFunctions = GraphAlgorithms.getPredecessors(targetCallgraphNode);
        LinkedHashSet<FunctionBlock> sharedFunctions = new LinkedHashSet<FunctionBlock>(successorFunctions);
        sharedFunctions.retainAll(predecessorFunctions);
        sharedFunctions.add(sourceCallgraphNode);
        sharedFunctions.add(targetCallgraphNode);
        return sharedFunctions;
    }

    private static Color getEdgeColor(BlockEdge edge) {
        switch (edge.getType()) {
            case JumpConditionalTrue: {
                return DEFAULT_TRUE_JUMP_COLOR;
            }
            case JumpConditionalFalse: {
                return DEFAULT_FALSE_JUMP_COLOR;
            }
        }
        return Color.BLACK;
    }

    private static boolean hasFunctionCallReference(OperandExpression expression, Function function) {
        List<Reference> references = expression.getReferences();
        for (Reference reference : references) {
            if (reference == null || !ReferenceType.isCodeReference(reference.getType()) || !function.getAddress().equals(reference.getTarget())) continue;
            return true;
        }
        for (OperandExpression node : expression.getChildren()) {
            if (!PathFinder.hasFunctionCallReference(node, function)) continue;
            return true;
        }
        return false;
    }

    private static NodePair splitBlock(View view, Function function, CodeNode node, Instruction instruction) {
        ViewEdge newEdge;
        boolean before = true;
        ArrayList<Instruction> beforeInstructions = new ArrayList<Instruction>();
        ArrayList<Instruction> afterInstructions = new ArrayList<Instruction>();
        for (Instruction nodeInstruction : node.getInstructions()) {
            if (before) {
                beforeInstructions.add(nodeInstruction);
            } else {
                afterInstructions.add(nodeInstruction);
            }
            if (nodeInstruction != instruction) continue;
            before = false;
        }
        if (afterInstructions.isEmpty()) {
            return new NodePair(node, null);
        }
        CodeNode firstNode = view.createCodeNode(function, beforeInstructions);
        CodeNode secondNode = view.createCodeNode(function, afterInstructions);
        firstNode.setColor(node.getColor());
        secondNode.setColor(DEFAULT_BLOCK_COLOR);
        for (ViewEdge edge : node.getIncomingEdges()) {
            newEdge = view.createEdge(edge.getSource(), firstNode, edge.getType());
            newEdge.setColor(edge.getColor());
        }
        for (ViewEdge edge : node.getOutgoingEdges()) {
            newEdge = view.createEdge(secondNode, edge.getTarget(), edge.getType());
            newEdge.setColor(edge.getColor());
        }
        view.deleteNode(node);
        return new NodePair(firstNode, secondNode);
    }

    public static View createPath(Module module, BasicBlock startBlock, BasicBlock targetBlock, Function startFunction, Function targetFunction) throws CouldntLoadDataException, PartialLoadException {
        Function realTargetFunction;
        Preconditions.checkNotNull(module, "Error: Module argument can't be null");
        Preconditions.checkArgument(module.isLoaded(), "Error: Module is not loaded");
        if (startBlock == null && startFunction == null) {
            throw new IllegalArgumentException("Error: No valid start given");
        }
        if (targetBlock == null && targetFunction == null) {
            throw new IllegalArgumentException("Error: No valid target given");
        }
        if (startFunction != null && !startFunction.isLoaded()) {
            throw new IllegalArgumentException("Error: Start function is not loaded");
        }
        if (targetFunction != null && !targetFunction.isLoaded()) {
            throw new IllegalArgumentException("Error: Target function is not loaded");
        }
        Function realStartFunction = startFunction != null ? startFunction : startBlock.getParentFunction();
        Function function = realTargetFunction = targetFunction != null ? targetFunction : targetBlock.getParentFunction();
        if (realStartFunction.getGraph().nodeCount() == 0) {
            throw new IllegalArgumentException("Error: Functions with zero nodes can not be used for pathfinding");
        }
        BasicBlock realStartBlock = startBlock != null ? startBlock : PathFinder.findEntryNode(realStartFunction);
        BasicBlock realTargetBlock = targetBlock != null ? targetBlock : PathFinder.findEntryNode(realTargetFunction);
        LinkedHashSet<FunctionBlock> passedFunctions = PathFinder.findPassedFunctions(module.getCallgraph(), realStartFunction, realTargetFunction);
        String endAddress = realTargetBlock != null ? realTargetBlock.getAddress().toHexString() : realTargetFunction.getAddress().toHexString();
        View view = module.createView("New Pathfinder View", String.format("%s -> %s", realStartBlock.getAddress().toHexString(), endAddress));
        view.load();
        HashMap<BasicBlock, ViewNode> nodeMap = new HashMap<BasicBlock, ViewNode>();
        HashMap<Function, ViewNode> entryNodes = new HashMap<Function, ViewNode>();
        ArrayListMultimap<Function, ViewNode> exitNodes = ArrayListMultimap.create();
        HashMap<ViewNode, Function> functionMap = new HashMap<ViewNode, Function>();
        PathFinder.createInitialBlocks(view, passedFunctions, nodeMap, functionMap);
        PathFinder.createInitialEdges(view, passedFunctions, nodeMap);
        PathFinder.findEntryExitNodes(passedFunctions, nodeMap, functionMap, entryNodes, exitNodes);
        ViewNode startNode = (ViewNode)nodeMap.get(realStartBlock);
        ViewNode targetNode = realTargetBlock == null ? (ViewNode)entryNodes.get(realTargetFunction) : (ViewNode)nodeMap.get(realTargetBlock);
        startNode.setColor(Color.GREEN);
        targetNode.setColor(Color.YELLOW);
        NodePair splitResult = PathFinder.connectFunctions(view, startNode, targetNode, passedFunctions, entryNodes, exitNodes, functionMap);
        startNode = splitResult.getFirst();
        targetNode = splitResult.getSecond();
        for (ViewEdge edge : targetNode.getOutgoingEdges()) {
            view.deleteEdge(edge);
        }
        PathFinder.deleteNodesNotOnPath(view, startNode, targetNode);
        if (startNode.getOutgoingEdges().isEmpty()) {
            return null;
        }
        try {
            view.save();
        }
        catch (CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
        }
        return view;
    }

    private static class NodePair {
        private final ViewNode m_first;
        private final ViewNode m_second;

        public NodePair(ViewNode first, ViewNode second) {
            this.m_first = first;
            this.m_second = second;
        }

        public ViewNode getFirst() {
            return this.m_first;
        }

        public ViewNode getSecond() {
            return this.m_second;
        }
    }
}

