/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.callresolver;

import com.google.security.zynamics.binnavi.API.debug.MemoryModule;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ResolvedFunction;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OutputListGenerator {
    private static List<Map.Entry<BigInteger, Set<ResolvedFunction>>> sort(Set<Map.Entry<BigInteger, Set<ResolvedFunction>>> entries) {
        ArrayList<Map.Entry<BigInteger, Set<ResolvedFunction>>> entryList = new ArrayList<Map.Entry<BigInteger, Set<ResolvedFunction>>>(entries);
        Collections.sort(entryList, new Comparator<Map.Entry<BigInteger, Set<ResolvedFunction>>>(){

            @Override
            public int compare(Map.Entry<BigInteger, Set<ResolvedFunction>> lhs, Map.Entry<BigInteger, Set<ResolvedFunction>> rhs) {
                return lhs.getKey().compareTo(rhs.getKey());
            }
        });
        return entryList;
    }

    public static String generate(Map<BigInteger, Set<ResolvedFunction>> resolvedAddresses) {
        assert (resolvedAddresses != null);
        StringBuffer buffer = new StringBuffer();
        buffer.append("Resolved the following indirect calls:\n");
        for (Map.Entry<BigInteger, Set<ResolvedFunction>> element : OutputListGenerator.sort(resolvedAddresses.entrySet())) {
            BigInteger start = element.getKey();
            Set<ResolvedFunction> targets = element.getValue();
            buffer.append(String.format("%08X ->\n", start.longValue()));
            for (ResolvedFunction target : targets) {
                String functionName;
                Address functionAddress;
                if (target.getFunction() != null) {
                    Function function = target.getFunction();
                    functionAddress = function.getAddress();
                    String string2 = function.getModule().getName();
                    String string3 = function.getName();
                    functionName = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("!").append(string3).toString();
                    buffer.append(String.format("  %08X (%s)\n", functionAddress.toLong(), functionName));
                    continue;
                }
                if (target.getMemoryModule() != null) {
                    MemoryModule module = target.getMemoryModule();
                    functionAddress = target.getAddress();
                    functionName = String.valueOf(module.getName()).concat("!???");
                    buffer.append(String.format("  %08X (%s)\n", functionAddress.toLong(), functionName));
                    continue;
                }
                Address address = target.getAddress();
                buffer.append(String.format("  %s (%s)\n", address.toHexString().toUpperCase(), "???!???"));
            }
        }
        return buffer.toString();
    }
}

