/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.callresolver;

import com.google.security.zynamics.binnavi.API.debug.BreakpointManager;
import com.google.security.zynamics.binnavi.API.debug.DebugException;
import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.debug.DebuggerBreakpointHitReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerListenerAdapter;
import com.google.security.zynamics.binnavi.API.debug.DebuggerRequestTargetReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerSingleStepReply;
import com.google.security.zynamics.binnavi.API.debug.DebuggerTargetInformationReply;
import com.google.security.zynamics.binnavi.API.debug.IDebuggerListener;
import com.google.security.zynamics.binnavi.API.debug.MemoryModule;
import com.google.security.zynamics.binnavi.API.debug.Register;
import com.google.security.zynamics.binnavi.API.debug.raw.RegisterValues;
import com.google.security.zynamics.binnavi.API.debug.raw.ThreadRegisterValues;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.IModuleListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.ModuleListenerAdapter;
import com.google.security.zynamics.binnavi.API.helpers.Logger;
import com.google.security.zynamics.binnavi.API.helpers.RemoteFileBrowserLoader;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTargetListener;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCallResolver;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ResolvedFunction;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class CallResolver {
    private static final Integer HIT_THRESHOLD = 20;
    private final ICallResolverTarget target;
    private final Debugger debugger;
    private final IDebuggerListener debuggerListener = new InternalDebuggerListener();
    private final Map<BigInteger, Set<ResolvedFunction>> resolvedAddresses = new HashMap<BigInteger, Set<ResolvedFunction>>();
    private final Map<BigInteger, Integer> hitCounter = new HashMap<BigInteger, Integer>();
    private final Map<Long, BigInteger> lastHits = new HashMap<Long, BigInteger>();
    private final ICallResolverTargetListener internalTargetListener = new InternalTargetListener();
    private final Map<Module, Map<Address, Function>> resolvedFunctions = new HashMap<Module, Map<Address, Function>>();
    private final Set<IndirectCall> removedBreakpoints = new HashSet<IndirectCall>();
    private int step = 0;
    private List<IndirectCall> indirectCallAddresses = null;
    private final IModuleListener moduleKeeperListener = new ModuleListenerAdapter(){

        @Override
        public boolean closingModule(Module module) {
            return false;
        }
    };
    private final Set<Module> modules = new HashSet<Module>();
    private final JFrame parent;

    public CallResolver(ICallResolverTarget target, JFrame parent) {
        assert (target != null);
        this.parent = parent;
        this.target = target;
        this.debugger = target.getDebugger();
        target.addListener(this.internalTargetListener);
    }

    private void countHit(long threadId, BigInteger breakpointAddress) {
        if (!this.hitCounter.containsKey(breakpointAddress)) {
            this.hitCounter.put(breakpointAddress, 0);
        }
        this.hitCounter.put(breakpointAddress, this.hitCounter.get(breakpointAddress) + 1);
        this.lastHits.put(threadId, breakpointAddress);
    }

    private void findIndirectCallAddresses() {
        this.indirectCallAddresses = this.target.getIndirectCalls();
        if (!this.indirectCallAddresses.isEmpty()) {
            ++this.step;
        }
        this.foundIndirectCallAddresses(this.indirectCallAddresses);
    }

    private BigInteger getProgramCounter(long threadId, RegisterValues registerValues) {
        for (ThreadRegisterValues registerValue : registerValues) {
            if (registerValue.getThreadId() != threadId) continue;
            for (Register register2 : registerValue) {
                if (!register2.isProgramCounter()) continue;
                return register2.getValue();
            }
        }
        assert (false) : "It is not possible to hit a breakpoint in a non-existing thread";
        return null;
    }

    private void loadTargetModules() {
        for (Module module : this.target.getModules()) {
            module.addListener(this.moduleKeeperListener);
            this.modules.add(module);
            if (module.isLoaded()) continue;
            try {
                module.load();
            }
            catch (CouldntLoadDataException e2) {
                this.errorLoadingModule(module, e2);
                return;
            }
        }
        ++this.step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompleteSingleStep(long threadId, BigInteger resolvedAddress) {
        BigInteger lastIndirectCallAddress = this.lastHits.get(threadId);
        if (lastIndirectCallAddress == null) {
            return;
        }
        Map<BigInteger, Set<ResolvedFunction>> map = this.resolvedAddresses;
        synchronized (map) {
            IndirectCall indirectCall;
            if (!this.resolvedAddresses.containsKey(lastIndirectCallAddress)) {
                this.resolvedAddresses.put(lastIndirectCallAddress, new HashSet());
            }
            ResolvedFunction resolvedFunction = this.resolveFunction(new Address(resolvedAddress));
            if (this.resolvedAddresses.get(lastIndirectCallAddress).add(resolvedFunction)) {
                this.hitCounter.put(lastIndirectCallAddress, 0);
            }
            if (this.hitCounter.get(lastIndirectCallAddress) >= HIT_THRESHOLD && (indirectCall = IndirectCallResolver.findIndirectCall(this.debugger, this.indirectCallAddresses, lastIndirectCallAddress)) != null) {
                this.removeBreakpoint(indirectCall);
                this.removedBreakpoints.add(indirectCall);
                this.resolvedCall(lastIndirectCallAddress, resolvedFunction);
            }
        }
    }

    private void removeBreakpoint(IndirectCall indirectCall) {
        Module module = indirectCall.getModule();
        Address address = indirectCall.getAddress();
        BreakpointManager breakpointManager = this.debugger.getBreakpointManager();
        if (breakpointManager.hasBreakpoint(module, address)) {
            this.debugger.getBreakpointManager().removeBreakpoint(indirectCall.getModule(), indirectCall.getAddress());
        }
    }

    private void removeBreakpoints() {
        for (IndirectCall indirectCall : this.indirectCallAddresses) {
            if (this.removedBreakpoints.contains(indirectCall)) continue;
            try {
                this.removeBreakpoint(indirectCall);
            }
            catch (Exception exception) {
                Logger.logException(exception);
            }
        }
    }

    private void resolveBreakpoints() {
        if (this.debugger.getProcess().getTargetInformation() == null) {
            this.errorNotAttached();
            this.step = 2;
            return;
        }
        try {
            this.debugger.resume();
        }
        catch (DebugException e2) {
            this.errorResuming(e2);
        }
        ++this.step;
    }

    private ResolvedFunction resolveFunction(Address address) {
        for (Module module : this.target.getModules()) {
            Map<Address, Function> functionMap;
            Function function;
            if (!this.resolvedFunctions.containsKey(module)) {
                this.resolveFunctions(module);
                if (!this.resolvedFunctions.containsKey(module)) continue;
            }
            if ((function = (functionMap = this.resolvedFunctions.get(module)).get(address)) == null) continue;
            return new ResolvedFunction(function);
        }
        for (MemoryModule memoryModule : this.target.getDebugger().getProcess().getModules()) {
            if (address.toLong() < memoryModule.getBaseAddress().toLong() || address.toLong() >= memoryModule.getBaseAddress().toLong() + memoryModule.getSize()) continue;
            return new ResolvedFunction(memoryModule, address);
        }
        return new ResolvedFunction(address);
    }

    private void resolveFunctions(Module module) {
        if (!module.isLoaded()) {
            return;
        }
        HashMap<Address, Function> functionMap = new HashMap<Address, Function>();
        for (Function function : module.getFunctions()) {
            Address rebasedAddress = this.target.getDebugger().toImagebase(module, function.getAddress());
            functionMap.put(rebasedAddress, function);
        }
        this.resolvedFunctions.put(module, functionMap);
    }

    private void setBreakpoints() {
        for (IndirectCall indirectCall : this.indirectCallAddresses) {
            this.debugger.getBreakpointManager().setBreakpoint(indirectCall.getModule(), indirectCall.getAddress());
        }
        ++this.step;
    }

    private void startDebugger() {
        if (this.debugger == null) {
            this.errorNoDebugger();
            return;
        }
        this.debugger.addListener(this.debuggerListener);
        try {
            if (!this.debugger.isConnected()) {
                this.debugger.connect();
            }
            ++this.step;
        }
        catch (DebugException e2) {
            this.debugger.removeListener(this.debuggerListener);
            this.errorConnectingDebugger(e2);
        }
    }

    private void stopResolving() {
        for (Module module : this.modules) {
            module.removeListener(this.moduleKeeperListener);
        }
        this.modules.clear();
        if (this.debugger != null && this.debugger.isConnected()) {
            try {
                this.debugger.terminate();
            }
            catch (DebugException e2) {
                e2.printStackTrace();
            }
        }
        if (this.step == 3 || this.step == 4 || this.step == 5) {
            this.debugger.removeListener(this.debuggerListener);
            this.removeBreakpoints();
        }
        ++this.step;
    }

    protected abstract void debuggerChanged();

    protected abstract void debuggerClosed();

    protected abstract void errorConnectingDebugger(DebugException var1);

    protected abstract void errorLoadingModule(Module var1, CouldntLoadDataException var2);

    protected abstract void errorNoDebugger();

    protected abstract void errorNotAttached();

    protected abstract void errorResuming(DebugException var1);

    protected abstract void foundIndirectCallAddresses(List<IndirectCall> var1);

    protected abstract void resolvedCall(BigInteger var1, ResolvedFunction var2);

    public void dispose() {
        this.target.removeListener(this.internalTargetListener);
        this.stopResolving();
    }

    public int getCurrentStep() {
        return this.step;
    }

    public List<IndirectCall> getIndirectAddresses() {
        return new ArrayList<IndirectCall>(this.indirectCallAddresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<BigInteger, Set<ResolvedFunction>> getResolvedAddresses() {
        Map<BigInteger, Set<ResolvedFunction>> map = this.resolvedAddresses;
        synchronized (map) {
            return new HashMap<BigInteger, Set<ResolvedFunction>>(this.resolvedAddresses);
        }
    }

    public ICallResolverTarget getTarget() {
        return this.target;
    }

    public void next() {
        switch (this.step) {
            case 0: {
                this.loadTargetModules();
                break;
            }
            case 1: {
                this.findIndirectCallAddresses();
                break;
            }
            case 2: {
                this.startDebugger();
                break;
            }
            case 3: {
                this.setBreakpoints();
                break;
            }
            case 4: {
                this.resolveBreakpoints();
                break;
            }
            case 5: {
                this.stopResolving();
                break;
            }
            case 6: {
                this.reset();
            }
        }
    }

    public void reset() {
        if (this.step != 6) {
            this.stopResolving();
        }
        this.resolvedAddresses.clear();
        this.resolvedFunctions.clear();
        this.hitCounter.clear();
        this.removedBreakpoints.clear();
        this.lastHits.clear();
        this.indirectCallAddresses = null;
        this.step = 0;
    }

    private class InternalTargetListener
    implements ICallResolverTargetListener {
        private InternalTargetListener() {
        }

        @Override
        public void changedDebugger(ICallResolverTarget target, Debugger debugger) {
            CallResolver.this.reset();
            CallResolver.this.debuggerChanged();
        }
    }

    private class InternalDebuggerListener
    extends DebuggerListenerAdapter {
        private InternalDebuggerListener() {
        }

        @Override
        public void debuggerClosed(int errorCode) {
            CallResolver.this.step = 5;
            CallResolver.this.stopResolving();
            CallResolver.this.debuggerClosed();
        }

        @Override
        public void breakpointHit(DebuggerBreakpointHitReply reply) {
            if (CallResolver.this.step != 5) {
                return;
            }
            BigInteger breakpointAddress = CallResolver.this.getProgramCounter(reply.getThreadId(), reply.getRegisterValues());
            CallResolver.this.countHit(reply.getThreadId(), breakpointAddress);
            try {
                CallResolver.this.target.getDebugger().singleStep();
            }
            catch (DebugException e2) {
                e2.printStackTrace();
            }
        }

        @Override
        public void requestTarget(DebuggerRequestTargetReply reply) {
            if (reply.getErrorCode() == 0) {
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        RemoteFileBrowserLoader loader = new RemoteFileBrowserLoader(CallResolver.this.parent, CallResolver.this.debugger);
                        if (!loader.load()) {
                            try {
                                CallResolver.this.debugger.cancelTargetSelection();
                            }
                            catch (DebugException e2) {
                                Logger.logException(e2);
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void singleStep(DebuggerSingleStepReply reply) {
            if (CallResolver.this.step != 5) {
                return;
            }
            BigInteger resolvedAddress = CallResolver.this.getProgramCounter(reply.getThreadId(), reply.getRegisterValues());
            CallResolver.this.processCompleteSingleStep(reply.getThreadId(), resolvedAddress);
            try {
                CallResolver.this.debugger.resume();
            }
            catch (DebugException e2) {
                e2.printStackTrace();
            }
        }

        @Override
        public void targetInformation(DebuggerTargetInformationReply reply) {
            try {
                CallResolver.this.debugger.setExceptionSettings(reply.getTargetInformation().getExceptionSettings());
            }
            catch (DebugException e2) {
                e2.printStackTrace();
            }
        }
    }
}

