/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.standardplugins.callresolver;

import com.google.security.zynamics.binnavi.API.debug.Debugger;
import com.google.security.zynamics.binnavi.API.disassembly.AddressSpace;
import com.google.security.zynamics.binnavi.API.disassembly.AddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTarget;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.ICallResolverTargetListener;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCall;
import com.google.security.zynamics.binnavi.standardplugins.callresolver.IndirectCallFinder;
import java.util.ArrayList;
import java.util.List;

public final class AddressSpaceCallResolverTarget
implements ICallResolverTarget {
    private final AddressSpace addressSpace;
    private final List<ICallResolverTargetListener> listeners = new ArrayList<ICallResolverTargetListener>();
    private final InternalAddressSpaceListener internalAddressSpaceListener = new InternalAddressSpaceListener();

    public AddressSpaceCallResolverTarget(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        addressSpace.addListener(this.internalAddressSpaceListener);
    }

    @Override
    public void addListener(ICallResolverTargetListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public View createView() {
        return this.addressSpace.getProject().createView("Dynamic Trace View", "");
    }

    @Override
    public Debugger getDebugger() {
        return this.addressSpace.getDebugger();
    }

    @Override
    public List<IndirectCall> getIndirectCalls() {
        ArrayList<IndirectCall> indirectCalls = new ArrayList<IndirectCall>();
        for (Module module : this.addressSpace.getModules()) {
            indirectCalls.addAll(IndirectCallFinder.find(module));
        }
        return indirectCalls;
    }

    @Override
    public List<Module> getModules() {
        return this.addressSpace.getModules();
    }

    @Override
    public void removeListener(ICallResolverTargetListener listener) {
        this.listeners.remove(listener);
    }

    private class InternalAddressSpaceListener
    extends AddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void changedDebugger(AddressSpace addressSpace, Debugger debugger) {
            for (ICallResolverTargetListener listener : AddressSpaceCallResolverTarget.this.listeners) {
                try {
                    listener.changedDebugger(AddressSpaceCallResolverTarget.this, debugger);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

