/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.models.Bookmarks.code;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.CCodeBookmark;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.ICodeBookmarkManagerListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CCodeBookmarkManager
implements Iterable<CCodeBookmark> {
    private final List<CCodeBookmark> m_bookmarks = new ArrayList<CCodeBookmark>();
    private final ListenerProvider<ICodeBookmarkManagerListener> m_listeners = new ListenerProvider();

    public void addBookmark(CCodeBookmark bookmark) {
        Preconditions.checkNotNull(bookmark, "IE00328: Bookmark argument can not be null");
        Preconditions.checkArgument(!this.m_bookmarks.contains(bookmark), "IE00329: Bookmark can not be added more than once");
        this.m_bookmarks.add(bookmark);
        for (ICodeBookmarkManagerListener listener : this.m_listeners) {
            try {
                listener.addedBookmark(this, bookmark);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addListener(ICodeBookmarkManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public CCodeBookmark get(int index) {
        return this.m_bookmarks.get(index);
    }

    public boolean hasBookmark(INaviModule module, IAddress address) {
        Preconditions.checkNotNull(address, "IE00330: Address argument can not be null");
        for (CCodeBookmark bookmark : this.m_bookmarks) {
            if (bookmark.getModule() != module || !bookmark.getAddress().equals(address)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<CCodeBookmark> iterator() {
        return this.m_bookmarks.iterator();
    }

    public void removeBookmark(CCodeBookmark bookmark) {
        Preconditions.checkNotNull(bookmark, "IE00331: Bookmark argument can not be null");
        Preconditions.checkArgument(this.m_bookmarks.remove(bookmark), "IE00332: Bookmark is not managed by this manager");
        for (ICodeBookmarkManagerListener listener : this.m_listeners) {
            try {
                listener.removedBookmark(this, bookmark);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeListener(ICodeBookmarkManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public int size() {
        return this.m_bookmarks.size();
    }
}

