/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.views;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;

public final class CViewFilter {
    private CViewFilter() {
    }

    private static Iterable<INaviView> getViewsByType(List<INaviView> views, final GraphType type) {
        return Collections2.filter(views, new Predicate<INaviView>(){

            @Override
            public boolean apply(INaviView view) {
                return view.getGraphType() == type;
            }
        });
    }

    public static int getCallgraphViewCount(List<INaviView> views) {
        return Iterables.size(CViewFilter.getViewsByType(views, GraphType.CALLGRAPH));
    }

    public static Iterable<INaviView> getCallgraphViews(List<INaviView> views) {
        return CViewFilter.getViewsByType(views, GraphType.CALLGRAPH);
    }

    public static int getFlowgraphViewCount(List<INaviView> views) {
        return Iterables.size(CViewFilter.getViewsByType(views, GraphType.FLOWGRAPH));
    }

    public static Iterable<INaviView> getFlowgraphViews(List<INaviView> views) {
        return CViewFilter.getViewsByType(views, GraphType.FLOWGRAPH);
    }

    public static int getMixedgraphViewCount(List<INaviView> views) {
        return Iterables.size(CViewFilter.getViewsByType(views, GraphType.MIXED_GRAPH));
    }

    public static List<Pair<INaviView, CTag>> getTaggedViews(List<INaviView> views) {
        ArrayList<Pair<INaviView, CTag>> taggedViews = new ArrayList<Pair<INaviView, CTag>>();
        for (INaviView view : views) {
            for (CTag tag : view.getConfiguration().getViewTags()) {
                taggedViews.add(new Pair<INaviView, CTag>(view, tag));
            }
        }
        return taggedViews;
    }

    public static List<INaviView> getTaggedViews(List<INaviView> views, CTag tag) {
        ArrayList<INaviView> taggedViews = new ArrayList<INaviView>();
        for (INaviView view : views) {
            if (!view.getConfiguration().isTagged(tag)) continue;
            taggedViews.add(view);
        }
        return taggedViews;
    }
}

