/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.views;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.disassembly.CNaviEdgeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewEdge;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNodeListener;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CFunctionNodeColorizer;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviViewListener;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContent;
import com.google.security.zynamics.reil.ReilFunction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ICodeContainer;
import com.google.security.zynamics.zylib.disassembly.ICodeEdge;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CViewContent
implements IViewContent {
    private static final Color TEXTNODE_COLOR = new Color(255, 255, 210);
    private final INaviView view;
    private final ListenerProvider<INaviViewListener> listeners;
    private final SQLProvider provider;
    private final MutableDirectedGraph<INaviViewNode, INaviEdge> graph;
    private GraphType m_graphType = GraphType.MIXED_GRAPH;
    private ReilFunction m_reilFunction = null;
    private final ReilTranslator<INaviInstruction> m_translator = new ReilTranslator();
    private final InternalNodeListener m_internalNodeListener = new InternalNodeListener();
    private final InternalEdgeListener m_internalEdgeListener = new InternalEdgeListener();
    private boolean m_wasModified = false;

    public CViewContent(INaviView view, ListenerProvider<INaviViewListener> listeners, SQLProvider provider, MutableDirectedGraph<INaviViewNode, INaviEdge> graph) {
        this.view = Preconditions.checkNotNull(view, "IE02613: view argument can not be null");
        this.listeners = Preconditions.checkNotNull(listeners, "IE02614: listeners argument can not be null");
        this.provider = Preconditions.checkNotNull(provider, "IE02615: provider argument can not be null");
        this.graph = Preconditions.checkNotNull(graph, "IE02616: graph argument can not be null");
        for (INaviViewNode node : this.graph.getNodes()) {
            node.addListener(this.m_internalNodeListener);
        }
        for (INaviEdge edge : this.graph.getEdges()) {
            edge.addListener(this.m_internalEdgeListener);
        }
        this.updateGraphType();
    }

    private static void deleteGroupNode(INaviGroupNode groupNode) {
        List<INaviViewNode> elements = groupNode.getElements();
        groupNode.setCollapsed(false);
        for (INaviViewNode node : elements) {
            groupNode.removeElement(node);
            if (groupNode.getParentGroup() == null) continue;
            groupNode.getParentGroup().addElement(node);
        }
    }

    private static Collection<INaviViewNode> filterGroupNodes(Collection<INaviViewNode> nodes) {
        return Collections2.filter(nodes, new Predicate<INaviViewNode>(){

            @Override
            public boolean apply(INaviViewNode node) {
                return !(node instanceof INaviGroupNode);
            }
        });
    }

    private void addNode(INaviViewNode node) {
        this.graph.addNode(node);
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.addedNode(this.view, node);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private void removeEdges(INaviViewNode node) {
        if (node instanceof INaviGroupNode) {
            return;
        }
        HashSet<INaviEdge> toDelete = new HashSet<INaviEdge>();
        for (INaviEdge incomingEdge : node.getIncomingEdges()) {
            ((INaviViewNode)incomingEdge.getSource()).removeChild(node);
            ((INaviViewNode)incomingEdge.getSource()).removeOutgoingEdge(incomingEdge);
            toDelete.add(incomingEdge);
        }
        for (INaviEdge outgoingEdge : node.getOutgoingEdges()) {
            ((INaviViewNode)outgoingEdge.getTarget()).removeParent(node);
            ((INaviViewNode)outgoingEdge.getTarget()).removeIncomingEdge(outgoingEdge);
            toDelete.add(outgoingEdge);
        }
        for (INaviEdge edge : toDelete) {
            this.deleteEdge(edge);
        }
    }

    private void setGraphType(GraphType graphType) {
        if (this.m_graphType.equals((Object)graphType)) {
            return;
        }
        GraphType oldType = this.m_graphType;
        this.m_graphType = graphType;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedGraphType(this.view, this.m_graphType, oldType);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setModified(boolean value) {
        if (this.m_wasModified == value) {
            return;
        }
        this.m_wasModified = value;
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.changedModificationState(this.view, value);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private void updateGraphType() {
        boolean hasCodeNode = false;
        boolean hasFunctionNode = false;
        for (INaviViewNode node : this.graph.getNodes()) {
            if (node instanceof INaviFunctionNode) {
                hasFunctionNode = true;
                if (!hasCodeNode) continue;
                this.setGraphType(GraphType.MIXED_GRAPH);
                return;
            }
            if (!(node instanceof INaviCodeNode)) continue;
            hasCodeNode = true;
            if (!hasFunctionNode) continue;
            this.setGraphType(GraphType.MIXED_GRAPH);
            return;
        }
        if (hasCodeNode) {
            this.setGraphType(GraphType.FLOWGRAPH);
        } else if (hasFunctionNode) {
            this.setGraphType(GraphType.CALLGRAPH);
        } else {
            this.setGraphType(GraphType.MIXED_GRAPH);
        }
    }

    private void updateGraphType(IViewNode<?> node) {
        if (this.m_graphType == GraphType.MIXED_GRAPH) {
            if (this.getNodeCount() == 1) {
                if (node instanceof INaviCodeNode) {
                    this.setGraphType(GraphType.FLOWGRAPH);
                } else if (node instanceof INaviFunctionNode) {
                    this.setGraphType(GraphType.CALLGRAPH);
                }
            }
        } else if (this.m_graphType == GraphType.CALLGRAPH) {
            if (node instanceof INaviCodeNode) {
                this.setGraphType(GraphType.MIXED_GRAPH);
            }
        } else if (node instanceof INaviFunctionNode) {
            this.setGraphType(GraphType.MIXED_GRAPH);
        }
    }

    @Override
    public CCodeNode createCodeNode(INaviFunction parentFunction, List<? extends INaviInstruction> instructions) {
        Preconditions.checkNotNull(instructions, "IE00286: Instructions argument can not be null");
        if (parentFunction != null && !parentFunction.inSameDatabase(this.provider)) {
            throw new IllegalArgumentException("IE00287: Parent function and view are not in the same database");
        }
        for (INaviInstruction iNaviInstruction : instructions) {
            Preconditions.checkNotNull(iNaviInstruction, "IE00288: Instruction list contains a null-instruction");
            Preconditions.checkArgument(iNaviInstruction.inSameDatabase(this.provider), "IE00289: Instruction and view are not in the same database");
        }
        CCodeNode codeNode = new CCodeNode(-1, 0.0, 0.0, 0.0, 0.0, Color.WHITE, Color.BLACK, false, true, null, parentFunction, new HashSet<CTag>(), this.provider);
        for (INaviInstruction iNaviInstruction : instructions) {
            codeNode.addInstruction(iNaviInstruction, null);
        }
        this.addNode(codeNode);
        this.updateGraphType(codeNode);
        codeNode.addListener(this.m_internalNodeListener);
        this.m_reilFunction = null;
        return codeNode;
    }

    @Override
    public CNaviViewEdge createEdge(INaviViewNode source, INaviViewNode target, EdgeType edgeType) {
        Preconditions.checkNotNull(source, "IE00290: Source argument can not be null");
        Preconditions.checkNotNull(target, "IE00291: Target argument can not be null");
        Preconditions.checkNotNull(edgeType, "IE00292: Edge type argument can not be null");
        Preconditions.checkArgument(source.inSameDatabase(this.provider), "IE00187: Source node is not in the same database");
        Preconditions.checkArgument(target.inSameDatabase(this.provider), "IE00189: Target node is not in the same database");
        CNaviViewEdge edge = new CNaviViewEdge(-1, source, target, edgeType, 0.0, 0.0, 0.0, 0.0, Color.BLACK, false, true, null, new ArrayList<CBend>(), this.provider);
        source.addOutgoingEdge(edge);
        target.addIncomingEdge(edge);
        edge.addListener(this.m_internalEdgeListener);
        this.graph.addEdge(edge);
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.addedEdge(this.view, edge);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return edge;
    }

    @Override
    public CFunctionNode createFunctionNode(INaviFunction function) {
        Preconditions.checkNotNull(function, "IE00294: Function argument can not be null");
        Preconditions.checkArgument(function.inSameDatabase(this.provider), "IE00295: Function and view are not in the same database");
        CFunctionNode functionNode = new CFunctionNode(-1, function, 0.0, 0.0, 0.0, 0.0, CFunctionNodeColorizer.getFunctionColor(function.getType()), false, true, null, new HashSet<CTag>(), this.provider);
        this.addNode(functionNode);
        this.updateGraphType(functionNode);
        functionNode.addListener(this.m_internalNodeListener);
        return functionNode;
    }

    @Override
    public CGroupNode createGroupNode(Collection<INaviViewNode> nodes) {
        Preconditions.checkNotNull(nodes, "IE00297: Nodes argument can not be null");
        Preconditions.checkArgument(!nodes.isEmpty(), "IE00298: Nodes list can not be empty");
        CGroupNode groupNode = new CGroupNode(-1, 0.0, 0.0, 0.0, 0.0, TEXTNODE_COLOR, false, true, new HashSet<CTag>(), null, false, this.provider);
        for (INaviViewNode node : nodes) {
            Preconditions.checkNotNull(node, "IE00299: Nodes list contains a null-argument");
            groupNode.addElement(node);
        }
        this.addNode(groupNode);
        groupNode.addListener(this.m_internalNodeListener);
        groupNode.addGroupListener(this.m_internalNodeListener);
        return groupNode;
    }

    @Override
    public CTextNode createTextNode(List<IComment> comments) {
        CTextNode textNode = new CTextNode(-1, 0.0, 0.0, 0.0, 0.0, TEXTNODE_COLOR, false, true, new HashSet<CTag>(), comments, this.provider);
        this.addNode(textNode);
        textNode.addListener(this.m_internalNodeListener);
        return textNode;
    }

    @Override
    public void deleteEdge(INaviEdge edge) {
        Preconditions.checkNotNull(edge, "IE00300: Edge argument can not be null");
        this.graph.removeEdge(edge);
        edge.removeListener(this.m_internalEdgeListener);
        ((INaviViewNode)edge.getSource()).removeChild((INaviViewNode)edge.getTarget());
        ((INaviViewNode)edge.getTarget()).removeParent((INaviViewNode)edge.getSource());
        ((INaviViewNode)edge.getSource()).removeOutgoingEdge(edge);
        ((INaviViewNode)edge.getTarget()).removeIncomingEdge(edge);
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.deletedEdge(this.view, edge);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void deleteNode(INaviViewNode node) {
        Preconditions.checkNotNull(node, "IE00302: Node argument can not be null");
        if (!this.graph.getNodes().contains(node)) {
            throw new IllegalArgumentException(String.format("IE00304: Node '%s' is not part of this view", node.toString()));
        }
        if (node instanceof INaviGroupNode && ((INaviGroupNode)node).getNumberOfElements() != 0) {
            CViewContent.deleteGroupNode((INaviGroupNode)node);
            return;
        }
        this.removeEdges(node);
        this.graph.removeNode(node);
        node.removeListener(this.m_internalNodeListener);
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.deletedNode(this.view, node);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateGraphType();
    }

    @Override
    public void deleteNodes(Collection<INaviViewNode> nodes) {
        Preconditions.checkNotNull(nodes, "IE00305: Nodes argument can not be null");
        ArrayList<INaviViewNode> nodesCopy = new ArrayList<INaviViewNode>(nodes);
        List<INaviViewNode> gnodes = this.graph.getNodes();
        for (INaviViewNode iNaviViewNode : nodesCopy) {
            Preconditions.checkNotNull(iNaviViewNode, "IE00307: Node list contains a null-node");
            Preconditions.checkArgument(gnodes.contains(iNaviViewNode), "IE00308: Node list contains at least one node that is not part of this view");
        }
        ArrayList<INaviGroupNode> parentsToDelete = new ArrayList<INaviGroupNode>();
        for (INaviViewNode node : nodesCopy) {
            if (node instanceof INaviGroupNode) {
                if (((INaviGroupNode)node).getNumberOfElements() == 0) continue;
                CViewContent.deleteGroupNode((INaviGroupNode)node);
                continue;
            }
            this.removeEdges(node);
            this.graph.removeNode(node);
            node.removeListener(this.m_internalNodeListener);
            INaviGroupNode parent = node.getParentGroup();
            if (parent == null) continue;
            parent.removeElement(node);
            if (parent.getParentGroup() != null) {
                parent.getParentGroup().addElement(node);
            }
            if (parent.getNumberOfElements() != 0) continue;
            parentsToDelete.add(parent);
        }
        Collection<INaviViewNode> collection = CViewContent.filterGroupNodes(nodesCopy);
        for (INaviViewListener listener : this.listeners) {
            try {
                listener.deletedNodes(this.view, collection);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateGraphType();
    }

    @Override
    public List<? extends ICodeEdge<?>> getBasicBlockEdges() {
        ArrayList<INaviEdge> nodes = new ArrayList<INaviEdge>();
        for (INaviEdge node : this.graph.getEdges()) {
            if (!(node.getSource() instanceof ICodeContainer) || !(node.getTarget() instanceof ICodeContainer)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public List<CCodeNode> getBasicBlocks() {
        ArrayList<CCodeNode> nodes = new ArrayList<CCodeNode>();
        for (INaviViewNode node : this.graph.getNodes()) {
            if (!(node instanceof CCodeNode)) continue;
            nodes.add((CCodeNode)node);
        }
        return nodes;
    }

    @Override
    public int getEdgeCount() {
        return this.graph.getEdges().size();
    }

    public MutableDirectedGraph<INaviViewNode, INaviEdge> getGraph() {
        return this.graph;
    }

    @Override
    public GraphType getGraphType() {
        return this.m_graphType;
    }

    @Override
    public int getNodeCount() {
        return this.graph.getNodes().size();
    }

    public Set<CTag> getNodeTags() {
        HashSet<CTag> tags = new HashSet<CTag>();
        for (INaviViewNode node : this.graph) {
            tags.addAll(node.getTags());
        }
        return tags;
    }

    @Override
    public ReilFunction getReilCode() throws InternalTranslationException {
        if (this.m_reilFunction == null) {
            StandardEnvironment env = new StandardEnvironment();
            this.m_reilFunction = this.m_translator.translate((ITranslationEnvironment)env, this.view);
        }
        return this.m_reilFunction;
    }

    public void save() {
        this.setModified(false);
    }

    public boolean wasModified() {
        return this.m_wasModified;
    }

    private class InternalNodeListener
    implements INaviViewNodeListener,
    INaviCodeNodeListener,
    INaviGroupNodeListener,
    INaviFunctionNodeListener {
        private InternalNodeListener() {
        }

        @Override
        public void addedElement(INaviGroupNode groupNode, INaviViewNode node) {
            CViewContent.this.setModified(true);
        }

        @Override
        public void addedInstruction(INaviCodeNode codeNode, INaviInstruction instruction) {
            CViewContent.this.setModified(true);
        }

        @Override
        public void appendedFunctionNodeComment(INaviFunctionNode node, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.appendedLocalFunctionNodeComment(CViewContent.this.view, node, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void appendedGlobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
        }

        @Override
        public void appendedGroupNodeComment(INaviGroupNode node, IComment comment) {
        }

        @Override
        public void appendedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
        }

        @Override
        public void appendedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
        }

        @Override
        public void changedBorderColor(IViewNode<?> node, Color color) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.changedBorderColor(CViewContent.this.view, node, color);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedColor(IViewNode<?> node, Color color) {
            CViewContent.this.setModified(true);
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.changedColor(CViewContent.this.view, node, color);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedInstructionColor(CCodeNode codeNode, INaviInstruction instruction, int level, Color color) {
        }

        @Override
        public void changedParentGroup(INaviViewNode node, INaviGroupNode groupNode) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.changedParentGroup(CViewContent.this.view, node, groupNode);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedSelection(IViewNode<?> node, boolean selected) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.changedSelection(CViewContent.this.view, node, selected);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedState(INaviGroupNode node) {
        }

        @Override
        public void changedVisibility(IViewNode<?> node, boolean visible) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.changedVisibility(CViewContent.this.view, node, visible);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedFunctionNodeComment(INaviFunctionNode node, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.deletedLocalFunctionNodeComment(CViewContent.this.view, node, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedGlobalCodeNodeComment(INaviCodeNode codenode, IComment comment) {
        }

        @Override
        public void deletedGroupNodeComment(INaviGroupNode node, IComment comment) {
        }

        @Override
        public void deletedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
        }

        @Override
        public void deletedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
        }

        @Override
        public void editedFunctionNodeComment(INaviFunctionNode node, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.editedLocalFunctionNodeComment(CViewContent.this.view, node, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void editedGlobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
        }

        @Override
        public void editedGroupNodeComment(INaviGroupNode node, IComment comment) {
        }

        @Override
        public void editedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
        }

        @Override
        public void editedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
        }

        @Override
        public void heightChanged(IViewNode<?> node, double height) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.heightChanged(CViewContent.this.view, node, height);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void initializedFunctionNodeComment(INaviFunctionNode node, List<IComment> comment) {
        }

        @Override
        public void initializedGlobalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comments) {
        }

        @Override
        public void initializedGroupNodeComment(INaviGroupNode node, List<IComment> comment) {
        }

        @Override
        public void initializedLocalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comments) {
        }

        @Override
        public void initializedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, List<IComment> comments) {
        }

        @Override
        public void removedElement(INaviGroupNode groupNode, INaviViewNode node) {
            CViewContent.this.setModified(true);
            if (groupNode.getNumberOfElements() == 0) {
                CViewContent.this.deleteNode(groupNode);
            }
        }

        @Override
        public void removedInstruction(INaviCodeNode codeNode, INaviInstruction instruction) {
            CViewContent.this.m_reilFunction = null;
            CViewContent.this.setModified(true);
        }

        @Override
        public void taggedNode(INaviViewNode node, CTag tag) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.taggedNode(CViewContent.this.view, node, tag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void untaggedNodes(INaviViewNode node, List<CTag> tags) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.untaggedNodes(CViewContent.this.view, node, tags);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void widthChanged(IViewNode<?> node, double width) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.widthChanged(CViewContent.this.view, node, width);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void xposChanged(IViewNode<?> node, double xpos) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.xposChanged(CViewContent.this.view, node, xpos);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void yposChanged(IViewNode<?> node, double ypos) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.yposChanged(CViewContent.this.view, node, ypos);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    private class InternalEdgeListener
    extends CNaviEdgeListenerAdapter {
        private InternalEdgeListener() {
        }

        @Override
        public void appendedGlobalEdgeComment(INaviEdge naviEdge, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.appendedGlobalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void appendedLocalEdgeComment(INaviEdge naviEdge, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.appendedLocalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedColor(CViewEdge<?> edge, Color color) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.changedColor(CViewContent.this.view, (CNaviViewEdge)edge, color);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedVisibility(IViewEdge<?> edge, boolean visibility) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.changedVisibility(CViewContent.this.view, edge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedGlobalEdgeComment(INaviEdge naviEdge, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.deletedGlobalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedLocalEdgeComment(INaviEdge naviEdge, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.deletedLocalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void editedGlobalEdgeComment(INaviEdge naviEdge, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.editedGlobalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void editedLocalEdgeComment(INaviEdge naviEdge, IComment comment) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.editedLocalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void initializedGlobalEdgeComment(INaviEdge naviEdge, List<IComment> comments) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.initializedGlobalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void initializedLocalEdgeComment(INaviEdge naviEdge, List<IComment> comments) {
            for (INaviViewListener listener : CViewContent.this.listeners) {
                try {
                    listener.initializedLocalEdgeComment(CViewContent.this.view, naviEdge);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

