/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.views;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.cache.EdgeCache;
import com.google.security.zynamics.binnavi.Database.cache.NodeCache;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CLoopHighlighter;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CFunctionNodeColorizer;
import com.google.security.zynamics.binnavi.disassembly.views.CViewConfiguration;
import com.google.security.zynamics.binnavi.disassembly.views.CViewContent;
import com.google.security.zynamics.binnavi.disassembly.views.CViewLoaderReporter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviViewListener;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContent;
import com.google.security.zynamics.binnavi.disassembly.views.ViewLoadEvents;
import com.google.security.zynamics.binnavi.disassembly.views.ViewManager;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.EdgeInitializer;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ICodeEdge;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CView
implements INaviView,
ICallgraphView,
IFlowgraphView {
    private final SQLProvider m_provider;
    private final ListenerProvider<INaviViewListener> m_listeners = new ListenerProvider();
    private int m_bbcount;
    private int m_edgecount;
    private final CViewLoaderReporter m_loadReporter = new CViewLoaderReporter(this.m_listeners);
    private final CViewConfiguration m_configuration;
    private CViewContent m_content = null;
    private GraphType m_lastGraphType;
    private final Set<CTag> m_nodeTags;

    private CView(int viewId, String name, String description, ViewType type, Date creationDate, Date modificationDate, IDirectedGraph<INaviViewNode, INaviEdge> iDirectedGraph, Set<CTag> tags, boolean isStared, SQLProvider provider) {
        Preconditions.checkArgument(viewId > 0 || viewId == -1, "IE01099: View IDs must be positive");
        Preconditions.checkNotNull(name, "IE00271: Name can not be null");
        Preconditions.checkNotNull(description, "IE01100: Description can not be null");
        Preconditions.checkNotNull(type, "IE01101: View type can not be null");
        Preconditions.checkNotNull(creationDate, "IE00471: Creation date can not be null");
        Preconditions.checkNotNull(modificationDate, "IE00472: Modification date can not be null");
        Preconditions.checkNotNull(iDirectedGraph, "IE02234: Graph argument can not be null");
        Preconditions.checkNotNull(tags, "IE00279: Tags argument can not be null");
        for (CTag tag : tags) {
            Preconditions.checkNotNull(tag, "IE00280: Tag list contains a null-tag");
            Preconditions.checkArgument(tag.getType() == TagType.VIEW_TAG, "IE00767: Tag list contains a tag with an invalid type");
            Preconditions.checkArgument(tag.inSameDatabase(provider), "IE00282: Tag list contains a tag that is stored in a different database than the view");
        }
        this.m_provider = Preconditions.checkNotNull(provider, "IE00283: SQL provider date can not be null");
        this.m_configuration = new CViewConfiguration(this, this.m_listeners, provider, viewId, description, name, type, creationDate, modificationDate, tags, isStared);
        this.m_bbcount = iDirectedGraph.nodeCount();
        this.m_edgecount = iDirectedGraph.edgeCount();
        this.m_content = new CViewContent(this, this.m_listeners, this.m_provider, (MutableDirectedGraph)iDirectedGraph);
        this.m_nodeTags = new HashSet<CTag>();
        this.m_lastGraphType = this.m_content.getGraphType();
        ViewManager.get(this.m_provider).putView(this);
    }

    private CView(int viewId, String name, String description, ViewType type, GraphType graphType, Date creationDate, Date modificationDate, int bbcount, int edgecount, Set<CTag> tags, Set<CTag> nodeTags, boolean isStared, SQLProvider provider) {
        Preconditions.checkArgument(viewId > 0 || viewId == -1, "IE00270: View IDs must be positive");
        Preconditions.checkNotNull(name, "IE00138: Name can not be null");
        Preconditions.checkNotNull(type, "IE00273: View type can not be null");
        Preconditions.checkNotNull(graphType, "IE00274: Graph type can not be null");
        Preconditions.checkNotNull(creationDate, "IE00275: Creation date can not be null");
        Preconditions.checkNotNull(modificationDate, "IE00276: Modification date can not be null");
        Preconditions.checkArgument(bbcount >= 0, "IE00277: Basic block count argument can not be null");
        Preconditions.checkArgument(edgecount >= 0, "IE00278: Edge count argument can not be null");
        Preconditions.checkNotNull(tags, "IE01098: Tags argument can not be null");
        for (CTag tag : tags) {
            Preconditions.checkNotNull(tag, "IE01097: Tag list contains a null-tag");
            Preconditions.checkArgument(tag.getType() == TagType.VIEW_TAG, "IE00281: Tag list contains a tag with an invalid type");
            Preconditions.checkArgument(tag.inSameDatabase(provider), "IE00285: Tag list contains a tag that is stored in a different database than the view");
        }
        this.m_provider = Preconditions.checkNotNull(provider, "IE00470: SQL provider date can not be null");
        this.m_configuration = new CViewConfiguration(this, this.m_listeners, provider, viewId, description, name, type, creationDate, modificationDate, tags, isStared);
        this.m_bbcount = bbcount;
        this.m_edgecount = edgecount;
        this.m_nodeTags = new HashSet<CTag>(nodeTags);
        this.m_lastGraphType = graphType;
        ViewManager.get(this.m_provider).putView(this);
    }

    public static CView createUnsavedProjectView(INaviProject project, INaviView view, String name, String description, SQLProvider provider) {
        CView newView = new CView(-1, name, description, ViewType.NonNative, Calendar.getInstance().getTime(), Calendar.getInstance().getTime(), view.getGraph(), new HashSet<CTag>(), false, provider);
        newView.getConfiguration().setProject(project);
        return newView;
    }

    public CView(int viewId, INaviModule module, String name, String description, ViewType type, Date creationDate, Date modificationDate, MutableDirectedGraph<INaviViewNode, INaviEdge> graph, Set<CTag> tags, boolean isStared, SQLProvider provider) {
        this(viewId, name, description, type, creationDate, modificationDate, graph, tags, isStared, provider);
        Preconditions.checkNotNull(module, "IE01271: Module argument can not be null");
        this.m_configuration.setModule(module);
    }

    public CView(int viewId, INaviModule module, String name, String description, ViewType type, GraphType graphType, Date creationDate, Date modificationDate, int bbcount, int edgecount, Set<CTag> tags, Set<CTag> nodeTags, boolean isStared, SQLProvider provider) {
        this(viewId, name, description, type, graphType, creationDate, modificationDate, bbcount, edgecount, tags, nodeTags, isStared, provider);
        Preconditions.checkNotNull(module, "IE01279: Module argument can not be null");
        this.m_configuration.setModule(module);
    }

    public CView(int viewId, INaviProject project, String name, String description, ViewType type, Date creationDate, Date modificationDate, MutableDirectedGraph<INaviViewNode, INaviEdge> graph, Set<CTag> tags, boolean isStared, SQLProvider provider) {
        this(viewId, name, description, type, creationDate, modificationDate, graph, tags, isStared, provider);
        Preconditions.checkNotNull(project, "IE01280: Project argument can not be null");
        this.m_configuration.setProject(project);
    }

    public CView(int viewId, INaviProject project, String name, String description, ViewType type, GraphType graphType, Date creationDate, Date modificationDate, int bbcount, int edgecount, Set<CTag> tags, Set<CTag> nodeTags, boolean isStared, SQLProvider provider) {
        this(viewId, name, description, type, graphType, creationDate, modificationDate, bbcount, edgecount, tags, nodeTags, isStared, provider);
        Preconditions.checkNotNull(project, "IE01281: Project argument can not be null");
        this.m_configuration.setProject(project);
    }

    @Override
    public void addListener(INaviViewListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public boolean close() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE00284: View is not loaded");
        }
        for (INaviViewListener listener : this.m_listeners) {
            try {
                if (listener.closingView(this)) continue;
                return false;
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        IDirectedGraph oldGraph = this.m_content.getGraph();
        for (INaviViewNode node : oldGraph) {
            node.close();
        }
        for (INaviEdge edge : oldGraph.getEdges()) {
            edge.dispose();
        }
        this.m_nodeTags.clear();
        this.m_nodeTags.addAll(this.m_content.getNodeTags());
        this.m_content = null;
        for (INaviViewListener listener : this.m_listeners) {
            try {
                listener.closedView(this, oldGraph);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return true;
    }

    @Override
    public List<? extends ICodeEdge<?>> getBasicBlockEdges() {
        return this.m_content.getBasicBlockEdges();
    }

    @Override
    public List<CCodeNode> getBasicBlocks() {
        return this.m_content.getBasicBlocks();
    }

    @Override
    public CViewConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public IViewContent getContent() {
        Preconditions.checkNotNull(this.m_content, "IE00465: View is not loaded");
        return this.m_content;
    }

    @Override
    public List<INaviView> getDerivedViews() throws CouldntLoadDataException {
        return this.m_provider.getDerivedViews(this);
    }

    @Override
    public int getEdgeCount() {
        return this.isLoaded() ? this.m_content.getEdgeCount() : this.m_edgecount;
    }

    @Override
    public MutableDirectedGraph<INaviViewNode, INaviEdge> getGraph() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE02199: View is not loaded");
        }
        return this.m_content.getGraph();
    }

    @Override
    public GraphType getGraphType() {
        return this.isLoaded() ? this.m_content.getGraphType() : this.m_lastGraphType;
    }

    @Override
    public int getLoadState() {
        return this.m_loadReporter.getStep();
    }

    @Override
    public String getName() {
        return this.m_configuration.getName();
    }

    @Override
    public int getNodeCount() {
        return this.isLoaded() ? this.m_content.getNodeCount() : this.m_bbcount;
    }

    @Override
    public Set<CTag> getNodeTags() {
        return this.isLoaded() ? this.m_content.getNodeTags() : new HashSet<CTag>(this.m_nodeTags);
    }

    @Override
    public ViewType getType() {
        return this.m_configuration.getType();
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject object) {
        Preconditions.checkNotNull(object, "IE00313: Object argument can not be null");
        return object.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return this.m_provider.equals(provider);
    }

    @Override
    public boolean isLoaded() {
        return this.m_content != null;
    }

    @Override
    public boolean isStared() {
        return this.m_configuration.isStared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws CouldntLoadDataException, CPartialLoadException, LoadCancelledException {
        CViewLoaderReporter cViewLoaderReporter = this.m_loadReporter;
        synchronized (cViewLoaderReporter) {
            if (this.isLoaded()) {
                throw new IllegalStateException("IE01110: View is already loaded");
            }
            this.m_loadReporter.start();
            if (!this.m_loadReporter.report(ViewLoadEvents.Started)) {
                throw new LoadCancelledException();
            }
            try {
                MutableDirectedGraph<INaviViewNode, INaviEdge> graph = this.m_configuration.isStored() ? this.m_provider.loadView(this) : new MutableDirectedGraph<INaviViewNode, INaviEdge>(new ArrayList(), new ArrayList());
                this.m_content = new CViewContent(this, this.m_listeners, this.m_provider, graph);
                if (!this.m_loadReporter.report(ViewLoadEvents.Finished)) {
                    throw new LoadCancelledException();
                }
                if (this.getType().equals((Object)ViewType.Native)) {
                    this.colorNodes();
                }
                if (this.getContent().getGraphType().equals((Object)GraphType.FLOWGRAPH)) {
                    this.colorLoops();
                }
                this.colorEdges();
                ((CViewContent)this.getContent()).setModified(false);
                for (INaviViewListener listener : this.m_listeners) {
                    try {
                        listener.loadedView(this);
                    }
                    catch (IllegalArgumentException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
            finally {
                this.m_loadReporter.stop();
            }
        }
    }

    private void colorLoops() {
        try {
            for (INaviViewNode currentNode : ((MutableDirectedGraph)this.getGraph()).getNodes()) {
                if (!currentNode.getParents().isEmpty()) continue;
                CLoopHighlighter.colorLoops(this.getGraph(), currentNode);
                break;
            }
        }
        catch (MalformedGraphException exception) {
            NaviLogger.warning("Error: Graph is malformed, can not color loops", new Object[0]);
        }
    }

    private void colorEdges() {
        for (INaviEdge edge : ((MutableDirectedGraph)this.getGraph()).getEdges()) {
            EdgeInitializer.adjustColor(edge);
        }
    }

    private void colorNodes() {
        Color blockColor = ConfigManager.instance().getColorSettings().getBasicBlocksColor();
        for (INaviViewNode node : ((MutableDirectedGraph)this.getGraph()).getNodes()) {
            if (node instanceof INaviCodeNode) {
                node.setColor(blockColor);
                continue;
            }
            if (!(node instanceof INaviFunctionNode)) continue;
            node.setColor(CFunctionNodeColorizer.getFunctionColor(((INaviFunctionNode)node).getFunction().getType()));
        }
    }

    @Override
    public Map<String, String> loadSettings() throws CouldntLoadDataException {
        return this.m_configuration.isStored() ? this.m_provider.loadSettings(this) : new HashMap();
    }

    @Override
    public void removeListener(INaviViewListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void save() throws CouldntSaveDataException {
        Preconditions.checkArgument(this.getType() == ViewType.NonNative, "IE00314: Native views can not be saved");
        Preconditions.checkState(this.isLoaded(), "IE00315: View must be loaded before it can be saved");
        if (this.m_configuration.isStored()) {
            this.m_provider.save(this);
        } else {
            INaviModule naviModule = this.m_configuration.getModule();
            CView newView = naviModule == null ? this.m_provider.createView(this.m_configuration.getProject(), (INaviView)this, this.getName(), this.m_configuration.getDescription()) : this.m_provider.createView(naviModule, (INaviView)this, this.getName(), this.m_configuration.getDescription());
            this.m_configuration.setId(newView.getConfiguration().getId());
        }
        IDirectedGraph graph = this.m_content.getGraph();
        this.m_bbcount = graph.nodeCount();
        this.m_edgecount = graph.edgeCount();
        for (INaviViewListener listener : this.m_listeners) {
            listener.savedView(this);
        }
        this.m_configuration.updateModificationDate();
        this.m_content.save();
        this.m_lastGraphType = this.m_content.getGraphType();
        NodeCache.get(this.m_provider).addNodes(graph.getNodes());
        EdgeCache.get(this.m_provider).addEdges(graph.getEdges());
    }

    @Override
    public void saveSettings(Map<String, String> settings) throws CouldntSaveDataException {
        if (!this.m_configuration.isStored()) {
            throw new IllegalStateException("IE01111: Settings can not be saved before view is saved");
        }
        this.m_provider.saveSettings(this, settings);
    }

    @Override
    public boolean wasModified() {
        return !this.m_configuration.isStored() || this.m_content != null && this.m_content.wasModified();
    }
}

