/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeHelpers;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.List;

public class TypeSubstitution {
    private final int position;
    private int offset;
    private BaseType baseType;
    private final IAddress address;
    private final INaviOperandTreeNode node;
    private final int expressionId;
    private List<TypeMember> memberPath;

    TypeSubstitution(INaviOperandTreeNode node, BaseType baseType, int expressionId, int position, int offset, IAddress address) {
        this(node, baseType, new ArrayList<TypeMember>(), expressionId, position, offset, address);
    }

    private static String toByteOffsetString(int bitOffset) {
        int byteOffset = bitOffset < 0 ? (bitOffset - 7) / 8 : (bitOffset + 7) / 8;
        return bitOffset < 0 ? String.format("%d", byteOffset) : String.format("+%d", byteOffset);
    }

    TypeSubstitution(INaviOperandTreeNode node, BaseType baseType, List<TypeMember> memberPath, int expressionId, int position, int offset, IAddress address) {
        this.baseType = Preconditions.checkNotNull(baseType, "Error: Base type argument for type substitution can not be null.");
        this.memberPath = Preconditions.checkNotNull(memberPath, "Error: Member path can not be null.");
        this.expressionId = expressionId;
        Preconditions.checkArgument(position >= 0, "Error: Position argument for type substitution can not be negative.");
        this.position = position;
        Preconditions.checkArgument(offset >= 0, "Error: Offset argument for type substitution can not be negative.");
        this.offset = offset;
        this.node = Preconditions.checkNotNull(node, "IE02802: Node argument for type substitution can not be null.");
        this.address = Preconditions.checkNotNull(address, "Error: Address argument for type sbustitution can not be null.");
    }

    private static String renderArray(BaseType baseType, int offset) {
        return BaseTypeHelpers.findMember(baseType, offset).getPathString();
    }

    private static String renderStruct(BaseType baseType, int offset) {
        BaseTypeHelpers.WalkResult result = BaseTypeHelpers.findMember(baseType, offset);
        if (result.getMember() == null) {
            return String.format("%s%s", baseType.getName(), TypeSubstitution.toByteOffsetString(offset));
        }
        return result.getPathString();
    }

    public List<TypeMember> getMemberPath() {
        return this.memberPath;
    }

    public static String generateTypeString(TypeSubstitution typeSubstitution, long operandValue) {
        BaseType baseType = typeSubstitution.getBaseType();
        int totaBitOffset = (int)operandValue * 8 + typeSubstitution.getOffset();
        switch (baseType.getCategory()) {
            case STRUCT: {
                return TypeSubstitution.renderStruct(baseType, totaBitOffset);
            }
            case UNION: {
                return TypeSubstitution.renderUnion(baseType, typeSubstitution.getMemberPath(), totaBitOffset);
            }
            case ARRAY: {
                return TypeSubstitution.renderArray(baseType, totaBitOffset);
            }
            case ATOMIC: 
            case POINTER: {
                return TypeSubstitution.renderAtomic(baseType, totaBitOffset);
            }
        }
        return "";
    }

    private static String renderAtomic(BaseType baseType, int totalOffset) {
        if (totalOffset == 0) {
            return baseType.getName();
        }
        return String.format("%s%s", baseType.getName(), TypeSubstitution.toByteOffsetString(totalOffset));
    }

    private static String renderUnion(BaseType baseType, List<TypeMember> memberPath, int offset) {
        StringBuilder path = new StringBuilder(baseType.getName());
        for (TypeMember member : memberPath) {
            path.append('.');
            path.append(member.getName());
        }
        if (offset != 0) {
            path.append(TypeSubstitution.toByteOffsetString(offset));
        }
        return path.toString();
    }

    void setMemberPath(List<TypeMember> memberPath) {
        this.memberPath = memberPath;
    }

    void setBaseType(BaseType baseType) {
        this.baseType = baseType;
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    public IAddress getAddress() {
        return this.address;
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public int getExpressionId() {
        return this.expressionId;
    }

    public int getOffset() {
        return this.offset;
    }

    public INaviOperandTreeNode getOperandTreeNode() {
        return this.node;
    }

    public int getPosition() {
        return this.position;
    }
}

