/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.MemberMoveResult;
import com.google.security.zynamics.binnavi.disassembly.types.RawBaseType;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.TypeChangedListener;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManagerBackend;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitutionChangedListener;
import com.google.security.zynamics.binnavi.yfileswrap.disassembly.types.TypeDependenceGraph;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeManager {
    private final TypesContainer typesContainer;
    private final ListenerProvider<TypeChangedListener> typeListeners = new ListenerProvider();
    private final ListenerProvider<TypeSubstitutionChangedListener> substitutionListeners = new ListenerProvider();
    private final TypeManagerBackend backend;

    public TypeManager(TypeManagerBackend backend) throws CouldntLoadDataException {
        this.backend = Preconditions.checkNotNull(backend, "IE02774: Backend can not be null.");
        this.typesContainer = new TypesContainer(backend.loadRawBaseTypes(), backend.loadRawTypeMembers());
    }

    private static String buildArrayName(BaseType elementType, int numberElements) {
        return String.format("%s[%d]", elementType.getName(), numberElements);
    }

    private static boolean canDeletePointerType(BaseType baseType) {
        return baseType.pointedToBy() == null;
    }

    private static List<Integer> membersToIds(List<TypeMember> members) {
        ArrayList<Integer> result = Lists.newArrayList();
        for (TypeMember member : members) {
            result.add(member.getId());
        }
        return result;
    }

    private List<TypeMember> idsToMembers(Integer[] memberIds) {
        ArrayList<TypeMember> members = Lists.newArrayList();
        Integer[] integerArray = memberIds;
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int id = integerArray[i2];
            members.add(this.typesContainer.getTypeMemberById(id));
        }
        return members;
    }

    private void clearMembers(BaseType deletedType, Set<BaseType> affectedTypes) {
        this.notifyMembersDeleted(this.typesContainer.clearMembers(deletedType, affectedTypes));
    }

    private void clearTypeSubstitutions(BaseType deletedType) throws CouldntDeleteException {
        Set<TypeSubstitution> substitutions = this.typesContainer.deleteSubstitutionsByType(deletedType);
        if (!substitutions.isEmpty()) {
            for (TypeSubstitution substitution : substitutions) {
                this.backend.deleteTypeSubstitution(substitution);
            }
            this.notifySubstitutionsDeleted(substitutions);
        }
    }

    private int getDefaultPointerSize() {
        return 32;
    }

    private TypeMember createArrayMember(BaseType containingType, BaseType memberType, String memberName, int memberNumberOfElements) throws CouldntSaveDataException {
        if (!this.typesContainer.willTypeCreateCyclicReference(containingType, memberType)) {
            TypeMember member = this.backend.createArrayMember(containingType, memberType, memberName, memberNumberOfElements);
            this.typesContainer.addMember(member);
            return member;
        }
        throw new IllegalStateException("Error: cannot create cyclic member declaration.");
    }

    private BaseType instantiateType(String name, int size, boolean signed, BaseType childPointer, BaseTypeCategory category) throws CouldntSaveDataException {
        BaseType baseType = this.backend.createType(name, size, signed, childPointer == null ? null : Integer.valueOf(childPointer.getId()), category);
        if (childPointer != null) {
            BaseType.appendToPointerHierarchy(childPointer, baseType);
        }
        this.typesContainer.addBaseType(baseType);
        return baseType;
    }

    private void notifyMemberAdded(TypeMember member) {
        for (TypeChangedListener listener : this.typeListeners) {
            listener.memberAdded(member);
        }
    }

    private void notifyMemberDeleted(TypeMember member) {
        for (TypeChangedListener listener : this.typeListeners) {
            listener.memberDeleted(member);
        }
    }

    private void notifyMembersDeleted(List<TypeMember> membersToDelete) {
        for (TypeMember member : membersToDelete) {
            this.notifyMemberDeleted(member);
        }
    }

    private void notifyMembersMoved(Set<BaseType> affectedTypes) {
        for (TypeChangedListener listener : this.typeListeners) {
            listener.membersMoved(affectedTypes);
        }
    }

    private void notifyMemberUpdated(TypeMember member) {
        for (TypeChangedListener listener : this.typeListeners) {
            listener.memberUpdated(member);
        }
    }

    private void notifySubstitutionAdded(TypeSubstitution substitution) {
        for (TypeSubstitutionChangedListener listener : this.substitutionListeners) {
            listener.substitutionsAdded(Sets.newHashSet(substitution));
        }
    }

    private void notifySubstitutionChanged(TypeSubstitution substitution) {
        for (TypeSubstitutionChangedListener listener : this.substitutionListeners) {
            listener.substitutionsChanged(Sets.newHashSet(substitution));
        }
    }

    private void notifySubstitutionsChanged(Set<BaseType> baseTypes) {
        Set changedSubstitutions = this.typesContainer.getAffectedTypeSubstitutions(baseTypes);
        for (TypeSubstitutionChangedListener listener : this.substitutionListeners) {
            listener.substitutionsChanged(changedSubstitutions);
        }
    }

    private void notifySubstitutionsDeleted(Set<TypeSubstitution> deletedSubstitutions) {
        for (TypeSubstitutionChangedListener listener : this.substitutionListeners) {
            listener.substitutionsDeleted(deletedSubstitutions);
        }
    }

    private void notifyTypeAdded(BaseType baseType) {
        for (TypeChangedListener listener : this.typeListeners) {
            listener.typeAdded(baseType);
        }
    }

    private synchronized void notifyTypeDeleted(BaseType deletedType) {
        for (TypeChangedListener listener : this.typeListeners) {
            listener.typeDeleted(deletedType);
        }
    }

    private synchronized void notifyTypesUpdated(ImmutableSet<BaseType> baseType) {
        for (TypeChangedListener listener : this.typeListeners) {
            listener.typesUpdated(baseType);
        }
    }

    public synchronized void addListener(TypeChangedListener listener) {
        this.typeListeners.addListener(listener);
    }

    public synchronized void addListener(TypeSubstitutionChangedListener listener) {
        this.substitutionListeners.addListener(listener);
    }

    private static Integer determineAppendOffset(BaseType baseType) {
        Preconditions.checkArgument(BaseTypeCategory.isOffsetCategory(baseType.getCategory()), "Error: Can only determine append offset if base type is of offset category.");
        if (!baseType.hasMembers()) {
            return 0;
        }
        TypeMember lastMember = baseType.getLastMember();
        return lastMember.getBitOffset().get() + lastMember.getBitSize();
    }

    private static Integer determineAppendIndex(BaseType baseType) {
        Preconditions.checkArgument(baseType.getCategory() == BaseTypeCategory.FUNCTION_PROTOTYPE, "Error: Can only determine append index if base type is of index category.");
        if (baseType.hasMembers()) {
            TypeMember lastMember = baseType.getLastMember();
            return lastMember.getArgumentIndex().get() + 1;
        }
        return 0;
    }

    public synchronized TypeMember appendMember(BaseType containingType, BaseType memberType, String memberName) throws CouldntSaveDataException {
        Preconditions.checkNotNull(containingType, "IE02775: Containing type can not be null.");
        Preconditions.checkNotNull(memberType, "IE02776: Base type can not be null.");
        Preconditions.checkNotNull(memberName, "IE02777: Member name can not be null.");
        switch (containingType.getCategory()) {
            case STRUCT: {
                return this.createStructureMember(containingType, memberType, memberName, TypeManager.determineAppendOffset(containingType));
            }
            case UNION: {
                return this.createUnionMember(containingType, memberType, memberName);
            }
            case FUNCTION_PROTOTYPE: {
                return this.createFunctionPrototypeMember(containingType, memberType, memberName, TypeManager.determineAppendIndex(containingType));
            }
        }
        throw new IllegalStateException("Error: cannot insert member into non-compound type.");
    }

    public synchronized TypeMember createFunctionPrototypeMember(BaseType containingType, BaseType memberType, String memberName, int memberArgumentIndex) throws CouldntSaveDataException {
        Preconditions.checkNotNull(containingType, "Error: containing type argument can not be null");
        Preconditions.checkNotNull(memberType, "Error: member type can not be null");
        Preconditions.checkArgument(containingType.getCategory() == BaseTypeCategory.FUNCTION_PROTOTYPE, "Error: the base type category is not of type function prototype");
        Preconditions.checkNotNull(memberName, "Error: name argument can not be null");
        Preconditions.checkArgument(!memberName.isEmpty(), "Error: name argument can not be empty");
        Preconditions.checkArgument(memberArgumentIndex >= 0, "Error: argument index argument can not be smaller than zero");
        if (this.typesContainer.willTypeCreateCyclicReference(containingType, memberType)) {
            return null;
        }
        TypeMember member = this.backend.createFunctionPrototypeMember(containingType, memberType, memberName, memberArgumentIndex);
        this.notifyMemberCreation(member, this.typesContainer.addMember(member));
        return member;
    }

    private synchronized void notifyMemberCreation(TypeMember member, ImmutableSet<BaseType> affectedTypes) {
        this.notifyMemberAdded(member);
        this.notifySubstitutionsChanged(affectedTypes);
    }

    private synchronized void notifyMemberUpdated(TypeMember member, ImmutableSet<BaseType> affectedTypes) {
        this.notifyMemberUpdated(member);
        this.notifySubstitutionsChanged(affectedTypes);
    }

    public synchronized TypeMember createStructureMember(BaseType containingType, BaseType memberType, String memberName, int memberOffset) throws CouldntSaveDataException {
        int moveDelta;
        Preconditions.checkNotNull(containingType, "Error: containing type argument can not be null");
        Preconditions.checkNotNull(memberType, "Error: member type can not be null");
        Preconditions.checkNotNull(memberName, "Error: name argument can not be null");
        Preconditions.checkArgument(!memberName.isEmpty(), "Error: name argument can not be empty");
        Preconditions.checkArgument(memberOffset >= 0, "Error: argument index argument can not be smaller than zero");
        if (this.typesContainer.willTypeCreateCyclicReference(containingType, memberType)) {
            return null;
        }
        ImmutableMap<BaseType, Integer> originalTypeSizes = TypeManager.captureTypeSizesState(this.typesContainer.getAffectedTypes(containingType));
        ImmutableList<TypeMember> subsequentMembers = containingType.getSubsequentMembersInclusive(memberOffset);
        if (!subsequentMembers.isEmpty() && (moveDelta = memberOffset + memberType.getBitSize() - ((TypeMember)subsequentMembers.get(0)).getBitOffset().get()) > 0) {
            for (TypeMember member : subsequentMembers) {
                int newOffset = member.getBitOffset().get() + moveDelta;
                this.backend.updateStructureMember(member, member.getBaseType(), member.getName(), newOffset);
                member.setOffset(Optional.of(newOffset));
                this.notifyMemberUpdated(member);
            }
        }
        TypeMember member = this.backend.createStructureMember(containingType, memberType, memberName, memberOffset);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.addMember(member);
        this.notifyMemberCreation(member, affectedTypes);
        HashSet<BaseType> inconsistentTypes = Sets.newHashSet(affectedTypes);
        inconsistentTypes.remove(containingType);
        this.ensureConsistencyAfterTypeUpdate(affectedTypes, inconsistentTypes, originalTypeSizes);
        return member;
    }

    public synchronized TypeMember createUnionMember(BaseType containingType, BaseType memberType, String memberName) throws CouldntSaveDataException {
        Preconditions.checkArgument(containingType.getCategory() == BaseTypeCategory.UNION, "Error: can not create a union member in a non union compound type.");
        return this.createStructureMember(containingType, memberType, memberName, 0);
    }

    public synchronized BaseType createArray(BaseType elementType, int numberElements) throws CouldntSaveDataException {
        Preconditions.checkNotNull(elementType, "Error: element type argument can not be null.");
        String arrayName = TypeManager.buildArrayName(elementType, numberElements);
        BaseType arrayType = this.instantiateType(arrayName, elementType.getBitSize() * numberElements, false, null, BaseTypeCategory.ARRAY);
        this.createArrayMember(arrayType, elementType, "array_elements", numberElements);
        this.notifyTypeAdded(arrayType);
        return arrayType;
    }

    public synchronized BaseType createUnion(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "Error: type name can not be null.");
        Preconditions.checkArgument(!name.isEmpty(), "Error: type name can not be empty.");
        BaseType unionType = this.instantiateType(name, 0, false, null, BaseTypeCategory.UNION);
        this.notifyTypeAdded(unionType);
        return unionType;
    }

    public synchronized BaseType createPrototype() throws CouldntSaveDataException {
        BaseType prototypeType = this.instantiateType(null, 0, false, null, BaseTypeCategory.FUNCTION_PROTOTYPE);
        this.notifyTypeAdded(prototypeType);
        return prototypeType;
    }

    public synchronized BaseType createAtomicType(String name, int size, boolean signed) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE02778: Type name can not be null.");
        Preconditions.checkArgument(size >= 0, "Size can not be negative.");
        BaseType newType = this.instantiateType(name, size, signed, null, BaseTypeCategory.ATOMIC);
        this.notifyTypeAdded(newType);
        return newType;
    }

    public synchronized BaseType createPointerType(BaseType baseType) throws CouldntSaveDataException {
        Preconditions.checkNotNull(baseType, "IE02781: Base type can not be null.");
        if (baseType.pointedToBy() != null) {
            return baseType.pointedToBy();
        }
        String newTypeName = BaseType.getPointerTypeName(baseType, baseType.getPointerLevel() + 1);
        BaseType newType = this.instantiateType(newTypeName, this.getDefaultPointerSize(), false, baseType, BaseTypeCategory.POINTER);
        this.notifyTypeAdded(newType);
        return newType;
    }

    public synchronized TypeSubstitution createTypeSubstitution(INaviOperandTreeNode node, BaseType baseType, List<TypeMember> memberPath, int position, int offset, IAddress address) throws CouldntSaveDataException {
        Preconditions.checkNotNull(node, "IE02782: Operand tree node can not be null.");
        Preconditions.checkNotNull(baseType, "IE02783: Base type can not be null.");
        Preconditions.checkArgument(offset >= 0, "Offset can not be negative.");
        Preconditions.checkNotNull(address, "IE02784: Address can not be null.");
        TypeSubstitution substitution = this.backend.createTypeSubstitution(node, baseType, TypeManager.membersToIds(memberPath), position, offset, address);
        this.typesContainer.addTypeSubstitution(substitution);
        node.setTypeSubstitution(substitution);
        this.notifySubstitutionAdded(substitution);
        return substitution;
    }

    public synchronized TypeSubstitution createTypeSubstitution(INaviOperandTreeNode node, BaseType baseType, int position, int offset, IAddress address) throws CouldntSaveDataException {
        return this.createTypeSubstitution(node, baseType, new ArrayList<TypeMember>(), position, offset, address);
    }

    public synchronized void deleteMember(TypeMember member) throws CouldntDeleteException, CouldntSaveDataException {
        Preconditions.checkNotNull(member, "IE02785: Member can not be null.");
        this.backend.deleteMember(member);
        BaseType containingType = member.getParentType();
        boolean sizeChanged = member == containingType.getLastMember();
        ImmutableMap<BaseType, Integer> originalTypeSizes = sizeChanged ? TypeManager.captureTypeSizesState(this.typesContainer.getAffectedTypes(containingType)) : ImmutableMap.of();
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.deleteTypeMember(member);
        this.notifySubstitutionsChanged(affectedTypes);
        this.notifyTypesUpdated(affectedTypes);
        this.notifyMemberDeleted(member);
        if (sizeChanged) {
            this.ensureConsistencyAfterTypeUpdate(affectedTypes, Sets.newHashSet(affectedTypes), originalTypeSizes);
        }
    }

    public synchronized boolean deleteType(BaseType baseType) throws CouldntDeleteException {
        Preconditions.checkNotNull(baseType, "IE02786: Base type can not be null.");
        if (!TypeManager.canDeletePointerType(baseType)) {
            return false;
        }
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.getAffectedTypes(baseType);
        this.clearMembers(baseType, affectedTypes);
        this.clearTypeSubstitutions(baseType);
        this.typesContainer.deleteBaseType(baseType);
        this.backend.deleteType(baseType);
        this.notifyTypeDeleted(baseType);
        return true;
    }

    public synchronized BaseType createStructure(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "Name can not be null.");
        BaseType structType = this.instantiateType(name, 0, false, null, BaseTypeCategory.STRUCT);
        this.notifyTypeAdded(structType);
        return structType;
    }

    public synchronized void deleteTypeSubstitution(INaviOperandTreeNode node) throws CouldntDeleteException {
        Preconditions.checkNotNull(node, "IE02787: Operand tree node can not be null.");
        TypeSubstitution substitution = node.getTypeSubstitution();
        this.typesContainer.deleteTypeSubstitution(substitution);
        this.backend.deleteTypeSubstitution(substitution);
        node.setTypeSubstitution(null);
        this.notifySubstitutionsDeleted(Collections.singleton(substitution));
    }

    public synchronized BaseType getBaseType(int typeId) {
        return this.typesContainer.getBaseTypeById(typeId);
    }

    public synchronized List<BaseType> getTypes() {
        return this.typesContainer.getTypes();
    }

    public synchronized void initializeTypeSubstitution(INaviOperandTreeNode node, RawTypeSubstitution rawSubstitution) {
        Preconditions.checkNotNull(node, "IE02420: Operand tree node can not be null.");
        Preconditions.checkNotNull(rawSubstitution, "IE02421: Raw type substitution can not be null.");
        BaseType baseType = this.typesContainer.getBaseTypeById(rawSubstitution.getBaseTypeId());
        TypeSubstitution substitution = new TypeSubstitution(node, baseType, rawSubstitution.getExpressionId(), rawSubstitution.getPosition(), rawSubstitution.getOffset(), rawSubstitution.getAddress());
        node.setTypeSubstitution(substitution);
        this.typesContainer.addTypeSubstitution(substitution);
        this.notifySubstitutionAdded(substitution);
    }

    public synchronized TypeMember insertMemberAfter(TypeMember existingMember, BaseType memberType, String memberName) throws CouldntSaveDataException {
        Preconditions.checkNotNull(existingMember, "Error: existing member can not be null.");
        switch (existingMember.getParentType().getCategory()) {
            case STRUCT: {
                return this.createStructureMember(existingMember.getParentType(), memberType, memberName, existingMember.getBitSize() + existingMember.getBitOffset().get());
            }
            case UNION: {
                return this.createUnionMember(existingMember.getParentType(), memberType, memberName);
            }
            case FUNCTION_PROTOTYPE: {
                return this.createFunctionPrototypeMember(existingMember.getParentType(), memberType, memberName, existingMember.getArgumentIndex().get() + 1);
            }
        }
        throw new IllegalStateException("Error: cannot insert member into non-compound type.");
    }

    public synchronized boolean isContainedIn(BaseType superType, BaseType baseType) {
        Preconditions.checkNotNull(superType, "Error: Super type can not be null.");
        Preconditions.checkNotNull(baseType, "Error: Base type can not be null.");
        return this.typesContainer.isTypeContainedIn(superType, baseType);
    }

    public synchronized boolean isTypeExisting(String name) {
        Preconditions.checkNotNull(name, "Error: Name can not be null.");
        return this.typesContainer.doesTypeNameExist(name);
    }

    public synchronized void loadAndInitializeBaseType(int baseTypeId) throws CouldntLoadDataException {
        BaseType baseType = this.backend.loadRawBaseType(baseTypeId);
        this.typesContainer.addBaseType(baseType);
        this.notifyTypeAdded(baseType);
    }

    public synchronized void loadAndInitializeTypeMember(int rawMemberId) throws CouldntLoadDataException {
        RawTypeMember typeMember = this.backend.loadRawTypeMember(rawMemberId);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.addMember(typeMember);
        this.notifyMemberAdded(this.typesContainer.getTypeMemberById(rawMemberId));
        this.notifyTypesUpdated(affectedTypes);
        this.notifySubstitutionsChanged(affectedTypes);
    }

    public synchronized void loadAndUpdateBaseType(int baseTypeId) throws CouldntLoadDataException {
        BaseType newBaseType = this.backend.loadRawBaseType(baseTypeId);
        BaseType oldBaseType = this.typesContainer.getBaseTypeById(baseTypeId);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.updateBaseType(oldBaseType, newBaseType.getName(), newBaseType.isSigned(), newBaseType.getBitSize());
        this.notifyTypesUpdated(affectedTypes);
        this.notifySubstitutionsChanged(affectedTypes);
    }

    public synchronized void loadAndUpdateTypeMember(int typeMemberId) throws CouldntLoadDataException {
        TypeMember typeMember = this.typesContainer.getTypeMemberById(typeMemberId);
        RawTypeMember rawTypeMember = this.backend.loadRawTypeMember(typeMemberId);
        BaseType baseType = this.typesContainer.getBaseTypeById(rawTypeMember.getBaseTypeId());
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.updateTypeMember(typeMember, baseType, rawTypeMember.getName(), rawTypeMember.getOffset(), rawTypeMember.getNumberOfElements(), rawTypeMember.getArgumentIndex());
        this.notifyMemberUpdated(typeMember);
        this.notifySubstitutionsChanged(affectedTypes);
        this.notifyTypesUpdated(affectedTypes);
    }

    public synchronized void moveMembers(BaseType parentType, List<TypeMember> members, int delta) throws CouldntSaveDataException {
        Preconditions.checkNotNull(parentType, "Error: parent type can not be null.");
        Preconditions.checkNotNull(members, "Error: members can not be null.");
        Preconditions.checkArgument(delta != 0, "Move delta can not be zero.");
        MemberMoveResult result = parentType.moveMembers(Sets.newTreeSet(members), delta);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.getAffectedTypes(parentType);
        this.backend.updateMemberOffsets(TypeManager.membersToIds(members), delta, TypeManager.membersToIds(result.getImplicitlyMoved()), result.getImplicitlyMovedDelta());
        this.notifyMembersMoved(affectedTypes);
    }

    public synchronized void removeBaseTypeInstance(int baseTypeId) {
        BaseType deletedType = this.typesContainer.getBaseTypeById(baseTypeId);
        Set<BaseType> affectedTypes = this.typesContainer.deleteBaseTypeById(baseTypeId);
        this.clearMembers(deletedType, affectedTypes);
        this.notifySubstitutionsDeleted(this.typesContainer.deleteSubstitutionsByType(deletedType));
        this.notifyTypeDeleted(deletedType);
    }

    public synchronized void removeListener(TypeChangedListener listener) {
        Preconditions.checkNotNull(listener, "IE02790: Listener argument can not be null.");
        this.typeListeners.removeListener(listener);
    }

    public synchronized void removeListener(TypeSubstitutionChangedListener listener) {
        Preconditions.checkNotNull(listener, "Error: Listener argument can not be null.");
        this.substitutionListeners.removeListener(listener);
    }

    public synchronized void removeMemberInstance(int typeMemberId) {
        TypeMember typeMember = this.typesContainer.getTypeMemberById(typeMemberId);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.deleteTypeMemberById(typeMemberId);
        this.notifySubstitutionsChanged(affectedTypes);
        this.notifyTypesUpdated(affectedTypes);
        this.notifyMemberDeleted(typeMember);
    }

    public synchronized void removeTypeSubstitutionInstance(TypeSubstitution substitution) {
        Preconditions.checkNotNull(substitution, "Error: substitution argument can not be null");
        this.typesContainer.deleteTypeSubstitution(substitution);
    }

    public synchronized void setStackFrame(BaseType baseType) {
        Preconditions.checkNotNull(baseType, "Error: baseType argument can not be null");
        baseType.setIsStackFrame(true);
    }

    public synchronized void updateArray(BaseType arrayType, BaseType elementType, int numberOfElements) throws CouldntSaveDataException {
        Preconditions.checkNotNull(arrayType, "IE02791: Base type can not be null.");
        Preconditions.checkArgument(arrayType.getCategory() == BaseTypeCategory.ARRAY, "Base type must be an array.");
        Preconditions.checkNotNull(elementType, "IE02792: Element type can not be null.");
        Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be above zero.");
        TypeMember arrayMember = arrayType.iterator().next();
        this.typesContainer.updateTypeMember(arrayMember, elementType, arrayMember.getName(), arrayMember.getBitOffset(), Optional.of(numberOfElements), arrayMember.getArgumentIndex());
        int newArraySize = arrayMember.getNumberOfElements().get() * arrayMember.getBitSize();
        String newArrayName = TypeManager.buildArrayName(elementType, numberOfElements);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.updateBaseType(arrayType, newArrayName, arrayType.isSigned(), newArraySize);
        this.backend.updateArrayMember(arrayMember, elementType, numberOfElements);
        this.backend.updateType(arrayType, newArrayName, arrayType.getBitSize(), arrayType.isSigned());
        this.notifyTypesUpdated(affectedTypes);
    }

    public synchronized void updateStructureMember(TypeMember updatedMember, BaseType newMemberBaseType, String newMemberName, int newMemberOffset) throws CouldntSaveDataException {
        Preconditions.checkNotNull(updatedMember, "Error: updated member argument can not be null.");
        Preconditions.checkArgument(updatedMember.getParentType().getCategory() == BaseTypeCategory.STRUCT, "Error: updated member argument must be a member of a struct base type.");
        Preconditions.checkNotNull(newMemberBaseType, "Error: new member base type argument can not be null.");
        Preconditions.checkNotNull(newMemberName, "Error: new member name argument can not be null.");
        Preconditions.checkArgument(!newMemberName.isEmpty(), "Error: new member name argument can not be empty.");
        Preconditions.checkArgument(newMemberOffset >= 0, "Error: new member offset argument must be larger or equal to zero");
        ImmutableMap<BaseType, Integer> originalTypeSizes = TypeManager.captureTypeSizesState(this.typesContainer.getAffectedTypes(updatedMember.getParentType()));
        int memberSizeDelta = newMemberBaseType.getBitSize() - updatedMember.getBaseType().getBitSize();
        this.backend.updateStructureMember(updatedMember, newMemberBaseType, newMemberName, newMemberOffset);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.updateTypeMember(updatedMember, newMemberBaseType, newMemberName, Optional.of(newMemberOffset), updatedMember.getNumberOfElements(), updatedMember.getArgumentIndex());
        this.notifyMemberUpdated(updatedMember, affectedTypes);
        for (TypeMember member : updatedMember.getParentType().getSubsequentMembers(updatedMember)) {
            this.backend.updateStructureMember(member, member.getBaseType(), member.getName(), member.getBitOffset().get() + memberSizeDelta);
        }
        this.ensureConsistencyAfterTypeUpdate(affectedTypes, Sets.newHashSet(affectedTypes), originalTypeSizes);
    }

    public synchronized void updateUnionMember(TypeMember updatedMember, BaseType newMemberBaseType, String newMemberName) throws CouldntSaveDataException {
        this.updateStructureMember(updatedMember, newMemberBaseType, newMemberName, 0);
    }

    public synchronized void updateFunctionPrototypeMember(TypeMember updatedMember, BaseType newMemberBaseType, String newMemberName, int newMemberArgumentIndex) throws CouldntSaveDataException {
        Preconditions.checkNotNull(updatedMember, "Error: updated member argument can not be null.");
        Preconditions.checkArgument(updatedMember.getParentType().getCategory() == BaseTypeCategory.STRUCT, "Error: updated member argument must be a member of a struct base type.");
        Preconditions.checkNotNull(newMemberBaseType, "Error: new member base type argument can not be null.");
        Preconditions.checkNotNull(newMemberName, "Error: new member name argument can not be null.");
        Preconditions.checkArgument(!newMemberName.isEmpty(), "Error: new member name argument can not be empty.");
        Preconditions.checkArgument(newMemberArgumentIndex >= 0, "Error: new member argument index argument must be larger or equal to zero");
        this.backend.updateFunctionPrototypeMember(updatedMember, newMemberBaseType, newMemberName, newMemberArgumentIndex);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.updateTypeMember(updatedMember, newMemberBaseType, newMemberName, updatedMember.getBitOffset(), updatedMember.getNumberOfElements(), Optional.of(newMemberArgumentIndex));
        this.notifyMemberUpdated(updatedMember, affectedTypes);
    }

    private static ImmutableMap<BaseType, Integer> captureTypeSizesState(Set<BaseType> baseTypes) {
        ImmutableMap.Builder<BaseType, Integer> builder = ImmutableMap.builder();
        for (BaseType baseType : baseTypes) {
            if (baseType.getCategory() == BaseTypeCategory.FUNCTION_PROTOTYPE) continue;
            builder.put(baseType, baseType.getBitSize());
        }
        return builder.build();
    }

    public synchronized void updateType(BaseType baseType, String name, int size, boolean isSigned) throws CouldntSaveDataException {
        Preconditions.checkNotNull(baseType, "IE02422: Base type argument can not be null.");
        Preconditions.checkNotNull(name, "IE02621: Name argument can not be null.");
        Preconditions.checkArgument(size >= 0, "Size argument can not be negative.");
        boolean sizeChanged = baseType.getBitSize() != size;
        ImmutableMap<BaseType, Integer> originalTypeSizes = sizeChanged ? TypeManager.captureTypeSizesState(this.typesContainer.getAffectedTypes(baseType)) : ImmutableMap.of();
        this.backend.updateType(baseType, name, size, isSigned);
        ImmutableSet<BaseType> affectedTypes = this.typesContainer.updateBaseType(baseType, name, isSigned, size);
        this.notifyTypesUpdated(affectedTypes);
        this.notifySubstitutionsChanged(affectedTypes);
        if (sizeChanged) {
            this.ensureConsistencyAfterTypeUpdate(affectedTypes, Sets.newHashSet(affectedTypes), originalTypeSizes);
        }
    }

    public synchronized void renameType(BaseType baseType, String newName) throws CouldntSaveDataException {
        this.updateType(baseType, newName, baseType.getBitSize(), baseType.isSigned());
    }

    public synchronized void updateTypeSubstitution(INaviOperandTreeNode node, int baseTypeId, Integer[] memberPathIds, int offset) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null.");
        Preconditions.checkNotNull(memberPathIds, "Error: member path ids can not be null.");
        BaseType baseType = this.typesContainer.getBaseTypeById(baseTypeId);
        TypeSubstitution typeSubstitution = node.getTypeSubstitution();
        this.typesContainer.updateTypeSubstitution(typeSubstitution, baseType, this.idsToMembers(memberPathIds), offset);
        this.notifySubstitutionChanged(typeSubstitution);
    }

    public synchronized void updateTypeSubstitution(INaviOperandTreeNode node, TypeSubstitution substitution, BaseType baseType, List<TypeMember> memberPath, int offset) throws CouldntSaveDataException {
        Preconditions.checkNotNull(node, "IE02799: Operand tree node can not be null.");
        Preconditions.checkNotNull(substitution, "IE02800: Type subustitution can not be null.");
        Preconditions.checkNotNull(baseType, "IE02801: Base type can not be null.");
        this.typesContainer.updateTypeSubstitution(substitution, baseType, memberPath, offset);
        this.backend.updateSubstitution(substitution, baseType, TypeManager.membersToIds(memberPath), offset);
        this.notifySubstitutionChanged(substitution);
    }

    private void adjustMemberOffsets(BaseType structTypeToFix, Set<BaseType> inconsistentTypes, Map<BaseType, Integer> oldSizes, Set<BaseType> affectedTypes) throws CouldntSaveDataException {
        if (!inconsistentTypes.contains(structTypeToFix)) {
            return;
        }
        ImmutableList<TypeMember> affectedMembers = TypeManager.determineMembersToUpdate(structTypeToFix, affectedTypes);
        int sizeDelta = 0;
        for (TypeMember member : affectedMembers) {
            BaseType memberBaseType = member.getBaseType();
            if (inconsistentTypes.contains(memberBaseType)) {
                this.adjustMemberOffsets(memberBaseType, inconsistentTypes, oldSizes, affectedTypes);
            }
            if (sizeDelta != 0) {
                Integer newOffset = member.getBitOffset().get() + sizeDelta;
                this.backend.updateStructureMember(member, member.getBaseType(), member.getName(), newOffset);
                this.notifyMemberUpdated(member);
                member.setOffset(Optional.of(newOffset));
            }
            if (!oldSizes.containsKey(memberBaseType)) continue;
            sizeDelta += memberBaseType.getBitSize() - oldSizes.get(memberBaseType);
        }
        inconsistentTypes.remove(structTypeToFix);
    }

    private static ImmutableList<TypeMember> determineMembersToUpdate(BaseType baseType, Set<BaseType> affectedTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean includeMember = false;
        for (TypeMember member : baseType) {
            if (affectedTypes.contains(member.getBaseType()) && !includeMember) {
                includeMember = true;
            }
            if (!includeMember) continue;
            builder.add(member);
        }
        return builder.build();
    }

    private void ensureConsistencyAfterTypeUpdate(ImmutableSet<BaseType> affectedTypes, Set<BaseType> inconsistentTypes, Map<BaseType, Integer> oldSizes) throws CouldntSaveDataException {
        while (!inconsistentTypes.isEmpty()) {
            BaseType baseType = inconsistentTypes.iterator().next();
            if (baseType.getCategory() == BaseTypeCategory.STRUCT) {
                this.adjustMemberOffsets(baseType, inconsistentTypes, oldSizes, affectedTypes);
                continue;
            }
            inconsistentTypes.remove(baseType);
        }
    }

    private final class TypesContainer {
        private final Set<BaseType> types = new LinkedHashSet<BaseType>();
        private final Map<String, BaseType> typesByName = new HashMap<String, BaseType>();
        private final Map<Integer, BaseType> typesById = new HashMap<Integer, BaseType>();
        private final ArrayList<BaseType> stableTypeList = new ArrayList();
        private final HashMultimap<BaseType, TypeSubstitution> substitutionsByType = HashMultimap.create();
        private final Map<Integer, TypeMember> memberById = new HashMap<Integer, TypeMember>();
        private final TypeDependenceGraph dependenceGraph;

        public TypesContainer(List<RawBaseType> rawBaseTypes, List<RawTypeMember> rawMembers) {
            this.dependenceGraph = this.initializeTypeSystem(rawBaseTypes, rawMembers);
        }

        public void addBaseType(BaseType baseType) {
            Preconditions.checkNotNull(baseType, "Error: baseType argument can not be null");
            this.types.add(baseType);
            this.typesById.put(baseType.getId(), baseType);
            this.typesByName.put(baseType.getName(), baseType);
            this.stableTypeList.clear();
            this.dependenceGraph.addType(baseType);
        }

        public ImmutableSet<BaseType> addMember(RawTypeMember rawTypeMember) {
            if (rawTypeMember.getOffset().isPresent()) {
                return this.addMember(TypeMember.createStructureMember(rawTypeMember.getId(), this.typesById.get(rawTypeMember.getParentId()), this.typesById.get(rawTypeMember.getBaseTypeId()), rawTypeMember.getName(), rawTypeMember.getOffset().get()));
            }
            if (rawTypeMember.getNumberOfElements().isPresent()) {
                return this.addMember(TypeMember.createArrayMember(rawTypeMember.getId(), this.typesById.get(rawTypeMember.getParentId()), this.typesById.get(rawTypeMember.getBaseTypeId()), rawTypeMember.getName(), rawTypeMember.getNumberOfElements().get()));
            }
            if (rawTypeMember.getArgumentIndex().isPresent()) {
                return this.addMember(TypeMember.createFunctionPrototypeMember(rawTypeMember.getId(), this.typesById.get(rawTypeMember.getParentId()), this.typesById.get(rawTypeMember.getBaseTypeId()), rawTypeMember.getName(), rawTypeMember.getArgumentIndex().get()));
            }
            throw new IllegalStateException("Error: member can only be added to compound types.");
        }

        public ImmutableSet<BaseType> addMember(TypeMember member) {
            Preconditions.checkNotNull(member, "Error: typeMember argument can not be null");
            TypeDependenceGraph.DependenceResult result = this.dependenceGraph.addMember(member.getParentType(), member.getBaseType());
            if (!result.isValid()) {
                throw new IllegalStateException("Error: member would create cyclic reference.");
            }
            this.memberById.put(member.getId(), member);
            member.getParentType().addMember(member);
            return result.getAffectedTypes();
        }

        public void addTypeSubstitution(TypeSubstitution substitution) {
            this.substitutionsByType.put((Object)substitution.getBaseType(), (Object)substitution);
        }

        public List<TypeMember> clearMembers(BaseType deletedType, Set<BaseType> affectedTypes) {
            ArrayList<TypeMember> deletedMembers = Lists.newArrayList();
            for (BaseType currentType : affectedTypes) {
                ArrayList<TypeMember> membersToDelete = Lists.newArrayList();
                for (TypeMember member : currentType) {
                    if (member.getBaseType() != deletedType) continue;
                    membersToDelete.add(member);
                }
                if (membersToDelete.size() <= 0) continue;
                for (TypeMember typeMembert : membersToDelete) {
                    this.deleteTypeMember(typeMembert);
                }
                deletedMembers.addAll(membersToDelete);
            }
            return deletedMembers;
        }

        public Set<BaseType> deleteBaseType(BaseType baseType) {
            Preconditions.checkNotNull(baseType, "Error: baseType argument can not be null");
            this.types.remove(baseType);
            this.typesById.remove(baseType.getId());
            this.typesByName.remove(baseType.getName());
            this.substitutionsByType.removeAll(baseType);
            this.stableTypeList.clear();
            return this.dependenceGraph.deleteType(baseType);
        }

        public Set<BaseType> deleteBaseTypeById(int baseTypeId) {
            return this.deleteBaseType(this.typesById.get(baseTypeId));
        }

        public Set<TypeSubstitution> deleteSubstitutionsByType(BaseType deletedType) {
            return this.substitutionsByType.removeAll(deletedType);
        }

        public ImmutableSet<BaseType> deleteTypeMember(TypeMember typeMember) {
            Preconditions.checkNotNull(typeMember, "Error: typeMember argument can not be null");
            typeMember.getParentType().deleteMember(typeMember);
            this.memberById.remove(typeMember.getId());
            return this.dependenceGraph.deleteMember(typeMember);
        }

        public ImmutableSet<BaseType> deleteTypeMemberById(int typeMemberId) {
            return this.deleteTypeMember(this.memberById.get(typeMemberId));
        }

        public void deleteTypeSubstitution(TypeSubstitution typeSubstitution) {
            Preconditions.checkNotNull(typeSubstitution, "Error: typeSubstitution argument can not be null");
            this.substitutionsByType.remove(typeSubstitution.getBaseType(), typeSubstitution);
        }

        public boolean doesTypeNameExist(String name) {
            return this.typesByName.containsKey(name);
        }

        private Set<TypeSubstitution> getAffectedTypeSubstitutions(Set<BaseType> baseTypes) {
            Sets.SetView<BaseType> affectedTypes = Sets.intersection(baseTypes, this.substitutionsByType.keySet());
            HashSet<TypeSubstitution> typeSubstitutions = Sets.newHashSet();
            for (BaseType baseType : affectedTypes) {
                typeSubstitutions.addAll(this.substitutionsByType.get((Object)baseType));
            }
            return typeSubstitutions;
        }

        public ImmutableSet<BaseType> getAffectedTypes(BaseType baseType) {
            return this.dependenceGraph.determineDependentTypes(baseType);
        }

        public BaseType getBaseTypeById(int baseTypeId) {
            return this.typesById.get(baseTypeId);
        }

        public TypeMember getTypeMemberById(int typeMemberId) {
            return this.memberById.get(typeMemberId);
        }

        public List<BaseType> getTypes() {
            if (this.stableTypeList.isEmpty()) {
                this.stableTypeList.addAll(this.types);
            }
            return Collections.unmodifiableList(this.stableTypeList);
        }

        private TypeDependenceGraph initializeTypeSystem(List<RawBaseType> rawBaseTypes, List<RawTypeMember> rawMembers) {
            ImmutableList.Builder baseTypes = ImmutableList.builder();
            for (RawBaseType rawType : rawBaseTypes) {
                BaseType newType = new BaseType(rawType.getId(), rawType.getName(), rawType.getSize(), rawType.isSigned(), rawType.getCategory());
                this.types.add(newType);
                this.typesById.put(newType.getId(), newType);
                this.typesByName.put(newType.getName(), newType);
                this.stableTypeList.clear();
                baseTypes.add(newType);
            }
            ImmutableList.Builder typeMembers = ImmutableList.builder();
            for (RawTypeMember rawMember : rawMembers) {
                BaseType parentType = this.typesById.get(rawMember.getParentId());
                TypeMember newMember = null;
                if (rawMember.getOffset().isPresent()) {
                    newMember = TypeMember.createStructureMember(rawMember.getId(), parentType, this.typesById.get(rawMember.getBaseTypeId()), rawMember.getName(), rawMember.getOffset().get());
                } else if (rawMember.getArgumentIndex().isPresent()) {
                    newMember = TypeMember.createFunctionPrototypeMember(rawMember.getId(), parentType, this.typesById.get(rawMember.getBaseTypeId()), rawMember.getName(), rawMember.getArgumentIndex().get());
                } else if (rawMember.getNumberOfElements().isPresent()) {
                    newMember = TypeMember.createArrayMember(rawMember.getId(), parentType, this.typesById.get(rawMember.getBaseTypeId()), rawMember.getName(), rawMember.getNumberOfElements().get());
                } else {
                    throw new IllegalStateException("Error: can not associate the raw member to a compound type.");
                }
                typeMembers.add(newMember);
                this.memberById.put(newMember.getId(), newMember);
                newMember.getParentType().addMember(newMember);
            }
            for (RawBaseType rawType : rawBaseTypes) {
                Integer pointerId = rawType.getPointerId();
                if (pointerId == null) continue;
                BaseType child = this.typesById.get(pointerId);
                BaseType parent = this.typesById.get(rawType.getId());
                BaseType.appendToPointerHierarchy(child, parent);
            }
            return new TypeDependenceGraph(baseTypes.build(), typeMembers.build());
        }

        public boolean isTypeContainedIn(BaseType superType, BaseType baseType) {
            return this.dependenceGraph.isTypeContainedIn(superType, baseType);
        }

        public ImmutableSet<BaseType> updateBaseType(BaseType baseType, String newName, boolean signed, int size) {
            Preconditions.checkNotNull(baseType, "Error: baseType argument can not be null.");
            Preconditions.checkNotNull(newName, "Error: newName argument can not be null.");
            if (!baseType.getName().equals(newName)) {
                this.typesByName.remove(baseType.getName());
                this.typesByName.put(newName, baseType);
                baseType.setName(newName);
            }
            if (baseType.getCategory() == BaseTypeCategory.ATOMIC || baseType.getCategory() == BaseTypeCategory.POINTER && baseType.getBitSize() != size) {
                baseType.setSize(size);
            }
            baseType.setSigned(signed);
            return this.dependenceGraph.updateType(baseType);
        }

        public ImmutableSet<BaseType> updateTypeMember(TypeMember typeMember, BaseType newMemberBaseType, String newMemberName, Optional<Integer> newMemberOffset, Optional<Integer> newMemberNumberOfElements, Optional<Integer> newMemberArgumentIndex) {
            Preconditions.checkNotNull(typeMember, "Error: typeMember argument can not be null.");
            Preconditions.checkNotNull(newMemberName, "Error: memberName argument can not be null.");
            Preconditions.checkNotNull(newMemberBaseType, "Error: baseType argument can not be null.");
            Preconditions.checkNotNull(newMemberNumberOfElements, "Error: number of elements argument can not be null.");
            Preconditions.checkNotNull(newMemberOffset, "Error: offset argument can not be null.");
            Preconditions.checkNotNull(newMemberArgumentIndex, "Error: argument index argument can not be null.");
            Preconditions.checkNotNull(newMemberBaseType, "Error: basetype argument can not be null.");
            typeMember.setBaseType(newMemberBaseType);
            typeMember.setName(newMemberName);
            typeMember.setNumberOfElements(newMemberNumberOfElements);
            typeMember.setOffset(newMemberOffset);
            typeMember.setArgumentIndex(newMemberArgumentIndex);
            return this.dependenceGraph.updateMember(typeMember.getParentType(), typeMember.getBaseType(), newMemberBaseType).getAffectedTypes();
        }

        public void updateTypeSubstitution(TypeSubstitution typeSubstitution, BaseType baseType, List<TypeMember> memberPath, int offset) {
            Preconditions.checkNotNull(typeSubstitution, "Error: TypeSubstitution argument can not be null.");
            Preconditions.checkNotNull(baseType, "Error: BaseType argument can not be null.");
            Preconditions.checkNotNull(memberPath, "Error: Member path can not be null.");
            this.substitutionsByType.remove(typeSubstitution.getBaseType(), typeSubstitution);
            typeSubstitution.setBaseType(baseType);
            typeSubstitution.setOffset(offset);
            typeSubstitution.setMemberPath(memberPath);
            this.substitutionsByType.put((Object)baseType, (Object)typeSubstitution);
        }

        public boolean willTypeCreateCyclicReference(BaseType containingType, BaseType memberType) {
            return this.dependenceGraph.willCreateCycle(containingType, memberType);
        }
    }
}

