/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.SectionContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.ViewManager;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TypeInstanceContainerBackend {
    private final SQLProvider provider;
    private final INaviModule module;
    private final Map<Integer, TypeInstance> instancesById = Maps.newHashMap();
    private final TypeManager typeManager;
    private final SectionContainer sectionContainer;
    private final Map<InstanceReferenceLookup, TypeInstanceReference> referenceLookup = Maps.newHashMap();

    public TypeInstanceContainerBackend(SQLProvider provider, INaviModule module, TypeManager typeManager, SectionContainer sectionContainer) {
        this.provider = Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        this.module = Preconditions.checkNotNull(module, "Error: module argument can not be null");
        this.typeManager = Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        this.sectionContainer = Preconditions.checkNotNull(sectionContainer, "Error: sectionContainer argument can not be null");
    }

    public List<IComment> appendComment(TypeInstance instance, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(instance, "Error: instance can not be null.");
        Preconditions.checkNotNull(commentText, "Error: comment can not be null.");
        return CommentManager.get(this.provider).appendTypeInstanceComment(instance, commentText);
    }

    public TypeInstance createTypeInstance(String name, String commentString, BaseType baseType, Section section, long sectionOffset) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkNotNull(baseType, "Error: baseType argument can not be null");
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        Preconditions.checkArgument(sectionOffset >= 0L, "Error: section offset must be greater or equal to zero");
        CommentManager commentManager = CommentManager.get(this.provider);
        int typeId = baseType.getId();
        int sectionId = section.getId();
        int instanceId = this.provider.createTypeInstance(this.module.getConfiguration().getId(), name, null, typeId, sectionId, sectionOffset);
        TypeInstance instance = new TypeInstance(instanceId, name, baseType, section, sectionOffset, this.module);
        this.instancesById.put(instanceId, instance);
        if (commentString != null) {
            commentManager.appendTypeInstanceComment(instance, commentString);
        }
        return instance;
    }

    public TypeInstanceReference createTypeInstanceReference(IAddress address, int position, INaviOperandTreeNode node, TypeInstance instance, INaviView view) throws CouldntSaveDataException {
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkArgument(position >= 0, "Error: position argument must be greater or equal to zero");
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        Preconditions.checkNotNull(view, "Error: view argument can not be null");
        this.provider.createTypeInstanceReference(this.module.getConfiguration().getId(), address.toLong(), position, node.getId(), instance.getId());
        TypeInstanceReference reference = new TypeInstanceReference(address, position, Optional.of(node), instance, view);
        this.referenceLookup.put(new InstanceReferenceLookup(address, position, node.getId()), reference);
        return reference;
    }

    public void deleteComment(TypeInstance instance, IComment comment) throws CouldntDeleteException {
        CommentManager.get(this.provider).deleteTypeInstanceComment(instance, comment);
    }

    public void deleteInstance(TypeInstance instance) throws CouldntDeleteException {
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        Preconditions.checkArgument(this.instancesById.containsKey(instance.getId()), "Error: type instance id is not known to the backend");
        this.instancesById.remove(instance.getId());
        this.provider.deleteTypeInstance(instance.getModule().getConfiguration().getId(), instance.getId());
    }

    public void deleteInstanceInternal(TypeInstance backendInstance) {
        Preconditions.checkNotNull(backendInstance, "Error: backendInstance argument can not be null");
        this.instancesById.remove(backendInstance);
    }

    public void deleteInstanceReference(TypeInstanceReference reference) throws CouldntDeleteException {
        Preconditions.checkNotNull(reference, "Error: reference argument can not be null");
        if (!reference.getTreeNode().isPresent()) {
            throw new IllegalStateException("Error: reference must be associated to a node.");
        }
        this.provider.deleteTypeInstanceReference(reference.getTypeInstance().getModule().getConfiguration().getId(), reference.getAddress().toBigInteger(), reference.getPosition(), reference.getTreeNode().get().getId());
        this.referenceLookup.remove(new InstanceReferenceLookup(reference.getAddress(), reference.getPosition(), reference.getTreeNode().get().getId()));
    }

    public void deleteInstanceReferenceInternal(TypeInstanceReference reference) {
        Preconditions.checkNotNull(reference, "Error: reference argument can not be null");
        this.referenceLookup.remove(reference);
    }

    public IComment editComment(TypeInstance instance, IComment comment, String newCommentText) throws CouldntSaveDataException {
        return CommentManager.get(this.provider).editTypeInstanceComment(instance, comment, newCommentText);
    }

    public List<IComment> getComments(TypeInstance instance) {
        ArrayList comments = CommentManager.get(this.provider).getTypeInstanceComments(instance);
        return comments == null ? new ArrayList() : comments;
    }

    public void initializeTypeInstanceComment(TypeInstance instance, List<IComment> comments) {
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        Preconditions.checkNotNull(comments, "Error: comments argument can not be null");
        CommentManager.get(this.provider).initializeTypeInstanceComment(instance, comments);
    }

    public boolean isOwner(IComment comment) {
        return CUserManager.get(this.provider).getCurrentActiveUser().equals(comment.getUser());
    }

    public TypeInstance loadTypeInstance(Integer typeInstanceId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        RawTypeInstance rawTypeInstance = this.provider.loadTypeInstance(this.module, typeInstanceId);
        BaseType baseType = this.typeManager.getBaseType(rawTypeInstance.getTypeId());
        Section section = this.sectionContainer.getSection(rawTypeInstance.getSectionId());
        TypeInstance typeInstance = new TypeInstance(rawTypeInstance.getId(), rawTypeInstance.getName(), baseType, section, rawTypeInstance.getSectionOffset(), this.module);
        this.instancesById.put(typeInstance.getId(), typeInstance);
        if (rawTypeInstance.getCommentId() != null) {
            CommentManager manager = CommentManager.get(this.provider);
            ArrayList<IComment> comments = this.provider.loadCommentById(rawTypeInstance.getCommentId());
            manager.initializeTypeInstanceComment(typeInstance, comments);
        }
        return typeInstance;
    }

    public TypeInstanceReference loadTypeInstanceReference(Integer typeInstanceId, BigInteger address, Integer position, Integer expressionId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkNotNull(position, "Error: position argument can not be null");
        Preconditions.checkNotNull(expressionId, "Error: expressionId argument can not be null");
        RawTypeInstanceReference rawReference = this.provider.loadTypeInstanceReference(this.module, typeInstanceId, address, position, expressionId);
        TypeInstance typeInstance = this.instancesById.get(rawReference.getTypeInstanceId());
        INaviView view = this.module.getContent().getViewContainer().getView(rawReference.getViewId());
        TypeInstanceReference reference = new TypeInstanceReference(new CAddress(address), position, Optional.absent(), typeInstance, view);
        this.referenceLookup.put(new InstanceReferenceLookup(new CAddress(address), position, expressionId), reference);
        return reference;
    }

    public List<TypeInstanceReference> loadTypeInstanceReferences() throws CouldntLoadDataException {
        List<RawTypeInstanceReference> rawReferences = this.provider.loadTypeInstanceReferences(this.module);
        ArrayList<TypeInstanceReference> references = Lists.newArrayList();
        for (RawTypeInstanceReference rawReference : rawReferences) {
            TypeInstance typeInstance = this.instancesById.get(rawReference.getTypeInstanceId());
            INaviView view = ViewManager.get(this.provider).getView(rawReference.getViewId());
            if (view == null) continue;
            Optional<INaviOperandTreeNode> node = Optional.absent();
            IAddress address = rawReference.getAddress();
            int position = rawReference.getOperandPosition();
            int expressionId = rawReference.getExpressionId();
            TypeInstanceReference reference = new TypeInstanceReference(address, position, node, typeInstance, view);
            references.add(reference);
            this.referenceLookup.put(new InstanceReferenceLookup(address, position, expressionId), reference);
        }
        return references;
    }

    public Set<TypeInstance> loadTypeInstances() throws CouldntLoadDataException {
        List<RawTypeInstance> rawInstances = this.provider.loadTypeInstances(this.module);
        HashMap<TypeInstance, Integer> instanceToComment = Maps.newHashMap();
        for (RawTypeInstance rawInstance : rawInstances) {
            BaseType baseType = this.typeManager.getBaseType(rawInstance.getTypeId());
            Section section = this.sectionContainer.getSection(rawInstance.getSectionId());
            TypeInstance typeInstance = new TypeInstance(rawInstance.getId(), rawInstance.getName(), baseType, section, rawInstance.getSectionOffset(), this.module);
            instanceToComment.put(typeInstance, rawInstance.getCommentId());
            this.instancesById.put(typeInstance.getId(), typeInstance);
        }
        Map typeInstanceWithComment = Maps.filterValues(instanceToComment, new Predicate<Integer>(){

            @Override
            public boolean apply(Integer commentId) {
                return commentId != null;
            }
        });
        CommentManager manager = CommentManager.get(this.provider);
        HashMap<Integer, ArrayList<IComment>> typeInstanceTocomments = this.provider.loadMultipleCommentsById(typeInstanceWithComment.values());
        for (Map.Entry entry : typeInstanceWithComment.entrySet()) {
            manager.initializeTypeInstanceComment((TypeInstance)entry.getKey(), (List<IComment>)typeInstanceTocomments.get(entry.getValue()));
        }
        return instanceToComment.keySet();
    }

    public TypeInstanceReference lookupReference(IAddress address, int position, int expressionId) {
        return this.referenceLookup.get(new InstanceReferenceLookup(address, position, expressionId));
    }

    public TypeInstance lookupTypeInstance(Integer typeInstanceId) {
        return this.instancesById.get(typeInstanceId);
    }

    public void setInstanceName(TypeInstance instance, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkArgument(!name.isEmpty(), "Error: name argument can not be empty");
        this.provider.setTypeInstanceName(instance.getModule().getConfiguration().getId(), instance.getId(), name);
    }

    private class InstanceReferenceLookup {
        private final IAddress address;
        private final int operandPosition;
        private final int expressionId;

        public InstanceReferenceLookup(IAddress address, int operandPosition, int expressionId) {
            this.address = address;
            this.operandPosition = operandPosition;
            this.expressionId = expressionId;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof InstanceReferenceLookup)) {
                return false;
            }
            InstanceReferenceLookup other = (InstanceReferenceLookup)o2;
            return this.address.equals(other.address) && this.operandPosition == other.operandPosition && this.expressionId == other.expressionId;
        }

        public int hashCode() {
            return Objects.hash(this.address, this.operandPosition, this.expressionId);
        }
    }
}

