/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.math.BigInteger;
import java.util.Objects;

public class TypeInstanceAddress
implements Comparable<TypeInstanceAddress> {
    private final IAddress baseAddress;
    private final long offset;
    private final long virtualAddress;

    public TypeInstanceAddress(IAddress address, long offset) {
        this.baseAddress = Preconditions.checkNotNull(address);
        this.offset = offset;
        this.virtualAddress = address.toBigInteger().add(BigInteger.valueOf(offset)).longValue();
    }

    @Override
    public int compareTo(TypeInstanceAddress rhs) {
        int result = this.getBaseAddress().compareTo(rhs.getBaseAddress());
        if (result == 0) {
            return (int)(this.offset - rhs.getOffset());
        }
        return result;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof TypeInstanceAddress)) {
            return false;
        }
        TypeInstanceAddress instanceAddress = (TypeInstanceAddress)o2;
        return Objects.equals(this.offset, instanceAddress.offset) && Objects.equals(this.baseAddress, instanceAddress.baseAddress);
    }

    public IAddress getBaseAddress() {
        return this.baseAddress;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getVirtualAddress() {
        return this.virtualAddress;
    }

    public int hashCode() {
        return Objects.hash(this.baseAddress, this.offset);
    }
}

