/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceAddress;
import java.math.BigInteger;

public final class TypeInstance {
    private final int id;
    private String name;
    private final BaseType baseType;
    final Section section;
    private final INaviModule module;
    private final TypeInstanceAddress address;

    public TypeInstance(int id, String name, BaseType baseType, Section section, long sectionOffset, INaviModule module) {
        Preconditions.checkArgument(id >= 0, "Error: id argument must be greater or equal to zero");
        this.id = id;
        this.name = name;
        this.baseType = Preconditions.checkNotNull(baseType, "Error: baseType argument can not be null");
        this.section = Preconditions.checkNotNull(section, "Error: section argument can not be null");
        Preconditions.checkArgument(sectionOffset >= 0L, "Error: section offset must be greater or equal to zero and ");
        Preconditions.checkArgument(section.getStartAddress().toBigInteger().add(BigInteger.valueOf(sectionOffset)).compareTo(section.getEndAddress().toBigInteger()) <= 0, "Error: the offset of the type instance is not within section boundaries.");
        this.module = Preconditions.checkNotNull(module, "Error: module argument can not be null");
        this.address = new TypeInstanceAddress(section.getStartAddress(), sectionOffset);
    }

    void setName(String name) {
        this.name = Preconditions.checkNotNull(name, "Error: name argument can not be null");
    }

    public TypeInstanceAddress getAddress() {
        return this.address;
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public int getId() {
        return this.id;
    }

    public INaviModule getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public Section getSection() {
        return this.section;
    }
}

