/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.SectionContainerBackend;
import com.google.security.zynamics.binnavi.disassembly.types.SectionPermission;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SectionContainer {
    private final List<Section> sections;
    private final Map<Integer, Section> sectionsById = new HashMap<Integer, Section>();
    private final SectionContainerBackend backend;

    public SectionContainer(SectionContainerBackend backend) throws CouldntLoadDataException {
        this.backend = Preconditions.checkNotNull(backend, "Error: backend argument can not be null");
        this.sections = backend.loadSections();
        Collections.sort(this.sections, new SectionComparator());
        for (Section section : this.sections) {
            this.sectionsById.put(section.getId(), section);
        }
    }

    public synchronized Section createSection(String name, IAddress startAddress, IAddress endAddress, SectionPermission sectionPermission, byte[] data) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkNotNull(startAddress, "Error: startAddress argument can not be null");
        Preconditions.checkNotNull(endAddress, "Error: endAddress argument can not be null");
        Preconditions.checkNotNull(sectionPermission, "Error: sectionPermission argument can not be null");
        Section section = this.backend.createSection(name, startAddress, endAddress, sectionPermission, data);
        this.sections.add(section);
        this.sectionsById.put(section.getId(), section);
        return section;
    }

    public synchronized void deleteSection(Section section) throws CouldntLoadDataException {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        Preconditions.checkArgument(this.sections.contains(section), "Error: section is not known to the section container");
        this.backend.deleteSection(section);
        this.sections.remove(section);
        this.sectionsById.remove(section.getId());
    }

    public synchronized List<Section> findSections(final IAddress address) {
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Predicate<Section> predicate = new Predicate<Section>(){

            @Override
            public boolean apply(Section section) {
                return address.toBigInteger().compareTo(section.getStartAddress().toBigInteger()) >= 0 && address.toBigInteger().compareTo(section.getEndAddress().toBigInteger()) <= 0;
            }
        };
        return Lists.newArrayList(Collections2.filter(this.sections, predicate));
    }

    public synchronized Section getSection(int sectionId) {
        return this.sectionsById.get(sectionId);
    }

    public synchronized List<Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public synchronized Section renameSection(Section section, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        Preconditions.checkArgument(this.sections.contains(section), "Error: section is not known to the section container");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Section renamedSection = this.backend.renameSection(section, name);
        this.sections.set(this.sections.indexOf(section), renamedSection);
        this.sectionsById.put(renamedSection.getId(), renamedSection);
        return renamedSection;
    }

    private class SectionComparator
    implements Comparator<Section> {
        private SectionComparator() {
        }

        @Override
        public int compare(Section lhs, Section rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    }
}

