/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class RawTypeMember {
    private final int id;
    private final String name;
    private final int baseTypeId;
    private final Optional<Integer> numberOfElements;
    private final Integer parentId;
    private final Optional<Integer> offset;
    private final Optional<Integer> argument;

    public RawTypeMember(int id, String name, int baseTypeId, Integer parentId, Integer offset, Integer argument, Integer numberOfElements) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "Error: name can not be null");
        this.baseTypeId = baseTypeId;
        this.parentId = parentId;
        Preconditions.checkArgument(offset == null || offset >= 0, "Error: offset must be positive.");
        this.offset = Optional.fromNullable(offset);
        this.argument = Optional.fromNullable(argument);
        Preconditions.checkArgument(numberOfElements == null || numberOfElements >= 0, "Error: number of elements must be null or greater than zero.");
        Preconditions.checkArgument(!Objects.equals(numberOfElements, offset) ^ this.argument.isPresent(), "Error: Either this is a struct member or a array member, or a prototype argument.");
        this.numberOfElements = Optional.fromNullable(numberOfElements);
    }

    public Optional<Integer> getArgumentIndex() {
        return this.argument;
    }

    public int getBaseTypeId() {
        return this.baseTypeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getNumberOfElements() {
        return this.numberOfElements;
    }

    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public String toString() {
        return String.format("name=%s, id=%d, offset=%d, numberOfElements=%d, parentId=%d, baseTypeId=%d, argument=%d", this.name, this.id, this.offset, this.numberOfElements, this.parentId, this.baseTypeId, this.argument);
    }
}

