/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import java.util.Objects;

public final class RawBaseType {
    private final String name;
    private final int id;
    private final Integer pointerId;
    private final boolean isSigned;
    private final int size;
    private final BaseTypeCategory category;

    public RawBaseType(int id, String name, int size, Integer pointerId, boolean isSigned, BaseTypeCategory category) {
        this.id = id;
        this.name = Preconditions.checkNotNull(name, "Error: name can not be null.");
        this.size = size;
        this.pointerId = pointerId;
        this.isSigned = isSigned;
        this.category = category;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RawBaseType other = (RawBaseType)object;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.pointerId, other.pointerId) && Objects.equals(this.size, other.size) && Objects.equals(this.isSigned, other.isSigned) && Objects.equals((Object)this.category, (Object)other.category);
    }

    public BaseTypeCategory getCategory() {
        return this.category;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPointerId() {
        return this.pointerId;
    }

    public int getSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.pointerId, this.size, this.isSigned);
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String toString() {
        return this.name;
    }
}

