/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BaseTypeHelpers {
    private static String buildArrayName(BaseType arrayType, long l2) {
        StringBuilder builder = new StringBuilder(BaseType.normalizeArrayName(arrayType));
        builder.append('[');
        builder.append(l2);
        builder.append(']');
        return builder.toString();
    }

    private static String determineIndexedMemberString(TypeMember member, long offset) {
        return String.format("%s[%d]", member.getName(), offset / (long)BaseTypeHelpers.getArrayElementType(member.getBaseType()).getBitSize());
    }

    private static WalkResult findArrayMember(BaseType arrayType, long offset) {
        if (offset >= 0L && offset < (long)arrayType.getBitSize()) {
            return new WalkResult(arrayType.getLastMember(), Lists.newArrayList(arrayType.getLastMember()), BaseTypeHelpers.buildArrayName(arrayType, offset / (long)BaseTypeHelpers.getArrayElementType(arrayType).getBitSize()));
        }
        long byteOffset = offset < 0L ? (offset - 7L) / 8L : (offset + 7L) / 8L;
        String arrayString = offset < 0L ? String.format("%s%d", BaseTypeHelpers.buildArrayName(arrayType, 0L), byteOffset) : String.format("%s+%d", arrayType.getName(), byteOffset - (long)arrayType.getByteSize());
        return new WalkResult(arrayType.getLastMember(), Lists.newArrayList(arrayType.getLastMember()), arrayString);
    }

    private static WalkResult findStructMember(BaseType structBaseType, long offset) {
        StringBuilder pathString = new StringBuilder(structBaseType.getName());
        ArrayList<TypeMember> memberList = Lists.newArrayList();
        int memberOffset = 0;
        int currentOffset = 0;
        int lastMemberOffset = 0;
        Iterator<TypeMember> it = structBaseType.iterator();
        block5: while (it.hasNext()) {
            TypeMember member = it.next();
            memberOffset = member.getBitOffset().isPresent() ? member.getBitOffset().get() : 0;
            if ((long)(currentOffset += memberOffset - (lastMemberOffset = memberOffset)) > offset) continue;
            switch (member.getBaseType().getCategory()) {
                case ATOMIC: 
                case POINTER: {
                    if ((long)currentOffset != offset) continue block5;
                    pathString.append('.');
                    pathString.append(member.getName());
                    memberList.add(member);
                    return new WalkResult(member, memberList, pathString.toString());
                }
                case ARRAY: {
                    if (offset >= (long)(currentOffset + member.getBaseType().getBitSize()) || offset % (long)BaseTypeHelpers.getArrayElementType(member.getBaseType()).getBitSize() != 0L) continue block5;
                    pathString.append('.');
                    pathString.append(BaseTypeHelpers.determineIndexedMemberString(member, offset - (long)currentOffset));
                    memberList.add(member);
                    return new WalkResult(member, memberList, pathString.toString());
                }
                case STRUCT: 
                case UNION: {
                    if (offset >= (long)(currentOffset + member.getBaseType().getBitSize())) continue block5;
                    pathString.append('.');
                    pathString.append(member.getName());
                    memberList.add(member);
                    it = member.getBaseType().iterator();
                    lastMemberOffset = 0;
                    continue block5;
                }
            }
            return new WalkResult();
        }
        return new WalkResult();
    }

    public static WalkResult findMember(BaseType baseType, long offset) {
        Preconditions.checkNotNull(baseType, "IE02760: Base type can not be null.");
        switch (baseType.getCategory()) {
            case ATOMIC: 
            case POINTER: {
                return new WalkResult();
            }
            case ARRAY: {
                return BaseTypeHelpers.findArrayMember(baseType, offset);
            }
            case STRUCT: 
            case UNION: {
                return BaseTypeHelpers.findStructMember(baseType, offset);
            }
        }
        String string2 = String.valueOf((Object)baseType.getCategory());
        throw new IllegalStateException(new StringBuilder(39 + String.valueOf(string2).length()).append("Error: BaseTypeCategory ").append(string2).append(" not supported.").toString());
    }

    public static int getArrayElementByteSize(BaseType arrayType) {
        Preconditions.checkNotNull(arrayType, "Error: array type argument can not be null.");
        Preconditions.checkArgument(arrayType.getCategory() == BaseTypeCategory.ARRAY, "Error: arrayType argument not of type ARRAY.");
        return BaseTypeHelpers.getArrayElementType(arrayType).getByteSize();
    }

    private static BaseType getArrayElementType(BaseType arrayType) {
        return arrayType.iterator().next().getBaseType();
    }

    public static boolean isValidOffset(BaseType baseType, int offset) {
        Preconditions.checkNotNull(baseType, "Error: base type argument can not be null.");
        return offset < 0 ? false : BaseTypeHelpers.findMember(baseType, offset).isValid();
    }

    public static final class WalkResult {
        private final TypeMember member;
        private final List<TypeMember> path;
        private final String pathString;

        public WalkResult() {
            this.member = null;
            this.path = null;
            this.pathString = "";
        }

        public WalkResult(TypeMember member, List<TypeMember> path, String pathString) {
            this.member = member;
            this.path = path;
            this.pathString = pathString;
        }

        public boolean isValid() {
            return this.member != null && this.path != null;
        }

        public TypeMember getMember() {
            return this.member;
        }

        public String getPathString() {
            return this.pathString;
        }

        public List<TypeMember> getPath() {
            return this.path;
        }
    }
}

