/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.collect.ImmutableMap;

public enum BaseTypeCategory {
    ATOMIC("atomic"),
    ARRAY("array"),
    POINTER("pointer"),
    STRUCT("struct"),
    UNION("union"),
    FUNCTION_PROTOTYPE("function_pointer");

    private final String value;
    private static final ImmutableMap<String, BaseTypeCategory> lookup;

    private BaseTypeCategory(String value) {
        this.value = value;
    }

    private static ImmutableMap<String, BaseTypeCategory> createLookup() {
        ImmutableMap.Builder<String, BaseTypeCategory> builder = ImmutableMap.builder();
        for (BaseTypeCategory category : BaseTypeCategory.values()) {
            builder.put(category.value, category);
        }
        return builder.build();
    }

    public static BaseTypeCategory fromString(String value) {
        return lookup.get(value);
    }

    public static boolean isOffsetCategory(BaseTypeCategory category) {
        return category == STRUCT || category == UNION;
    }

    public String toString() {
        return this.value;
    }

    static {
        lookup = BaseTypeCategory.createLookup();
    }
}

