/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.types;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.MemberMoveResult;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class BaseType
implements Iterable<TypeMember> {
    private String name;
    private boolean signed;
    private BaseType pointsTo;
    private BaseType pointedToBy;
    private int bitSize;
    private final int id;
    private boolean isStackFrame;
    private final TreeSet<TypeMember> members = new TreeSet();
    private final BaseTypeCategory category;

    BaseType(int id, String name, int bitSize, boolean signed, BaseTypeCategory category) {
        Preconditions.checkArgument(id > 0, "Error: id must be greater than zero.");
        this.name = Preconditions.checkNotNull(name, "IE02757: Name of base type can not be null.");
        Preconditions.checkArgument(bitSize >= 0, "Error: Size of base must be above or equal to zero.");
        this.signed = signed;
        this.bitSize = bitSize;
        this.id = id;
        this.category = category;
    }

    private static int computerPointerLevel(BaseType startType) {
        int pointerLevel = 0;
        for (BaseType baseType = startType.pointsTo(); baseType != null; baseType = baseType.pointsTo()) {
            ++pointerLevel;
        }
        return pointerLevel;
    }

    private static int determineOccupiedSize(TreeSet<TypeMember> members) {
        TypeMember lastMember = members.last();
        return lastMember.getBitOffset().get() - members.first().getBitOffset().get() + lastMember.getBitSize();
    }

    private static List<TypeMember> getMembers(int startOffset, int endOffset, TreeSet<TypeMember> members) {
        ArrayList<TypeMember> result = Lists.newArrayList();
        for (TypeMember member : members) {
            if (member.getBitOffset().get() < startOffset || member.getBitOffset().get() >= endOffset) continue;
            result.add(member);
        }
        return result;
    }

    static void appendToPointerHierarchy(BaseType type, BaseType pointer) {
        Preconditions.checkNotNull(type, "Error: type argument can not be null.");
        Preconditions.checkNotNull(pointer, "Error: pointer argument can not be null.");
        Preconditions.checkArgument(type != pointer, "Error: Can not establish pointer relation between identical types.");
        Preconditions.checkArgument(pointer.pointedToBy != type, "Error: Can not establish circular pointer relation.");
        Preconditions.checkArgument(type.pointsTo != pointer, "Error: Can not establish circular pointer relation.");
        pointer.pointsTo = type;
        type.pointedToBy = pointer;
    }

    public static String getPointerTypeName(BaseType baseType, int pointerLevel) {
        Preconditions.checkNotNull(baseType, "Error: base type argument can not be null.");
        Preconditions.checkArgument(pointerLevel > 0, "Error: pointer level must be greater than zero.");
        return String.format("%s %s", BaseType.getValueTypeName(baseType), Strings.repeat("*", pointerLevel));
    }

    public static BaseType getValueType(BaseType baseType) {
        Preconditions.checkNotNull(baseType, "Error: base type argument can not be null.");
        while (baseType.pointsTo != null) {
            baseType = baseType.pointsTo;
        }
        return baseType;
    }

    public static String getValueTypeName(BaseType baseType) {
        Preconditions.checkNotNull(baseType, "Error: base type argument can not be null.");
        BaseType valueType = BaseType.getValueType(baseType);
        return valueType == null ? baseType.getName() : valueType.getName();
    }

    public static String normalizeArrayName(BaseType arrayType) {
        Preconditions.checkNotNull(arrayType, "Error: array type argument can not be null.");
        Preconditions.checkArgument(arrayType.getCategory() == BaseTypeCategory.ARRAY, "Error: array type argument must be of category array.");
        return arrayType.getName().split("\\[")[0];
    }

    private boolean areMembersConsecutive(TreeSet<TypeMember> members) {
        TypeMember lastMember = null;
        for (TypeMember member : members) {
            if (lastMember != null && member.getBitOffset().get() - lastMember.getBitOffset().get() != lastMember.getBitSize()) {
                return false;
            }
            lastMember = member;
        }
        return true;
    }

    void addMember(TypeMember member) {
        Preconditions.checkNotNull(member, "Error: member argument can not be null.");
        Preconditions.checkArgument(member.getParentType() == this, "Error: the member's parent type is not this type.");
        this.members.add(member);
    }

    void deleteMember(TypeMember member) {
        this.members.remove(Preconditions.checkNotNull(member, "Error: member argument can not be null."));
    }

    MemberMoveResult moveMembers(TreeSet<TypeMember> moveMembers, int moveDelta) {
        Preconditions.checkArgument(moveMembers.first().getBitOffset().get() + moveDelta >= 0, "Cannot move members to negative offset.");
        Preconditions.checkArgument(moveMembers.last().getBitOffset().get() + moveDelta <= this.members.last().getBitOffset().get() + this.members.last().getBitSize(), "Cannot move members behind last member.");
        Preconditions.checkArgument(this.areMembersConsecutive(moveMembers), "Cannot move members that are not consecutive to each other.");
        TypeMember firstMember = moveMembers.first();
        TypeMember lastMember = moveMembers.last();
        boolean moveTowardsBeginning = moveDelta < 0;
        int startOffset = moveTowardsBeginning ? firstMember.getBitOffset().get() + moveDelta : this.members.higher(lastMember).getBitOffset().get();
        int endOffset = moveTowardsBeginning ? firstMember.getBitOffset().get() : this.members.higher(lastMember).getBitOffset().get() + moveDelta;
        List<TypeMember> implicitlyMoved = BaseType.getMembers(startOffset, endOffset, this.members);
        int implicitMoveDelta = moveTowardsBeginning ? BaseType.determineOccupiedSize(moveMembers) : -BaseType.determineOccupiedSize(moveMembers);
        this.members.removeAll(moveMembers);
        this.members.removeAll(implicitlyMoved);
        for (TypeMember member : implicitlyMoved) {
            member.setOffset(Optional.of(member.getBitOffset().get() + implicitMoveDelta));
        }
        for (TypeMember member : moveMembers) {
            member.setOffset(Optional.of(member.getBitOffset().get() + moveDelta));
        }
        this.members.addAll(moveMembers);
        this.members.addAll(implicitlyMoved);
        return new MemberMoveResult(implicitlyMoved, implicitMoveDelta);
    }

    void setIsStackFrame(boolean isStackFrame) {
        this.isStackFrame = isStackFrame;
    }

    void setName(String name) {
        this.name = Preconditions.checkNotNull(name, "Error: name argument can not be null.");
    }

    void setSigned(boolean signed) {
        this.signed = signed;
    }

    void setSize(int bitSize) {
        Preconditions.checkArgument(bitSize >= 0, "Error: type size must be positive.");
        Preconditions.checkArgument(this.category == BaseTypeCategory.ATOMIC || this.category == BaseTypeCategory.POINTER, "Error: can not set size of non-atomic or non-pointer type.");
        this.bitSize = bitSize;
    }

    private int getArraySize() {
        TypeMember lastMember = this.members.last();
        return lastMember.getNumberOfElements().get() * lastMember.getBitSize();
    }

    private int getStructSize() {
        if (this.members.isEmpty()) {
            return 0;
        }
        TypeMember lastMember = this.members.last();
        return lastMember.getBitOffset().get() + lastMember.getBitSize();
    }

    private int getUnionSize() {
        int maxSize = 0;
        for (TypeMember member : this.members) {
            if (maxSize >= member.getBitSize()) continue;
            maxSize = member.getBitSize();
        }
        return maxSize;
    }

    public int getBitSize() {
        switch (this.category) {
            case ATOMIC: 
            case FUNCTION_PROTOTYPE: 
            case POINTER: {
                return this.bitSize;
            }
            case ARRAY: {
                return this.getArraySize();
            }
            case STRUCT: {
                return this.getStructSize();
            }
            case UNION: {
                return this.getUnionSize();
            }
        }
        throw new IllegalStateException("Error: can not infer size of type.");
    }

    public int getByteSize() {
        return (this.getBitSize() + 7) / 8;
    }

    public BaseTypeCategory getCategory() {
        return this.category;
    }

    public boolean isFunctionPrototype() {
        return this.category == BaseTypeCategory.FUNCTION_PROTOTYPE;
    }

    public int getId() {
        return this.id;
    }

    public TypeMember getLastMember() {
        return this.members.isEmpty() ? null : this.members.last();
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public String getName() {
        return this.name;
    }

    public int getPointerLevel() {
        return BaseType.computerPointerLevel(this);
    }

    public ImmutableList<TypeMember> getSubsequentMembersInclusive(int offset) {
        Preconditions.checkArgument(BaseTypeCategory.isOffsetCategory(this.category), "Error: Base type category does not have subsequent members.");
        Preconditions.checkArgument(offset >= 0, "Error: offset can not be negative.");
        if (this.members.isEmpty()) {
            return ImmutableList.of();
        }
        int searchOffset = offset > this.members.last().getBitOffset().get() && offset < this.getBitSize() ? this.members.last().getBitOffset().get() : offset;
        return ImmutableList.copyOf(this.members.tailSet(TypeMember.createSearchProxy(searchOffset), true));
    }

    public ImmutableList<TypeMember> getSubsequentMembers(TypeMember member) {
        Preconditions.checkArgument(BaseTypeCategory.isOffsetCategory(this.category), "Error: Base type category does not have subsequent members.");
        return ImmutableList.copyOf(this.members.tailSet(member, false));
    }

    public boolean hasMembers() {
        return this.members.size() > 0;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isStackFrame() {
        return this.isStackFrame;
    }

    @Override
    public Iterator<TypeMember> iterator() {
        return this.members.iterator();
    }

    public BaseType pointedToBy() {
        return this.pointedToBy;
    }

    public BaseType pointsTo() {
        return this.pointsTo;
    }

    public String toString() {
        return String.format("%s, bitSize=%d bits, %d members, id=%d", this.name, this.bitSize, this.members.size(), this.id);
    }
}

