/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.Modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.CCallgraph;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviModuleContent;
import com.google.security.zynamics.binnavi.disassembly.Modules.CFunctionContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.CTraceContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.CViewContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.binnavi.disassembly.types.SectionContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.List;

public final class CModuleContent
implements INaviModuleContent {
    private final CCallgraph m_callgraph;
    private final CTraceContainer m_traces;
    private final CFunctionContainer m_functions;
    private final CViewContainer m_viewContainer;
    private boolean m_closed = false;
    private final SectionContainer sections;
    private final TypeInstanceContainer instanceContainer;

    public CModuleContent(INaviModule module, SQLProvider provider, ListenerProvider<IModuleListener> listeners, CCallgraph callgraph, List<INaviFunction> functions, ICallgraphView nativeCallgraph, ImmutableList<IFlowgraphView> nativeFlowgraphs, List<INaviView> customViews, ImmutableBiMap<INaviView, INaviFunction> viewFunctionMap, List<TraceList> traces, SectionContainer sections, TypeInstanceContainer instanceContainer) {
        Preconditions.checkNotNull(module, "IE02176: Module argument can not be null");
        Preconditions.checkNotNull(provider, "IE02177: Provider argument can not be null");
        Preconditions.checkNotNull(listeners, "IE02178: Listeners argument can not be null");
        Preconditions.checkNotNull(callgraph, "IE02184: Call graph argument can not be null");
        Preconditions.checkNotNull(functions, "IE02185: Functions argument can not be null");
        Preconditions.checkNotNull(nativeCallgraph, "IE02204: Native Call graph argument can not be null");
        Preconditions.checkNotNull(nativeFlowgraphs, "IE02205: Native Flowgraphs argument can not be null");
        Preconditions.checkNotNull(customViews, "IE02206: Custom Views argument can not be null");
        Preconditions.checkNotNull(viewFunctionMap, "IE02207: View Function Map argument can not be null");
        Preconditions.checkNotNull(traces, "IE02208: Traces argument can not be null");
        this.sections = Preconditions.checkNotNull(sections);
        this.instanceContainer = Preconditions.checkNotNull(instanceContainer);
        this.m_traces = new CTraceContainer(module, traces, provider);
        this.m_viewContainer = new CViewContainer(module, nativeCallgraph, nativeFlowgraphs, customViews, viewFunctionMap, listeners, provider);
        this.m_callgraph = callgraph;
        this.m_functions = new CFunctionContainer(module, functions);
    }

    public boolean close() {
        Preconditions.checkState(!this.m_closed, "IE00203: Module content was closed before.");
        if (!this.m_functions.close()) {
            return false;
        }
        if (!this.m_viewContainer.close()) {
            return false;
        }
        this.m_closed = true;
        return true;
    }

    @Override
    public CFunctionContainer getFunctionContainer() {
        Preconditions.checkState(!this.m_closed, "IE00241: Module content was closed before.");
        return this.m_functions;
    }

    @Override
    public CCallgraph getNativeCallgraph() {
        Preconditions.checkState(!this.m_closed, "IE00261: Module content was closed before.");
        return this.m_callgraph;
    }

    @Override
    public SectionContainer getSections() {
        return this.sections;
    }

    @Override
    public CTraceContainer getTraceContainer() {
        Preconditions.checkState(!this.m_closed, "IE00262: Module content was closed before.");
        return this.m_traces;
    }

    @Override
    public TypeInstanceContainer getTypeInstanceContainer() {
        return this.instanceContainer;
    }

    @Override
    public CViewContainer getViewContainer() {
        Preconditions.checkState(!this.m_closed, "IE00263: Module content was closed before.");
        return this.m_viewContainer;
    }
}

