/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.Modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.ModuleTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.trace.ModuleTraceProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.CViewFilter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainerListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;

public final class CModuleContainer
implements IViewContainer {
    private final IDatabase m_database;
    private final INaviModule m_module;
    private final ITraceListProvider m_provider;
    private final ListenerProvider<IViewContainerListener> m_listeners = new ListenerProvider();
    private final InternalListener m_listener = new InternalListener();
    private final DebuggerProvider m_debuggerProvider;
    private IDebugger m_activeDebugger;

    public CModuleContainer(IDatabase database, INaviModule module) {
        this.m_database = Preconditions.checkNotNull(database, "IE02397: database argument can not be null");
        this.m_module = Preconditions.checkNotNull(module, "IE02398: module argument can not be null");
        this.m_debuggerProvider = new DebuggerProvider(new ModuleTargetSettings(this.m_module));
        IDebugger debugger = this.m_module.getConfiguration().getDebugger();
        if (debugger != null) {
            this.m_activeDebugger = debugger;
            this.m_debuggerProvider.addDebugger(debugger);
        }
        this.m_module.addListener(this.m_listener);
        this.m_provider = new ModuleTraceProvider(this.m_module);
    }

    @Override
    public Object getNative() {
        return this.m_module;
    }

    @Override
    public void addListener(IViewContainerListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public boolean containsModule(INaviModule module) {
        return module.equals(this.m_module);
    }

    @Override
    public INaviView createView(String name, String description) {
        return this.m_module.getContent().getViewContainer().createView(name, description);
    }

    @Override
    public void deleteView(INaviView view) throws CouldntDeleteException {
        this.m_module.getContent().getViewContainer().deleteView(view);
    }

    @Override
    public void dispose() {
        this.m_module.removeListener(this.m_listener);
    }

    @Override
    public List<INaviAddressSpace> getAddressSpaces() {
        return null;
    }

    @Override
    public IDatabase getDatabase() {
        return this.m_database;
    }

    @Override
    public DebuggerProvider getDebuggerProvider() {
        return this.m_debuggerProvider;
    }

    @Override
    public INaviFunction getFunction(INaviView view) {
        return this.m_module.getContent().getViewContainer().getFunction(view);
    }

    @Override
    public List<INaviFunction> getFunctions() {
        return this.m_module.getContent().getFunctionContainer().getFunctions();
    }

    @Override
    public List<INaviModule> getModules() {
        return Lists.newArrayList(this.m_module);
    }

    @Override
    public String getName() {
        return this.m_module.getConfiguration().getName();
    }

    @Override
    public List<Pair<INaviView, CTag>> getTaggedViews() {
        return CViewFilter.getTaggedViews(this.m_module.getContent().getViewContainer().getViews());
    }

    @Override
    public List<INaviView> getTaggedViews(CTag object) {
        return CViewFilter.getTaggedViews(this.m_module.getContent().getViewContainer().getViews(), object);
    }

    @Override
    public ITraceListProvider getTraceProvider() {
        return this.m_provider;
    }

    @Override
    public List<INaviView> getUserViews() {
        return this.m_module.getContent().getViewContainer().getUserViews();
    }

    @Override
    public INaviView getView(INaviFunction function) {
        for (INaviView view : this.m_module.getContent().getViewContainer().getViews()) {
            if (this.m_module.getContent().getViewContainer().getFunction(view) != function) continue;
            return view;
        }
        return null;
    }

    @Override
    public int getViewCount() {
        return this.m_module.getCustomViewCount();
    }

    @Override
    public List<INaviView> getViews() {
        return this.m_module.getContent().getViewContainer().getViews();
    }

    @Override
    public List<INaviView> getViewsWithAddresses(List<UnrelocatedAddress> address, boolean all) throws CouldntLoadDataException {
        return this.m_module.getViewsWithAddresses(address, all);
    }

    @Override
    public boolean isLoaded() {
        return this.m_module.isLoaded();
    }

    @Override
    public void removeListener(IViewContainerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class InternalListener
    extends CModuleListenerAdapter {
        private InternalListener() {
        }

        @Override
        public void addedView(INaviModule module, INaviView view) {
            for (IViewContainerListener listener : CModuleContainer.this.m_listeners) {
                try {
                    listener.addedView(CModuleContainer.this, view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDebugger(INaviModule module, IDebugger debugger) {
            if (CModuleContainer.this.m_activeDebugger != null) {
                CModuleContainer.this.m_debuggerProvider.removeDebugger(CModuleContainer.this.m_activeDebugger);
            }
            if (debugger != null) {
                CModuleContainer.this.m_activeDebugger = debugger;
                CModuleContainer.this.m_debuggerProvider.addDebugger(debugger);
            }
        }

        @Override
        public void closedModule(CModule module, ICallgraphView callgraphView, List<IFlowgraphView> flowgraphs) {
            ArrayList<INaviView> views = new ArrayList<INaviView>(flowgraphs);
            views.add((IFlowgraphView)((Object)callgraphView));
            for (IViewContainerListener listener : CModuleContainer.this.m_listeners) {
                try {
                    listener.closedContainer(CModuleContainer.this, views);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedView(INaviModule module, INaviView view) {
            for (IViewContainerListener listener : CModuleContainer.this.m_listeners) {
                try {
                    listener.deletedView(CModuleContainer.this, view);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void loadedModule(INaviModule module) {
            for (IViewContainerListener listener : CModuleContainer.this.m_listeners) {
                try {
                    listener.loaded(CModuleContainer.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

