/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.Modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.CCallgraph;
import com.google.security.zynamics.binnavi.disassembly.CInstruction;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.COperandTypeConverter;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleConfiguration;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContent;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleInitializeReporter;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleLoaderReporter;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.binnavi.disassembly.Modules.ModuleLoadEvents;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.types.SectionContainer;
import com.google.security.zynamics.binnavi.disassembly.types.SectionContainerBackend;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainerBackend;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManagerDatabaseBackend;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IReference;
import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CModule
implements INaviModule {
    private final SQLProvider m_provider;
    private volatile ListenerProvider<IModuleListener> m_listeners = new ListenerProvider();
    private final CModuleInitializeReporter m_reporter = new CModuleInitializeReporter(this.m_listeners);
    private boolean m_isLoading = false;
    private final CModuleLoaderReporter m_loadReporter = new CModuleLoaderReporter(this.m_listeners);
    private final int m_functionCount;
    private final int m_customViewCount;
    private byte[] m_data = new byte[0];
    private int m_initializationState;
    private final CModuleConfiguration m_configuration;
    private CModuleContent m_content;
    private Boolean m_isInitializing = false;
    private final Map<String, String> m_settings = new HashMap<String, String>();
    private TypeManager typeManager;

    public CModule(int moduleId, String name, String comment, Date creationDate, Date modificationDate, String md52, String sha1, int functionCount, int customViewCount, IAddress fileBase, IAddress imageBase, DebuggerTemplate debuggerTemplate, INaviRawModule rawModule, int initializationState, boolean isStared, SQLProvider provider) {
        Preconditions.checkArgument(moduleId > 0, "IE00135: Module ID must be larger than 0");
        Preconditions.checkNotNull(name, "IE00136: Module Name can not be null");
        Preconditions.checkNotNull(comment, "IE00137: Module Comment can not be null");
        Preconditions.checkNotNull(creationDate, "IE00139: Module Creation Date can not be null");
        Preconditions.checkNotNull(modificationDate, "IE00140: Module Modification Date can not be null");
        Preconditions.checkNotNull(md52, "IE00141: Module MD5 hash can not be null");
        Preconditions.checkArgument(Convert.isMD5String(md52), "IE00142: Invalid MD5 string");
        Preconditions.checkNotNull(sha1, "IE00143: Module SHA1 hash can not be null");
        Preconditions.checkArgument(Convert.isSha1String(sha1), "IE00144: Invalid SHA1 string");
        Preconditions.checkArgument(functionCount >= 0, "IE00145: Function count can not be negative");
        Preconditions.checkArgument(customViewCount >= 0, "IE00146: Custom View Count argument can not be null");
        Preconditions.checkNotNull(fileBase, "IE00147: File Base argument can not be null");
        Preconditions.checkNotNull(imageBase, "IE00148: Image Base argument can not be null");
        Preconditions.checkArgument(debuggerTemplate == null || debuggerTemplate.inSameDatabase(provider), "IE00149: Module is not in same database as debugger template argument");
        Preconditions.checkNotNull(provider, "IE00150: Invalid SQL provider");
        this.m_configuration = new CModuleConfiguration(this, provider, this.m_listeners, moduleId, name, comment, creationDate, modificationDate, md52, sha1, fileBase, imageBase, debuggerTemplate, isStared, rawModule);
        this.m_functionCount = functionCount;
        this.m_customViewCount = customViewCount;
        this.m_initializationState = initializationState;
        this.m_provider = provider;
    }

    @Override
    public synchronized void addListener(IModuleListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public boolean close() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE00156: Module is not loaded");
        }
        for (IModuleListener listener : this.m_listeners) {
            try {
                if (listener.closingModule(this)) continue;
                return false;
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        ICallgraphView oldNativeCallgraphView = this.m_content.getViewContainer().getNativeCallgraphView();
        ImmutableList<IFlowgraphView> oldFlowgraphs = this.m_content.getViewContainer().getNativeFlowgraphViews();
        if (!this.m_content.close()) {
            return false;
        }
        this.m_content = null;
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.closedModule(this, oldNativeCallgraphView, oldFlowgraphs);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return true;
    }

    @Override
    public INaviInstruction createInstruction(IAddress address, String mnemonic, List<COperandTree> operands, byte[] data, String architecture) {
        return new CInstruction(false, this, address, mnemonic, operands, data, architecture, this.m_provider);
    }

    @Override
    public COperandTree createOperand(COperandTreeNode node) {
        return new COperandTree(node, this.m_provider, this.getTypeManager(), this.m_content.getTypeInstanceContainer());
    }

    @Override
    public COperandTreeNode createOperandExpression(String value, ExpressionType type) {
        return new COperandTreeNode(-1, COperandTypeConverter.convert(type), value, null, new ArrayList<IReference>(), this.m_provider, this.getTypeManager(), this.m_content.getTypeInstanceContainer());
    }

    @Override
    public CModuleConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public CModuleContent getContent() {
        return Preconditions.checkNotNull(this.m_content, "IE00462: Module is not loaded");
    }

    @Override
    public int getCustomViewCount() {
        return this.isLoaded() ? this.m_content.getViewContainer().getCustomViewCount() : this.m_customViewCount;
    }

    @Override
    public byte[] getData() {
        return (byte[])this.m_data.clone();
    }

    @Override
    public int getFunctionCount() {
        return this.isLoaded() ? this.m_content.getFunctionContainer().getFunctionCount() : this.m_functionCount;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public List<INaviView> getUserViews() {
        return this.m_content.getViewContainer().getUserViews();
    }

    @Override
    public int getViewCount() {
        return 1 + this.getFunctionCount() + this.getCustomViewCount();
    }

    @Override
    public List<INaviView> getViewsWithAddresses(List<UnrelocatedAddress> address, boolean all) throws CouldntLoadDataException {
        return this.m_provider.getViewsWithAddresses(this, address, all);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws CouldntSaveDataException {
        Boolean bl2 = this.m_isInitializing;
        synchronized (bl2) {
            if (this.isInitialized()) {
                return;
            }
            this.m_isInitializing = true;
            try {
                this.m_provider.initializeModule(this, this.m_reporter);
            }
            finally {
                this.m_isInitializing = false;
            }
        }
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.initializedModule(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject object) {
        Preconditions.checkNotNull(object, "IE00193: Object argument can not be null");
        return object.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE00194: Provider argument can not be null");
        return provider.equals(this.m_provider);
    }

    @Override
    public boolean isInitialized() {
        return this.m_initializationState == Integer.MAX_VALUE;
    }

    @Override
    public boolean isInitializing() {
        return this.m_isInitializing;
    }

    @Override
    public boolean isLoaded() {
        return this.m_content != null;
    }

    @Override
    public boolean isLoading() {
        return this.m_isLoading;
    }

    @Override
    public boolean isStared() {
        return this.m_configuration.isStared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws CouldntLoadDataException, LoadCancelledException {
        CModuleLoaderReporter cModuleLoaderReporter = this.m_loadReporter;
        synchronized (cModuleLoaderReporter) {
            if (this.isLoaded()) {
                return;
            }
            if (!this.isInitialized()) {
                throw new IllegalStateException("IE02617: The module is not initialized yet");
            }
            this.m_isLoading = true;
            try {
                ImmutableList<IFlowgraphView> nativeFlowgraphs;
                if (!this.m_loadReporter.report(ModuleLoadEvents.Starting)) {
                    throw new LoadCancelledException();
                }
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingCallgraphView)) {
                    throw new LoadCancelledException();
                }
                ICallgraphView nativeCallgraph = this.m_provider.loadNativeCallgraph(this);
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingFlowgraphs)) {
                    throw new LoadCancelledException();
                }
                ImmutableList<IFlowgraphView> immutableList = nativeFlowgraphs = nativeCallgraph.getNodeCount() == 0 ? new ImmutableList.Builder().build() : this.m_provider.loadNativeFlowgraphs(this);
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingCallgraphViews)) {
                    throw new LoadCancelledException();
                }
                List<ICallgraphView> userCallgraphs = this.m_provider.loadCallgraphViews(this);
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingFlowgraphViews)) {
                    throw new LoadCancelledException();
                }
                ImmutableList<IFlowgraphView> userFlowgraphs = this.m_provider.loadFlowgraphs(this);
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingMixedViews)) {
                    throw new LoadCancelledException();
                }
                List<INaviView> userMixedGraphs = this.m_provider.loadMixedgraphs(this);
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingCallgraph)) {
                    throw new LoadCancelledException();
                }
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingFunctions)) {
                    throw new LoadCancelledException();
                }
                this.typeManager = new TypeManager(new TypeManagerDatabaseBackend(this.m_provider, this));
                List<INaviFunction> functions = this.m_provider.loadFunctions(this, nativeFlowgraphs);
                ImmutableBiMap<INaviView, INaviFunction> viewFunctionMap = this.m_provider.loadViewFunctionMapping(nativeFlowgraphs, functions, this);
                CCallgraph callgraph = this.m_provider.loadCallgraph(this, nativeCallgraph.getConfiguration().getId(), functions);
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingTraces)) {
                    throw new LoadCancelledException();
                }
                List<TraceList> traces = this.m_provider.loadTraces(this);
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingGlobalVariables)) {
                    throw new LoadCancelledException();
                }
                ArrayList<INaviView> customViews = new ArrayList<INaviView>();
                customViews.addAll(userCallgraphs);
                customViews.addAll(userFlowgraphs);
                customViews.addAll(userMixedGraphs);
                ArrayList<IFlowgraphView> currentViews = new ArrayList<IFlowgraphView>(nativeFlowgraphs);
                currentViews.addAll(customViews);
                Collections.sort(currentViews, new Comparator<INaviView>(){

                    @Override
                    public int compare(INaviView lhs, INaviView rhs) {
                        return lhs.getConfiguration().getId() - rhs.getConfiguration().getId();
                    }
                });
                HashMap<Integer, Integer> viewIdToIndex = new HashMap<Integer, Integer>();
                for (int i2 = 0; i2 < currentViews.size(); ++i2) {
                    viewIdToIndex.put(((INaviView)currentViews.get(i2)).getConfiguration().getId(), i2);
                }
                if (!this.m_loadReporter.report(ModuleLoadEvents.LoadingTypes)) {
                    throw new LoadCancelledException();
                }
                SectionContainer sections = new SectionContainer(new SectionContainerBackend(this.m_provider, this));
                TypeInstanceContainer typeInstances = new TypeInstanceContainer(new TypeInstanceContainerBackend(this.m_provider, this, this.typeManager, sections), this.m_provider);
                this.m_content = new CModuleContent(this, this.m_provider, this.m_listeners, callgraph, functions, nativeCallgraph, nativeFlowgraphs, customViews, viewFunctionMap, traces, sections, typeInstances);
                typeInstances.initialize();
            }
            catch (CouldntLoadDataException e2) {
                this.m_isLoading = false;
                throw e2;
            }
            catch (LoadCancelledException e3) {
                this.m_isLoading = false;
                throw e3;
            }
            finally {
                this.m_loadReporter.report(ModuleLoadEvents.Finished);
            }
            for (IModuleListener listener : this.m_listeners) {
                try {
                    listener.loadedModule(this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            this.m_isLoading = false;
        }
    }

    @Override
    public void loadData() throws CouldntLoadDataException {
        this.setData(this.m_provider.loadData(this));
    }

    @Override
    public String readSetting(String key) throws CouldntLoadDataException {
        if (this.m_settings.containsKey(key)) {
            return this.m_settings.get(key);
        }
        return this.m_provider.readSetting(this, key);
    }

    @Override
    public void removeListener(IModuleListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void saveData() throws CouldntSaveDataException {
        this.m_provider.saveData(this, this.m_data);
    }

    @Override
    public void setData(byte[] data) {
        Preconditions.checkNotNull(data, "IE00198: Data argument can not be null");
        this.m_data = (byte[])data.clone();
        for (IModuleListener listener : this.m_listeners) {
            try {
                listener.changedData(this, data);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void setInitialized() {
        this.m_initializationState = Integer.MAX_VALUE;
    }

    public String toString() {
        return String.format("BinNavi Module %d: %s", this.getConfiguration().getId(), this.getConfiguration().getName());
    }

    @Override
    public void writeSetting(String key, String value) throws CouldntSaveDataException {
        this.m_settings.put(key, value);
        this.m_provider.writeSetting(this, key, value);
    }
}

