/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUser;
import com.google.security.zynamics.binnavi.disassembly.CommentListener;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CommentManager {
    private static Map<SQLProvider, CommentManager> managers = new HashMap<SQLProvider, CommentManager>();
    private final Map<Integer, IComment> commentIdToComment = new HashMap<Integer, IComment>();
    private final ListenerProvider<CommentListener> listeners = new ListenerProvider();
    private final CommentContainer<INaviInstruction, IComment> globalInstructionsCommentContainer = new CommentContainer();
    private final CommentContainer<Pair<INaviCodeNode, INaviInstruction>, IComment> localInstructionCommentContainer = new CommentContainer();
    private final CommentContainer<TypeInstance, IComment> typeInstanceCommentContainer = new CommentContainer();
    private final CommentContainer<Section, IComment> sectionCommentContainer = new CommentContainer();
    private final CommentContainer<INaviFunction, IComment> functionCommentContainer = new CommentContainer();
    private final CommentContainer<INaviEdge, IComment> globalEdgeCommentContainer = new CommentContainer();
    private final CommentContainer<INaviCodeNode, IComment> globalCodeNodeCommentContainer = new CommentContainer();
    private final CommentContainer<INaviEdge, IComment> localEdgeCommentContainer = new CommentContainer();
    private final CommentContainer<INaviCodeNode, IComment> localCodeNodeCommentContainer = new CommentContainer();
    private final CommentContainer<INaviFunctionNode, IComment> functionNodeCommentContainer = new CommentContainer();
    private final CommentContainer<INaviTextNode, IComment> textNodeCommentContainer = new CommentContainer();
    private final CommentContainer<INaviGroupNode, IComment> groupNodeCommentContainer = new CommentContainer();
    private final SQLProvider provider;
    private final SQLProviderListener providerListener = new InternalSQLProviderListener();

    private CommentManager(SQLProvider sqlProvider) {
        this.provider = Preconditions.checkNotNull(sqlProvider, "IE00089: Provider argument can not be null");
        this.provider.addListener(this.providerListener);
    }

    public static synchronized CommentManager get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE01239: Provider argument can not be null");
        if (!managers.containsKey(provider)) {
            managers.put(provider, new CommentManager(provider));
        }
        return managers.get(provider);
    }

    private void close() {
        managers.remove(this.provider);
        this.provider.removeListener(this.providerListener);
    }

    private synchronized void appendComment(CommentingStrategy strategy, Integer commentId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(strategy, "IE02539: strategy argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02540: commentId argument can not be null");
        ArrayList<IComment> currentDataBaseComments = this.provider.loadCommentById(commentId);
        strategy.saveComments(currentDataBaseComments);
        for (IComment comment : currentDataBaseComments) {
            this.commentIdToComment.put(comment.getId(), comment);
        }
        IComment notificationComment = null;
        for (IComment comment : currentDataBaseComments) {
            if (!comment.getId().equals(commentId)) continue;
            notificationComment = comment;
        }
        if (notificationComment != null) {
            for (CommentListener listener : this.listeners) {
                try {
                    strategy.sendAppendedCommentNotifcation(listener, notificationComment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    private synchronized List<IComment> appendComment(CommentingStrategy strategy, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        IUser user2 = CUserManager.get(this.provider).getCurrentActiveUser();
        ArrayList<IComment> currentComments = new ArrayList<IComment>();
        if (strategy.isStored()) {
            currentComments.addAll(strategy.appendComment(commentText, user2.getUserId()));
        } else {
            currentComments.addAll(strategy.getComments() == null ? new ArrayList() : Lists.newArrayList(strategy.getComments()));
            IComment parent = currentComments.isEmpty() ? null : Iterables.getLast(currentComments);
            CComment newComment = new CComment(null, user2, parent, commentText);
            currentComments.add(newComment);
        }
        strategy.saveComments(currentComments);
        for (IComment comment : currentComments) {
            this.commentIdToComment.put(comment.getId(), comment);
        }
        for (CommentListener listener : this.listeners) {
            try {
                strategy.sendAppendedCommentNotifcation(listener, Iterables.getLast(currentComments));
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return currentComments;
    }

    private synchronized void deleteComment(CommentingStrategy strategy, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(comment, "IE02541: comment argument can not be null");
        Preconditions.checkArgument(CUserManager.get(this.provider).isOwner(comment), "Error: a comment can be deleted only by its owner.");
        List<IComment> currentComments = strategy.getComments();
        if (!currentComments.remove(comment)) {
            return;
        }
        strategy.deleteComment(comment.getId(), comment.getUser().getUserId());
        strategy.saveComments(currentComments);
        this.commentIdToComment.remove(comment.getId());
        for (CommentListener listener : this.listeners) {
            try {
                strategy.sendDeletedCommentNotification(listener, comment);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private synchronized void deleteCommentInternal(CommentingStrategy strategy, IComment comment) {
        Preconditions.checkNotNull(comment, "IE02542: comment argument can not be null");
        List<IComment> currentComments = strategy.getComments();
        if (!currentComments.remove(comment)) {
            return;
        }
        strategy.saveComments(currentComments);
        this.commentIdToComment.remove(comment.getId());
        for (CommentListener listener : this.listeners) {
            try {
                strategy.sendDeletedCommentNotification(listener, comment);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private synchronized IComment editComment(CommentingStrategy strategy, IComment editedComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(editedComment, "IE02543: comment argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02544: commentText argument can not be null");
        Preconditions.checkArgument(CUserManager.get(this.provider).isOwner(editedComment), "Error: a comment can only be edited by its owner.");
        List<IComment> currentComments = strategy.getComments();
        if (editedComment.getComment().equals(commentText)) {
            return editedComment;
        }
        int index = currentComments.indexOf(editedComment);
        if (index == -1) {
            throw new IllegalArgumentException("Error: Can not edit comment as there is no comment to edit.");
        }
        CComment newComment = new CComment(editedComment.getId(), editedComment.getUser(), editedComment.getParent(), commentText);
        strategy.editComment(newComment.getId(), newComment.getUser().getUserId(), commentText);
        currentComments.set(index, newComment);
        strategy.saveComments(currentComments);
        this.commentIdToComment.put(editedComment.getId(), newComment);
        for (CommentListener listener : this.listeners) {
            try {
                strategy.sendEditedCommentNotification(listener, newComment);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return newComment;
    }

    private synchronized void editCommentInternal(CommentingStrategy strategy, IComment editedComment, IComment newComment) {
        Preconditions.checkNotNull(strategy, "IE02545: strategy argument can not be null");
        Preconditions.checkNotNull(editedComment, "IE02546: comment argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02547: commentText argument can not be null");
        List<IComment> currentComments = strategy.getComments();
        if (editedComment.getComment().equals(newComment)) {
            return;
        }
        int index = currentComments.indexOf(editedComment);
        if (index == -1) {
            throw new IllegalArgumentException("Error: Can not edit comment as there is no comment to edit.");
        }
        currentComments.set(index, newComment);
        strategy.saveComments(currentComments);
        this.commentIdToComment.put(editedComment.getId(), newComment);
        for (CommentListener listener : this.listeners) {
            try {
                strategy.sendEditedCommentNotification(listener, newComment);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private synchronized void initializeComment(CommentingStrategy strategy, List<IComment> comments) {
        Preconditions.checkNotNull(strategy, "IE02548: strategy argument can not be null");
        if (comments == null) {
            return;
        }
        strategy.saveComments(comments);
        for (IComment comment : comments) {
            this.commentIdToComment.put(comment.getId(), comment);
        }
        for (CommentListener listener : this.listeners) {
            try {
                strategy.sendInitializedCommentNotification(listener, comments);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private synchronized void unloadComment(CommentingStrategy strategy, List<IComment> comments) {
        Preconditions.checkNotNull(strategy, "Error: strategy argument can not be null");
        if (comments == null) {
            return;
        }
        strategy.removeComments(comments);
        for (IComment comment : comments) {
            this.commentIdToComment.remove(comment.getId());
        }
    }

    public synchronized void addListener(CommentListener listener) {
        this.listeners.addListener(listener);
    }

    public synchronized void appendCodeNodeComment(INaviCodeNode node, Integer commentId, CommentScope scope) throws CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE02549: node argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02550: commentId argument can not be null");
        Preconditions.checkNotNull(scope, "IE02551: scope argument can not be null");
        this.appendComment((CommentingStrategy)new CodeNodeCommentingStrategy(node, scope), commentId);
    }

    public synchronized void appendEdgeComment(INaviEdge edge, Integer commentId, CommentScope scope) throws CouldntLoadDataException {
        Preconditions.checkNotNull(edge, "IE02552: edge argument can not be null");
        this.appendComment((CommentingStrategy)new EdgeCommentingStrategy(edge, scope), commentId);
    }

    public synchronized void appendFunctionComment(INaviFunction function, Integer commentId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(function, "IE02553: function argument can not be null");
        this.appendComment((CommentingStrategy)new FunctionCommentingStrategy(function), commentId);
    }

    public synchronized void appendFunctionNodeComment(INaviFunctionNode node, Integer commentId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE02554: node argument can not be null");
        this.appendComment((CommentingStrategy)new FunctionNodeCommentingStrategy(node), commentId);
    }

    public synchronized List<IComment> appendFunctionNodeComment(INaviFunctionNode node, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE01242: FunctionNode argument can not be null");
        return this.appendComment((CommentingStrategy)new FunctionNodeCommentingStrategy(node), comment);
    }

    public synchronized List<IComment> appendGlobalCodeNodeComment(INaviCodeNode node, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE02555: codeNode argument can not be null");
        return this.appendComment((CommentingStrategy)new CodeNodeCommentingStrategy(node, CommentScope.GLOBAL), comment);
    }

    public synchronized List<IComment> appendGlobalEdgeComment(INaviEdge edge, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(edge, "IE01244: Edge argument can not be null");
        return this.appendComment((CommentingStrategy)new EdgeCommentingStrategy(edge, CommentScope.GLOBAL), commentText);
    }

    public synchronized List<IComment> appendGlobalFunctionComment(INaviFunction function, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(function, "IE01242: Function argument can not be null");
        return this.appendComment((CommentingStrategy)new FunctionCommentingStrategy(function), commentText);
    }

    public synchronized List<IComment> appendGlobalInstructionComment(INaviInstruction instruction, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(instruction, "IE01246: Instruction argument can not be null");
        return this.appendComment((CommentingStrategy)new InstructionCommentingStrategy(instruction, null, CommentScope.GLOBAL), commentText);
    }

    public synchronized void appendGroupNodeComment(INaviGroupNode node, Integer commentId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE02556: node argument can not be null");
        this.appendComment((CommentingStrategy)new GroupNodeCommentingStrategy(node), commentId);
    }

    public synchronized List<IComment> appendGroupNodeComment(INaviGroupNode node, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE01242: Text node argument can not be null");
        return this.appendComment((CommentingStrategy)new GroupNodeCommentingStrategy(node), comment);
    }

    public synchronized void appendInstructionComment(INaviInstruction instruction, INaviCodeNode node, CommentScope scope, Integer commentId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(instruction, "IE02557: instruction argument can not be null");
        this.appendComment((CommentingStrategy)new InstructionCommentingStrategy(instruction, node, scope), commentId);
    }

    public synchronized List<IComment> appendLocalCodeNodeComment(INaviCodeNode node, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE02558: group node argument can not be null");
        return this.appendComment((CommentingStrategy)new CodeNodeCommentingStrategy(node, CommentScope.LOCAL), comment);
    }

    public synchronized List<IComment> appendLocalEdgeComment(INaviEdge edge, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(edge, "IE02559: edge argument can not be null");
        return this.appendComment((CommentingStrategy)new EdgeCommentingStrategy(edge, CommentScope.LOCAL), comment);
    }

    public synchronized List<IComment> appendLocalInstructionComment(INaviInstruction instruction, INaviCodeNode node, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(instruction, "IE01246: Instruction argument can not be null");
        Preconditions.checkNotNull(node, "IE02560: node argument can not be null");
        Preconditions.checkArgument(Iterables.contains(node.getInstructions(), instruction), "Error: instruction does not belong to the specified node");
        return this.appendComment((CommentingStrategy)new InstructionCommentingStrategy(instruction, node, CommentScope.LOCAL), commentText);
    }

    public synchronized void appendTextNodeComment(INaviTextNode node, Integer commentId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE02561: node argument can not be null");
        this.appendComment((CommentingStrategy)new TextNodeCommentingStrategy(node), commentId);
    }

    public synchronized List<IComment> appendTextNodeComment(INaviTextNode node, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(node, "IE01242: Text node argument can not be null");
        return this.appendComment((CommentingStrategy)new TextNodeCommentingStrategy(node), comment);
    }

    public synchronized List<IComment> appendTypeInstanceComment(TypeInstance instance, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        return this.appendComment((CommentingStrategy)new TypeInstanceCommentingStrategy(instance), comment);
    }

    public synchronized void appendTypeInstanceComment(TypeInstance instance, Integer commentId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(instance, "Error: instance argument can not be null");
        this.appendComment((CommentingStrategy)new TypeInstanceCommentingStrategy(instance), commentId);
    }

    public synchronized List<IComment> appendSectionComment(Section section, String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        return this.appendComment((CommentingStrategy)new SectionCommentingStrategy(section), comment);
    }

    public synchronized void deleteCodeNodeComment(INaviCodeNode node, IComment comment, CommentScope scope) {
        Preconditions.checkNotNull(node, "IE02562: node argument can not be null");
        this.deleteCommentInternal(new CodeNodeCommentingStrategy(node, scope), comment);
    }

    public synchronized void deleteEdgeComment(INaviEdge edge, IComment comment, CommentScope scope) {
        Preconditions.checkNotNull(edge, "IE02563: edge argument can not be null");
        this.deleteCommentInternal(new EdgeCommentingStrategy(edge, scope), comment);
    }

    public synchronized void deleteFunctionCommentInternal(INaviFunction function, IComment comment) {
        Preconditions.checkNotNull(function, "IE02564: function argument can not be null");
        this.deleteCommentInternal(new FunctionCommentingStrategy(function), comment);
    }

    public synchronized void deleteFunctionNodeComment(INaviFunctionNode node, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(node, "IE02565: functionNode argument can not be null");
        this.deleteComment(new FunctionNodeCommentingStrategy(node), comment);
    }

    public synchronized void deleteFunctionNodeCommentInternal(INaviFunctionNode node, IComment comment) {
        Preconditions.checkNotNull(node, "IE02566: node argument can not be null");
        this.deleteCommentInternal(new FunctionNodeCommentingStrategy(node), comment);
    }

    public synchronized void deleteGlobalCodeNodeComment(INaviCodeNode node, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(node, "IE02567: codeNode argument can not be null");
        this.deleteComment(new CodeNodeCommentingStrategy(node, CommentScope.GLOBAL), comment);
    }

    public synchronized void deleteGlobalEdgeComment(INaviEdge edge, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(edge, "IE02568: edge argument can not be null");
        this.deleteComment(new EdgeCommentingStrategy(edge, CommentScope.GLOBAL), comment);
    }

    public synchronized void deleteGlobalFunctionComment(INaviFunction function, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(function, "IE02569: function argument can not be null");
        this.deleteComment(new FunctionCommentingStrategy(function), comment);
    }

    public synchronized void deleteGlobalInstructionComment(INaviInstruction instruction, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(instruction, "IE02570: instruction argument can not be null");
        this.deleteComment(new InstructionCommentingStrategy(instruction, null, CommentScope.GLOBAL), comment);
    }

    public synchronized void deleteGroupNodeComment(INaviGroupNode node, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(node, "IE02571: functionNode argument can not be null");
        this.deleteComment(new GroupNodeCommentingStrategy(node), comment);
    }

    public synchronized void deleteGroupNodeCommentInternal(INaviGroupNode node, IComment comment) {
        Preconditions.checkNotNull(node, "IE02572: node argument can not be null");
        this.deleteCommentInternal(new GroupNodeCommentingStrategy(node), comment);
    }

    public synchronized void deleteInstructionComment(INaviInstruction instruction, INaviCodeNode node, CommentScope scope, IComment comment) {
        Preconditions.checkNotNull(instruction, "IE02573: instruction argument can not be null");
        this.deleteCommentInternal(new InstructionCommentingStrategy(instruction, node, scope), comment);
    }

    public synchronized void deleteLocalCodeNodeComment(INaviCodeNode node, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(node, "IE02574: codeNode argument can not be null");
        this.deleteComment(new CodeNodeCommentingStrategy(node, CommentScope.LOCAL), comment);
    }

    public synchronized void deleteLocalEdgeComment(INaviEdge edge, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(edge, "IE02575: edge argument can not be null");
        this.deleteComment(new EdgeCommentingStrategy(edge, CommentScope.LOCAL), comment);
    }

    public synchronized void deleteLocalInstructionComment(INaviInstruction instruction, INaviCodeNode node, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(instruction, "IE02576: instruction argument can not be null");
        this.deleteComment(new InstructionCommentingStrategy(instruction, node, CommentScope.LOCAL), comment);
    }

    public synchronized void deleteTextNodeComment(INaviTextNode node, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(node, "IE02577: textnode argument can not be null");
        this.deleteComment(new TextNodeCommentingStrategy(node), comment);
    }

    public synchronized void deleteTextNodeCommentInternal(INaviTextNode node, IComment comment) {
        Preconditions.checkNotNull(node, "IE02578: node argument can not be null");
        this.deleteCommentInternal(new TextNodeCommentingStrategy(node), comment);
    }

    public synchronized void deleteTypeInstanceComment(TypeInstance typeInstance, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(typeInstance, "Error: type instance can not be null");
        this.deleteComment(new TypeInstanceCommentingStrategy(typeInstance), comment);
    }

    public synchronized void deleteTypeInstanceCommentInternal(TypeInstance typeInstance, IComment comment) {
        Preconditions.checkNotNull(typeInstance, "Error: typeInstance argument can not be null");
        this.deleteCommentInternal(new TypeInstanceCommentingStrategy(typeInstance), comment);
    }

    public synchronized void deleteSectionComment(Section section, IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        this.deleteComment(new SectionCommentingStrategy(section), comment);
    }

    public synchronized void editCodeNodeComment(INaviCodeNode node, IComment comment, IComment newComment, CommentScope scope) {
        Preconditions.checkNotNull(node, "IE02579: node argument can not be null");
        this.editCommentInternal(new CodeNodeCommentingStrategy(node, scope), comment, newComment);
    }

    public synchronized void editEdgeComment(INaviEdge edge, IComment comment, IComment newComment, CommentScope scope) {
        Preconditions.checkNotNull(edge, "IE02580: edge argument can not be null");
        this.editCommentInternal(new EdgeCommentingStrategy(edge, scope), comment, newComment);
    }

    public synchronized void editFunctionComment(INaviFunction function, IComment comment, IComment newComment, CommentScope scope) {
        Preconditions.checkNotNull(function, "IE02581: function argument can not be null");
        this.editCommentInternal(new FunctionCommentingStrategy(function), comment, newComment);
    }

    public synchronized void editFunctionNodeComment(INaviFunctionNode node, IComment comment, IComment newComment, CommentScope scope) {
        Preconditions.checkNotNull(node, "IE02582: node argument can not be null");
        this.editCommentInternal(new FunctionNodeCommentingStrategy(node), comment, newComment);
    }

    public synchronized IComment editFunctionNodeComment(INaviFunctionNode functionNode, IComment oldComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(functionNode, "IE02583: function argument can not be null");
        return this.editComment(new FunctionNodeCommentingStrategy(functionNode), oldComment, commentText);
    }

    public synchronized IComment editGlobalCodeNodeComment(INaviCodeNode codeNode, IComment editedComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(codeNode, "IE02584: codeNode argument can not be null");
        return this.editComment(new CodeNodeCommentingStrategy(codeNode, CommentScope.GLOBAL), editedComment, commentText);
    }

    public synchronized IComment editGlobalEdgeComment(INaviEdge edge, IComment editedComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(edge, "IE02585: edge argument can not be null");
        return this.editComment(new EdgeCommentingStrategy(edge, CommentScope.GLOBAL), editedComment, commentText);
    }

    public synchronized IComment editGlobalFunctionComment(INaviFunction function, IComment oldComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(function, "IE02586: function argument can not be null");
        return this.editComment(new FunctionCommentingStrategy(function), oldComment, commentText);
    }

    public synchronized IComment editGlobalInstructionComment(INaviInstruction instruction, IComment oldComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(instruction, "IE02587: instruction argument can not be null");
        return this.editComment(new InstructionCommentingStrategy(instruction, null, CommentScope.GLOBAL), oldComment, commentText);
    }

    public synchronized void editGroupNodeComment(INaviGroupNode node, IComment comment, IComment newComment, CommentScope scope) {
        Preconditions.checkNotNull(node, "IE02588: node argument can not be null");
        this.editCommentInternal(new GroupNodeCommentingStrategy(node), comment, newComment);
    }

    public synchronized IComment editGroupNodeComment(INaviGroupNode node, IComment oldComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(node, "IE02589: function argument can not be null");
        return this.editComment(new GroupNodeCommentingStrategy(node), oldComment, commentText);
    }

    public synchronized void editInstructionComment(INaviInstruction instruction, INaviCodeNode node, IComment comment, IComment newComment, CommentScope scope) {
        Preconditions.checkNotNull(instruction, "IE02590: instruction argument can not be null");
        this.editCommentInternal(new InstructionCommentingStrategy(instruction, node, scope), comment, newComment);
    }

    public synchronized IComment editLocalCodeNodeComment(INaviCodeNode node, IComment comment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(node, "IE02591: codeNode argument can not be null");
        return this.editComment(new CodeNodeCommentingStrategy(node, CommentScope.LOCAL), comment, commentText);
    }

    public synchronized IComment editLocalEdgeComment(INaviEdge edge, IComment editedComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(edge, "IE02592: edge argument can not be null");
        return this.editComment(new EdgeCommentingStrategy(edge, CommentScope.LOCAL), editedComment, commentText);
    }

    public synchronized IComment editLocalInstructionComment(INaviCodeNode node, INaviInstruction instruction, IComment comment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(instruction, "IE00100: Instruction argument can not be null");
        return this.editComment(new InstructionCommentingStrategy(instruction, node, CommentScope.LOCAL), comment, commentText);
    }

    public synchronized void editTextNodeComment(INaviTextNode node, IComment comment, IComment newComment, CommentScope scope) {
        Preconditions.checkNotNull(node, "IE02593: node argument can not be null");
        this.editCommentInternal(new TextNodeCommentingStrategy(node), comment, newComment);
    }

    public synchronized IComment editTextNodeComment(INaviTextNode node, IComment oldComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(node, "IE02594: function argument can not be null");
        return this.editComment(new TextNodeCommentingStrategy(node), oldComment, commentText);
    }

    public synchronized IComment editTypeInstanceComment(TypeInstance typeInstance, IComment oldComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(typeInstance, "Error: type instance argument can not be null");
        return this.editComment(new TypeInstanceCommentingStrategy(typeInstance), oldComment, commentText);
    }

    public synchronized void editTypeInstanceComment(TypeInstance typeInstance, IComment currentComment, IComment newComment) {
        Preconditions.checkNotNull(typeInstance, "Error: typeInstance argument can not be null");
        this.editCommentInternal(new TypeInstanceCommentingStrategy(typeInstance), currentComment, newComment);
    }

    public synchronized IComment editSectionComment(Section section, IComment oldComment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        return this.editComment(new SectionCommentingStrategy(section), oldComment, commentText);
    }

    public synchronized IComment getCommentById(Integer commentId) {
        if (commentId == null) {
            return null;
        }
        return this.commentIdToComment.get(commentId);
    }

    public synchronized INaviFunction getCommentedFunction(IComment comment) {
        return this.functionCommentContainer.getCommented(comment);
    }

    public synchronized INaviFunctionNode getCommentedFunctionNode(IComment comment) {
        return this.functionNodeCommentContainer.getCommented(comment);
    }

    public synchronized INaviCodeNode getCommentedGlobalCodeNode(IComment comment) {
        return this.globalCodeNodeCommentContainer.getCommented(comment);
    }

    public synchronized INaviEdge getCommentedGlobalEdge(IComment comment) {
        return this.globalEdgeCommentContainer.getCommented(comment);
    }

    public synchronized INaviInstruction getCommentedGlobalInstruction(IComment comment) {
        return this.globalInstructionsCommentContainer.getCommented(comment);
    }

    public synchronized INaviGroupNode getCommentedGroupNode(IComment comment) {
        return this.groupNodeCommentContainer.getCommented(comment);
    }

    public synchronized INaviCodeNode getCommentedLocalCodeNode(IComment comment) {
        return this.localCodeNodeCommentContainer.getCommented(comment);
    }

    public synchronized INaviEdge getCommentedLocalEdge(IComment comment) {
        return this.localEdgeCommentContainer.getCommented(comment);
    }

    public synchronized Pair<INaviCodeNode, INaviInstruction> getCommentedLocalInstruction(IComment comment) {
        return this.localInstructionCommentContainer.getCommented(comment);
    }

    public synchronized INaviTextNode getCommentedTextNode(IComment comment) {
        return this.textNodeCommentContainer.getCommented(comment);
    }

    public synchronized TypeInstance getCommentedTypeInstance(IComment comment) {
        return this.typeInstanceCommentContainer.getCommented(comment);
    }

    public synchronized List<IComment> getFunctionNodeComment(INaviFunctionNode functionNode) {
        Preconditions.checkNotNull(functionNode, "IE02595: functionNode argument can not be null");
        return this.functionNodeCommentContainer.getComments(functionNode);
    }

    public synchronized List<IComment> getGlobalCodeNodeComment(INaviCodeNode node) {
        Preconditions.checkNotNull(node, "IE00090: Code node argument can not be null");
        return this.globalCodeNodeCommentContainer.getComments(node);
    }

    public synchronized List<IComment> getGlobalEdgeComment(INaviEdge edge) {
        Preconditions.checkNotNull(edge, "IE00092: Edge argument can not be null");
        return this.globalEdgeCommentContainer.getComments(edge);
    }

    public synchronized List<IComment> getGlobalFunctionComment(INaviFunction function) {
        Preconditions.checkNotNull(function, "IE00091: Function argument can not be null");
        return this.functionCommentContainer.getComments(function);
    }

    public synchronized List<IComment> getGlobalInstructionComment(INaviInstruction instruction) {
        Preconditions.checkNotNull(instruction, "IE00093: Instruction argument can not be null");
        return this.globalInstructionsCommentContainer.getComments(instruction);
    }

    public synchronized List<IComment> getGroupNodeComment(INaviGroupNode node) {
        Preconditions.checkNotNull(node, "IE02596: node argument can not be null");
        return this.groupNodeCommentContainer.getComments(node);
    }

    public synchronized List<IComment> getLocalCodeNodeComment(INaviCodeNode node) {
        Preconditions.checkNotNull(node, "IE02597: node argument can not be null");
        return this.localCodeNodeCommentContainer.getComments(node);
    }

    public synchronized List<IComment> getLocalEdgeComment(INaviEdge edge) {
        Preconditions.checkNotNull(edge, "IE02598: edge argument can not be null");
        return this.localEdgeCommentContainer.getComments(edge);
    }

    public synchronized List<IComment> getLocalInstructionComment(INaviInstruction instruction, INaviCodeNode codeNode) {
        Preconditions.checkNotNull(instruction, "IE02599: instruction argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02600: codeNode argument can not be null");
        return this.localInstructionCommentContainer.getComments(new Pair<INaviCodeNode, INaviInstruction>(codeNode, instruction));
    }

    public synchronized List<IComment> getSectionComments(Section section) {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        return this.sectionCommentContainer.getComments(section);
    }

    public synchronized List<IComment> getTextNodeComment(INaviTextNode node) {
        Preconditions.checkNotNull(node, "IE02601: node argument can not be null");
        return this.textNodeCommentContainer.getComments(node);
    }

    public synchronized List<IComment> getTypeInstanceComments(TypeInstance instance) {
        Preconditions.checkNotNull(instance, "Error: type instance argument can not be null");
        return this.typeInstanceCommentContainer.getComments(instance);
    }

    public synchronized void initializeFunctionNodeComment(INaviFunctionNode functionNode, List<IComment> comments) {
        Preconditions.checkNotNull(functionNode, "IE00096: Function argument can not be null");
        this.initializeComment(new FunctionNodeCommentingStrategy(functionNode), comments);
    }

    public synchronized void unloadFunctionNodeComment(INaviFunctionNode functionNode, List<IComment> comments) {
        Preconditions.checkNotNull(functionNode, "Error: functionNode argument can not be null");
        this.unloadComment(new FunctionNodeCommentingStrategy(functionNode), comments);
    }

    public synchronized void initializeGlobalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comments) {
        Preconditions.checkNotNull(codeNode, "IE00094: Code node argument can not be null");
        this.initializeComment(new CodeNodeCommentingStrategy(codeNode, CommentScope.GLOBAL), comments);
    }

    public synchronized void unloadGlobalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comments) {
        Preconditions.checkNotNull(codeNode, "Error: codeNode argument can not be null");
        this.unloadComment(new CodeNodeCommentingStrategy(codeNode, CommentScope.GLOBAL), comments);
    }

    public synchronized void initializeGlobalEdgeComment(INaviEdge edge, List<IComment> comments) {
        Preconditions.checkNotNull(edge, "IE00098: Edge argument can not be null");
        this.initializeComment(new EdgeCommentingStrategy(edge, CommentScope.GLOBAL), comments);
    }

    public synchronized void unloadGlobalEdgeComment(INaviEdge edge, List<IComment> comments) {
        Preconditions.checkNotNull(edge, "Error: edge argument can not be null");
        this.unloadComment(new EdgeCommentingStrategy(edge, CommentScope.GLOBAL), comments);
    }

    public synchronized void initializeGlobalFunctionComment(INaviFunction function, List<IComment> comments) {
        Preconditions.checkNotNull(function, "IE00096: Function argument can not be null");
        this.initializeComment(new FunctionCommentingStrategy(function), comments);
    }

    public synchronized void unloadGlobalFunctionComment(INaviFunction function, List<IComment> comments) {
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        this.unloadComment(new FunctionCommentingStrategy(function), comments);
    }

    public synchronized void initializeGlobalInstructionComment(INaviInstruction instruction, List<IComment> comments) {
        Preconditions.checkNotNull(instruction, "IE00100: Instruction argument can not be null");
        this.initializeComment(new InstructionCommentingStrategy(instruction, null, CommentScope.GLOBAL), comments);
    }

    public synchronized void unloadGlobalInstructionComment(INaviInstruction instruction, List<IComment> comments) {
        Preconditions.checkNotNull(instruction, "Error: instruction argument can not be null");
        this.unloadComment(new InstructionCommentingStrategy(instruction, null, CommentScope.GLOBAL), comments);
    }

    public synchronized void initializeGroupNodeComment(INaviGroupNode groupNode, List<IComment> comments) {
        Preconditions.checkNotNull(groupNode, "IE00096: Function argument can not be null");
        this.initializeComment(new GroupNodeCommentingStrategy(groupNode), comments);
    }

    public synchronized void unloadGroupNodeComment(INaviGroupNode groupNode, List<IComment> comments) {
        Preconditions.checkNotNull(groupNode, "Error: groupNode argument can not be null");
        this.unloadComment(new GroupNodeCommentingStrategy(groupNode), comments);
    }

    public synchronized void initializeLocalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comments) {
        Preconditions.checkNotNull(codeNode, "IE00094: Code node argument can not be null");
        this.initializeComment(new CodeNodeCommentingStrategy(codeNode, CommentScope.LOCAL), comments);
    }

    public synchronized void unloadLocalCodeNodeComment(INaviCodeNode codeNode, List<IComment> comments) {
        Preconditions.checkNotNull(codeNode, "Error: codeNode argument can not be null");
        this.unloadComment(new CodeNodeCommentingStrategy(codeNode, CommentScope.LOCAL), comments);
    }

    public synchronized void initializeLocalEdgeComment(INaviEdge edge, List<IComment> comments) {
        Preconditions.checkNotNull(edge, "IE02602: edge argument can not be null");
        this.initializeComment(new EdgeCommentingStrategy(edge, CommentScope.LOCAL), comments);
    }

    public synchronized void unloadLocalEdgeComment(INaviEdge edge, List<IComment> comments) {
        Preconditions.checkNotNull(edge, "Error: edge argument can not be null");
        this.unloadComment(new EdgeCommentingStrategy(edge, CommentScope.LOCAL), comments);
    }

    public synchronized void initializeLocalInstructionComment(INaviCodeNode node, INaviInstruction instruction, List<IComment> comments) {
        Preconditions.checkNotNull(instruction, "IE00100: Instruction argument can not be null");
        this.initializeComment(new InstructionCommentingStrategy(instruction, node, CommentScope.LOCAL), comments);
    }

    public synchronized void unloadLocalnstructionComment(INaviCodeNode node, INaviInstruction instruction, List<IComment> comments) {
        Preconditions.checkNotNull(instruction, "Error: instruction argument can not be null");
        this.unloadComment(new InstructionCommentingStrategy(instruction, node, CommentScope.LOCAL), comments);
    }

    public synchronized void initializeTextNodeComment(INaviTextNode textnode, List<IComment> comments) {
        Preconditions.checkNotNull(textnode, "IE00096: text node argument can not be null");
        this.initializeComment(new TextNodeCommentingStrategy(textnode), comments);
    }

    public synchronized void unloadTextNodeComment(INaviTextNode textnode, List<IComment> comments) {
        Preconditions.checkNotNull(textnode, "Error: textnode argument can not be null");
        this.unloadComment(new TextNodeCommentingStrategy(textnode), comments);
    }

    public synchronized void initializeTypeInstanceComment(TypeInstance typeInstance, List<IComment> comments) {
        Preconditions.checkNotNull(typeInstance, "Error: type instance argument can not be null");
        this.initializeComment(new TypeInstanceCommentingStrategy(typeInstance), comments);
    }

    public synchronized void unloadTypeInstanceComment(TypeInstance typeInstance, List<IComment> comments) {
        Preconditions.checkNotNull(typeInstance, "Error: typeInstance argument can not be null");
        this.unloadComment(new TypeInstanceCommentingStrategy(typeInstance), comments);
    }

    public synchronized void initializeSectionComment(Section section, List<IComment> comments) {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        this.initializeComment(new SectionCommentingStrategy(section), comments);
    }

    public synchronized void unloadSectionComment(Section section, List<IComment> comments) {
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        this.unloadComment(new SectionCommentingStrategy(section), comments);
    }

    public synchronized void removeListener(CommentListener listener) {
        this.listeners.removeListener(listener);
    }

    public static enum CommentScope {
        GLOBAL,
        LOCAL;

    }

    public static enum CommentOperation {
        APPEND,
        EDIT,
        DELETE;

    }

    private class TypeInstanceCommentingStrategy
    implements CommentingStrategy {
        private final TypeInstance typeInstance;

        public TypeInstanceCommentingStrategy(TypeInstance instance) {
            this.typeInstance = instance;
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = CommentManager.this.provider.appendTypeInstanceComment(this.typeInstance.getModule().getConfiguration().getId(), this.typeInstance.getId(), commentText, userId);
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            CommentManager.this.provider.deleteTypeInstanceComment(this.typeInstance.getModule().getConfiguration().getId(), this.typeInstance.getId(), commentId, userId);
        }

        @Override
        public void editComment(Integer commentId, int userId, String commentText) throws CouldntSaveDataException {
            CommentManager.this.provider.editTypeInstanceComment(this.typeInstance.getModule().getConfiguration().getId(), commentId, userId, commentText);
        }

        @Override
        public List<IComment> getComments() {
            return CommentManager.this.typeInstanceCommentContainer.getComments(this.typeInstance);
        }

        @Override
        public boolean isStored() {
            return true;
        }

        @Override
        public void saveComments(List<IComment> comments) {
            CommentManager.this.typeInstanceCommentContainer.setComments(this.typeInstance, comments);
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            listener.appendedTypeInstanceComment(this.typeInstance, comment);
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            listener.deletedTypeInstanceComment(this.typeInstance, comment);
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            listener.editedTypeInstanceComment(this.typeInstance, comment);
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            listener.initializedTypeInstanceComment(this.typeInstance, comments);
        }

        @Override
        public void removeComments(List<IComment> comments) {
            CommentManager.this.typeInstanceCommentContainer.unsetComments(this.typeInstance, comments);
        }
    }

    private class TextNodeCommentingStrategy
    implements CommentingStrategy {
        private final INaviTextNode textNode;

        public TextNodeCommentingStrategy(INaviTextNode node) {
            this.textNode = Preconditions.checkNotNull(node, "IE02611: node argument can not be null");
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = CommentManager.this.provider.appendTextNodeComment(this.textNode, commentText, userId);
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            CommentManager.this.provider.deleteTextNodeComment(this.textNode, commentId, userId);
        }

        @Override
        public void editComment(Integer id, int userId, String commentText) throws CouldntSaveDataException {
            CommentManager.this.provider.editTextNodeComment(this.textNode, id, userId, commentText);
        }

        @Override
        public List<IComment> getComments() {
            return CommentManager.this.getTextNodeComment(this.textNode);
        }

        @Override
        public boolean isStored() {
            return this.textNode.isStored();
        }

        @Override
        public void saveComments(List<IComment> comments) {
            CommentManager.this.textNodeCommentContainer.setComments(this.textNode, comments);
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            listener.appendedTextNodeComment(this.textNode, comment);
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            listener.deletedTextNodeComment(this.textNode, comment);
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            listener.editedTextNodeComment(this.textNode, comment);
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            listener.initializedTextNodeComments(this.textNode, comments);
        }

        @Override
        public void removeComments(List<IComment> comments) {
            CommentManager.this.textNodeCommentContainer.unsetComments(this.textNode, comments);
        }
    }

    private class InstructionCommentingStrategy
    implements CommentingStrategy {
        private final INaviInstruction instruction;
        private final INaviCodeNode codeNode;
        private final CommentScope scope;

        public InstructionCommentingStrategy(INaviInstruction currentInstruction, INaviCodeNode node, CommentScope currentScope) {
            this.instruction = Preconditions.checkNotNull(currentInstruction, "Error: currentInstruction argument can not be null");
            this.scope = Preconditions.checkNotNull(currentScope, "IE02610: currentScope argument can not be null");
            Preconditions.checkArgument(currentScope.equals((Object)CommentScope.GLOBAL) || node != null, "Error: a local comment scope requires a valid code node argument");
            this.codeNode = node;
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = this.scope.equals((Object)CommentScope.GLOBAL) ? CommentManager.this.provider.appendGlobalInstructionComment(this.instruction, commentText, userId) : CommentManager.this.provider.appendLocalInstructionComment(this.codeNode, this.instruction, commentText, userId);
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.provider.deleteGlobalInstructionComment(this.instruction, commentId, userId);
            } else {
                CommentManager.this.provider.deleteLocalInstructionComment(this.codeNode, this.instruction, commentId, userId);
            }
        }

        @Override
        public void editComment(Integer id, int userId, String commentText) throws CouldntSaveDataException {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.provider.editGlobalInstructionComment(this.instruction, id, userId, commentText);
            } else {
                CommentManager.this.provider.editLocalInstructionComment(this.codeNode, this.instruction, id, userId, commentText);
            }
        }

        @Override
        public List<IComment> getComments() {
            return this.scope.equals((Object)CommentScope.GLOBAL) ? CommentManager.this.getGlobalInstructionComment(this.instruction) : CommentManager.this.getLocalInstructionComment(this.instruction, this.codeNode);
        }

        @Override
        public boolean isStored() {
            return this.instruction.isStored();
        }

        @Override
        public void saveComments(List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.globalInstructionsCommentContainer.setComments(this.instruction, comments);
            } else {
                CommentManager.this.localInstructionCommentContainer.setComments(new Pair<INaviCodeNode, INaviInstruction>(this.codeNode, this.instruction), comments);
            }
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.appendedGlobalInstructionComment(this.instruction, comment);
            } else {
                listener.appendedLocalInstructionComment(this.codeNode, this.instruction, comment);
            }
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.deletedGlobalInstructionComment(this.instruction, comment);
            } else {
                listener.deletedLocalInstructionComment(this.codeNode, this.instruction, comment);
            }
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.editedGlobalInstructionComment(this.instruction, comment);
            } else {
                listener.editedLocalInstructionComment(this.codeNode, this.instruction, comment);
            }
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.initializedGlobalInstructionComments(this.instruction, comments);
            } else {
                listener.initializedLocalInstructionComments(this.codeNode, this.instruction, comments);
            }
        }

        @Override
        public void removeComments(List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.globalInstructionsCommentContainer.unsetComments(this.instruction, comments);
            } else {
                CommentManager.this.localInstructionCommentContainer.unsetComments(new Pair<INaviCodeNode, INaviInstruction>(this.codeNode, this.instruction), comments);
            }
        }
    }

    private class GroupNodeCommentingStrategy
    implements CommentingStrategy {
        private final INaviGroupNode groupNode;

        public GroupNodeCommentingStrategy(INaviGroupNode node) {
            this.groupNode = Preconditions.checkNotNull(node, "IE02609: node argument can not be null");
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = this.groupNode.isStored() ? CommentManager.this.provider.appendGroupNodeComment(this.groupNode, commentText, userId) : null;
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            if (this.groupNode.isStored()) {
                CommentManager.this.provider.deleteGroupNodeComment(this.groupNode, commentId, userId);
            }
        }

        @Override
        public void editComment(Integer id, int userId, String commentText) throws CouldntSaveDataException {
            if (this.groupNode.isStored()) {
                CommentManager.this.provider.editGroupNodeComment(this.groupNode, id, userId, commentText);
            }
        }

        @Override
        public List<IComment> getComments() {
            return CommentManager.this.getGroupNodeComment(this.groupNode);
        }

        @Override
        public boolean isStored() {
            return this.groupNode.isStored();
        }

        @Override
        public void saveComments(List<IComment> comments) {
            CommentManager.this.groupNodeCommentContainer.setComments(this.groupNode, comments);
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            listener.appendedGroupNodeComment(this.groupNode, comment);
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            listener.deletedGroupNodeComment(this.groupNode, comment);
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            listener.editedGroupNodeComment(this.groupNode, comment);
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            listener.initializedGroupNodeComments(this.groupNode, comments);
        }

        @Override
        public void removeComments(List<IComment> comments) {
            CommentManager.this.groupNodeCommentContainer.unsetComments(this.groupNode, comments);
        }
    }

    private class FunctionNodeCommentingStrategy
    implements CommentingStrategy {
        private final INaviFunctionNode functionNode;

        public FunctionNodeCommentingStrategy(INaviFunctionNode node) {
            this.functionNode = Preconditions.checkNotNull(node, "IE02608: node argument can not be null");
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = this.functionNode.isStored() ? CommentManager.this.provider.appendFunctionNodeComment(this.functionNode, commentText, userId) : null;
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            if (this.functionNode.isStored()) {
                CommentManager.this.provider.deleteFunctionNodeComment(this.functionNode, commentId, userId);
            }
        }

        @Override
        public void editComment(Integer id, int userId, String commentText) throws CouldntSaveDataException {
            if (this.functionNode.isStored()) {
                CommentManager.this.provider.editFunctionNodeComment(this.functionNode, id, userId, commentText);
            }
        }

        @Override
        public List<IComment> getComments() {
            return CommentManager.this.getFunctionNodeComment(this.functionNode);
        }

        @Override
        public boolean isStored() {
            return this.functionNode.isStored();
        }

        @Override
        public void saveComments(List<IComment> comments) {
            CommentManager.this.functionNodeCommentContainer.setComments(this.functionNode, comments);
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            listener.appendedFunctionNodeComment(this.functionNode, comment);
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            listener.deletedFunctionNodeComment(this.functionNode, comment);
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            listener.editedFunctionNodeComment(this.functionNode, comment);
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            listener.initializedFunctionNodeComments(this.functionNode, comments);
        }

        @Override
        public void removeComments(List<IComment> comments) {
            CommentManager.this.functionNodeCommentContainer.unsetComments(this.functionNode, comments);
        }
    }

    private class SectionCommentingStrategy
    implements CommentingStrategy {
        private final Section section;

        public SectionCommentingStrategy(Section section) {
            this.section = Preconditions.checkNotNull(section, "Error: section argument can not be null");
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = CommentManager.this.provider.appendSectionComment(this.section.getModule().getConfiguration().getId(), this.section.getId(), commentText, userId);
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            CommentManager.this.provider.deleteSectionComment(this.section.getModule().getConfiguration().getId(), this.section.getId(), commentId, userId);
        }

        @Override
        public void editComment(Integer commentId, int userId, String commentText) throws CouldntSaveDataException {
            CommentManager.this.provider.editSectionComment(this.section.getModule().getConfiguration().getId(), this.section.getId(), commentId, userId, commentText);
        }

        @Override
        public List<IComment> getComments() {
            return CommentManager.this.sectionCommentContainer.getComments(this.section);
        }

        @Override
        public boolean isStored() {
            return true;
        }

        @Override
        public void saveComments(List<IComment> comments) {
            CommentManager.this.sectionCommentContainer.setComments(this.section, comments);
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            listener.appendedSectionComment(this.section, comment);
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            listener.deletedSectionComment(this.section, comment);
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            listener.editedSectionComment(this.section, comment);
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            listener.initializedSectionComments(this.section, comments);
        }

        @Override
        public void removeComments(List<IComment> comments) {
            CommentManager.this.sectionCommentContainer.unsetComments(this.section, comments);
        }
    }

    private class FunctionCommentingStrategy
    implements CommentingStrategy {
        private final INaviFunction function;

        public FunctionCommentingStrategy(INaviFunction currentFunction) {
            this.function = Preconditions.checkNotNull(currentFunction, "IE02607: node argument can not be null");
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = CommentManager.this.provider.appendFunctionComment(this.function, commentText, userId);
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            CommentManager.this.provider.deleteFunctionComment(this.function, commentId, userId);
        }

        @Override
        public void editComment(Integer id, int userId, String commentText) throws CouldntSaveDataException {
            CommentManager.this.provider.editFunctionComment(this.function, id, userId, commentText);
        }

        @Override
        public List<IComment> getComments() {
            return CommentManager.this.getGlobalFunctionComment(this.function);
        }

        @Override
        public boolean isStored() {
            return true;
        }

        @Override
        public void saveComments(List<IComment> comments) {
            CommentManager.this.functionCommentContainer.setComments(this.function, comments);
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            listener.appendedGlobalFunctionComment(this.function, comment);
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            listener.deletedGlobalFunctionComment(this.function, comment);
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            listener.editedGlobalFunctionComment(this.function, comment);
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            listener.initializedGlobalFunctionComments(this.function, comments);
        }

        @Override
        public void removeComments(List<IComment> comments) {
            CommentManager.this.functionCommentContainer.unsetComments(this.function, comments);
        }
    }

    private class EdgeCommentingStrategy
    implements CommentingStrategy {
        private final INaviEdge edge;
        private final CommentScope scope;

        public EdgeCommentingStrategy(INaviEdge currentEdge, CommentScope currentScope) {
            this.edge = Preconditions.checkNotNull(currentEdge, "IE02605: edge argument can not be null");
            this.scope = Preconditions.checkNotNull(currentScope, "IE02606: currentScope argument can not be null");
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = this.scope.equals((Object)CommentScope.GLOBAL) ? CommentManager.this.provider.appendGlobalEdgeComment(this.edge, commentText, userId) : CommentManager.this.provider.appendLocalEdgeComment(this.edge, commentText, userId);
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.provider.deleteGlobalEdgeComment(this.edge, commentId, userId);
            } else {
                CommentManager.this.provider.deleteLocalEdgeComment(this.edge, commentId, userId);
            }
        }

        @Override
        public void editComment(Integer id, int userId, String commentText) throws CouldntSaveDataException {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.provider.editGlobalEdgeComment(this.edge, id, userId, commentText);
            } else {
                CommentManager.this.provider.editLocalEdgeComment(this.edge, id, userId, commentText);
            }
        }

        @Override
        public List<IComment> getComments() {
            return this.scope.equals((Object)CommentScope.GLOBAL) ? CommentManager.this.getGlobalEdgeComment(this.edge) : CommentManager.this.getLocalEdgeComment(this.edge);
        }

        @Override
        public boolean isStored() {
            return this.edge.isStored();
        }

        @Override
        public void saveComments(List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.globalEdgeCommentContainer.setComments(this.edge, comments);
            } else {
                CommentManager.this.localEdgeCommentContainer.setComments(this.edge, comments);
            }
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.appendedGlobalEdgeComment(this.edge, comment);
            } else {
                listener.appendedLocalEdgeComment(this.edge, comment);
            }
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.deletedGlobalEdgeComment(this.edge, comment);
            } else {
                listener.deletedLocalEdgeComment(this.edge, comment);
            }
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.editedGlobalEdgeComment(this.edge, comment);
            } else {
                listener.editedLocalEdgeComment(this.edge, comment);
            }
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.initializedGlobalEdgeComments(this.edge, comments);
            } else {
                listener.initializedLocalEdgeComments(this.edge, comments);
            }
        }

        @Override
        public void removeComments(List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.globalEdgeCommentContainer.unsetComments(this.edge, comments);
            } else {
                CommentManager.this.localEdgeCommentContainer.unsetComments(this.edge, comments);
            }
        }
    }

    private static interface CommentingStrategy {
        public List<IComment> appendComment(String var1, Integer var2) throws CouldntSaveDataException, CouldntLoadDataException;

        public void removeComments(List<IComment> var1);

        public void deleteComment(Integer var1, Integer var2) throws CouldntDeleteException;

        public void editComment(Integer var1, int var2, String var3) throws CouldntSaveDataException;

        public List<IComment> getComments();

        public boolean isStored();

        public void saveComments(List<IComment> var1);

        public void sendAppendedCommentNotifcation(CommentListener var1, IComment var2);

        public void sendDeletedCommentNotification(CommentListener var1, IComment var2);

        public void sendEditedCommentNotification(CommentListener var1, IComment var2);

        public void sendInitializedCommentNotification(CommentListener var1, List<IComment> var2);
    }

    private final class CommentContainer<CommentableType, CommentType> {
        private final Map<CommentableType, List<CommentType>> commentableToComment = Maps.newHashMap();
        private final Map<CommentType, CommentableType> commentToCommentable = Maps.newHashMap();

        private CommentContainer() {
        }

        public CommentableType getCommented(CommentType comment) {
            return this.commentToCommentable.get(comment);
        }

        public List<CommentType> getComments(CommentableType commentable) {
            return this.commentableToComment.get(commentable);
        }

        public void setComments(CommentableType commentable, List<CommentType> comments) {
            this.commentableToComment.put(commentable, comments);
            for (CommentType commentType : comments) {
                this.commentToCommentable.put(commentType, commentable);
            }
        }

        public void unsetComments(CommentableType commentable, List<CommentType> comments) {
            this.commentableToComment.remove(commentable);
            for (CommentType commentType : comments) {
                this.commentToCommentable.remove(commentType);
            }
        }
    }

    private class CodeNodeCommentingStrategy
    implements CommentingStrategy {
        private final INaviCodeNode codeNode;
        private final CommentScope scope;

        public CodeNodeCommentingStrategy(INaviCodeNode node, CommentScope currentScope) {
            this.codeNode = Preconditions.checkNotNull(node, "IE02603: node argument can not be null");
            this.scope = Preconditions.checkNotNull(currentScope, "IE02604: currentScope argument can not be null");
        }

        @Override
        public List<IComment> appendComment(String commentText, Integer userId) throws CouldntSaveDataException, CouldntLoadDataException {
            Integer commentId = this.scope.equals((Object)CommentScope.GLOBAL) ? CommentManager.this.provider.appendGlobalCodeNodeComment(this.codeNode, commentText, userId) : CommentManager.this.provider.appendLocalCodeNodeComment(this.codeNode, commentText, userId);
            return CommentManager.this.provider.loadCommentById(commentId);
        }

        @Override
        public void deleteComment(Integer commentId, Integer userId) throws CouldntDeleteException {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.provider.deleteGlobalCodeNodeComment(this.codeNode, commentId, userId);
            } else {
                CommentManager.this.provider.deleteLocalCodeNodeComment(this.codeNode, commentId, userId);
            }
        }

        @Override
        public void editComment(Integer id, int userId, String commentText) throws CouldntSaveDataException {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.provider.editGlobalCodeNodeComment(this.codeNode, id, userId, commentText);
            } else {
                CommentManager.this.provider.editLocalCodeNodeComment(this.codeNode, id, userId, commentText);
            }
        }

        @Override
        public List<IComment> getComments() {
            return this.scope.equals((Object)CommentScope.GLOBAL) ? CommentManager.this.getGlobalCodeNodeComment(this.codeNode) : CommentManager.this.getLocalCodeNodeComment(this.codeNode);
        }

        @Override
        public boolean isStored() {
            return this.codeNode.isStored();
        }

        @Override
        public void saveComments(List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.globalCodeNodeCommentContainer.setComments(this.codeNode, comments);
            } else {
                CommentManager.this.localCodeNodeCommentContainer.setComments(this.codeNode, comments);
            }
        }

        @Override
        public void sendAppendedCommentNotifcation(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.appendedGlobalCodeNodeComment(this.codeNode, comment);
            } else {
                listener.appendedLocalCodeNodeComment(this.codeNode, comment);
            }
        }

        @Override
        public void sendDeletedCommentNotification(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.deletedGlobalCodeNodeComment(this.codeNode, comment);
            } else {
                listener.deletedLocalCodeNodeComment(this.codeNode, comment);
            }
        }

        @Override
        public void sendEditedCommentNotification(CommentListener listener, IComment comment) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.editedGLobalCodeNodeComment(this.codeNode, comment);
            } else {
                listener.editedLocalCodeNodeComment(this.codeNode, comment);
            }
        }

        @Override
        public void sendInitializedCommentNotification(CommentListener listener, List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                listener.initializedGlobalCodeNodeComments(this.codeNode, comments);
            } else {
                listener.initializedLocalCodeNodeComments(this.codeNode, comments);
            }
        }

        @Override
        public void removeComments(List<IComment> comments) {
            if (this.scope.equals((Object)CommentScope.GLOBAL)) {
                CommentManager.this.globalCodeNodeCommentContainer.unsetComments(this.codeNode, comments);
            } else {
                CommentManager.this.localCodeNodeCommentContainer.unsetComments(this.codeNode, comments);
            }
        }
    }

    private class InternalSQLProviderListener
    implements SQLProviderListener {
        private InternalSQLProviderListener() {
        }

        @Override
        public void providerClosing(SQLProvider provider) {
            if (CommentManager.this.provider.equals(provider)) {
                CommentManager.this.close();
            }
        }
    }
}

