/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;

public final class CRawModule
implements INaviRawModule {
    private final int m_id;
    private final String m_name;
    private final SQLProvider m_provider;
    private final int m_functionCount;
    private final boolean m_isComplete;

    public CRawModule(int rawModuleId, String name, int functionCount, boolean isComplete, SQLProvider provider) {
        Preconditions.checkArgument(rawModuleId > 0, "IE00258: Module ID must be positive");
        this.m_name = Preconditions.checkNotNull(name, "IE00259: Module Name can't be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE00265: Invalid SQL provider");
        this.m_id = rawModuleId;
        this.m_functionCount = functionCount;
        this.m_isComplete = isComplete;
    }

    @Override
    public int getFunctionCount() {
        return this.m_functionCount;
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return provider.equals(this.m_provider);
    }

    @Override
    public boolean isComplete() {
        return this.m_isComplete;
    }
}

