/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CProjectViewGenerator;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.IProjectListener;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public final class CProjectContent {
    private final INaviProject m_project;
    private final ListenerProvider<IProjectListener> m_listeners;
    private final SQLProvider m_provider;
    private final List<CAddressSpace> m_addressSpaces;
    private final List<INaviView> m_views;
    private final IFilledList<TraceList> m_traces;

    public CProjectContent(INaviProject project, ListenerProvider<IProjectListener> listeners, SQLProvider provider, List<CAddressSpace> addressSpaces, List<INaviView> views, IFilledList<TraceList> traces) {
        this.m_project = Preconditions.checkNotNull(project, "IE02222: Project argument can not be null");
        this.m_listeners = Preconditions.checkNotNull(listeners, "IE02223: Listeners argument can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE02224: Provider argument can not be null");
        this.m_addressSpaces = Preconditions.checkNotNull(addressSpaces, "IE02225: AddressSpaces argument can not be null");
        this.m_views = Preconditions.checkNotNull(views, "IE02226: Views argument can not be null");
        this.m_traces = Preconditions.checkNotNull(traces, "IE02227: Traces argument can not be null");
    }

    public void addView(INaviView view) {
        Preconditions.checkNotNull(view, "IE00232: View argument can't be null");
        Preconditions.checkArgument(view.getType() == ViewType.NonNative, "IE00233: Only non-native views can be added to projects");
        Preconditions.checkArgument(!this.m_views.contains(view), "IE00235: View can not be added to the project more than once");
        Preconditions.checkArgument(view.inSameDatabase(this.m_provider), "IE00236: View and project are not in the same database");
        this.m_views.add(view);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.addedView(this.m_project, view);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private boolean isLoaded() {
        return true;
    }

    public boolean close() {
        for (CAddressSpace addressSpace : this.m_addressSpaces) {
            if (!addressSpace.isLoaded() || addressSpace.close()) continue;
            return false;
        }
        for (INaviView view : this.m_views) {
            if (!view.isLoaded() || view.close()) continue;
            return false;
        }
        return true;
    }

    public CAddressSpace createAddressSpace(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00240: The value null is illegal for address space names");
        CAddressSpace space = this.m_provider.createAddressSpace(this.m_project, name);
        this.m_addressSpaces.add(space);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.addedAddressSpace(this.m_project, space);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_project.getConfiguration().updateModificationDate();
        return space;
    }

    public TraceList createTrace(String name, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00242: Name argument can't be null");
        Preconditions.checkNotNull(description, "IE00246: Description argument can't be null");
        TraceList trace2 = this.m_provider.createTrace(this.m_project, name, description);
        this.m_traces.add(trace2);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.addedTrace(this.m_project, trace2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_project.getConfiguration().updateModificationDate();
        return trace2;
    }

    public INaviView createView(INaviView view, String name, String description) {
        Preconditions.checkNotNull(view, "IE02228: view argument can not be null");
        Preconditions.checkArgument(view.inSameDatabase(this.m_provider), "IE02229: View and project Content are not in the same database");
        Preconditions.checkNotNull(name, "IE02230: name argument can not be null");
        Preconditions.checkNotNull(description, "IE02231: description argument can not be null");
        CView newView = CView.createUnsavedProjectView(this.m_project, view, name, description, this.m_provider);
        this.addView(newView);
        return newView;
    }

    public INaviView createView(String name, String description) {
        Date date = new Date();
        CProjectViewGenerator generator2 = new CProjectViewGenerator(this.m_provider, this.m_project);
        CView view = generator2.generate(-1, name, description, ViewType.NonNative, GraphType.MIXED_GRAPH, date, date, 0, 0, new HashSet<CTag>(), new HashSet<CTag>(), false);
        try {
            view.load();
        }
        catch (CPartialLoadException | CouldntLoadDataException | LoadCancelledException e2) {
            CUtilityFunctions.logException(e2);
        }
        this.addView(view);
        return view;
    }

    public boolean deleteView(INaviView view) throws CouldntDeleteException {
        Preconditions.checkNotNull(view, "IE00243: View argument can't be null");
        Preconditions.checkArgument(this.m_views.contains(view), "IE00244: View is not part of the module");
        this.m_provider.deleteView(view);
        this.m_views.remove(view);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.deletedView(this.m_project, view);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_project.getConfiguration().updateModificationDate();
        return true;
    }

    public List<INaviAddressSpace> getAddressSpaces() {
        Preconditions.checkState(this.isLoaded(), "IE00245: You have to load a project before accessing its address spaces");
        return new ArrayList<INaviAddressSpace>(this.m_addressSpaces);
    }

    public int getTraceCount() {
        Preconditions.checkState(this.isLoaded(), "IE00247: Project must be loaded first");
        return this.m_traces.size();
    }

    public List<TraceList> getTraces() {
        Preconditions.checkState(this.isLoaded(), "IE00248: Project must be loaded first");
        return new ArrayList<TraceList>(this.m_traces);
    }

    public List<INaviView> getViews() {
        Preconditions.checkState(this.isLoaded(), "IE00249: Project must be loaded first");
        return new ArrayList<INaviView>(this.m_views);
    }

    public boolean removeAddressSpace(INaviAddressSpace addressSpace) throws CouldntDeleteException {
        Preconditions.checkNotNull(addressSpace, "IE00251: The value null is not a valid address space");
        Preconditions.checkState(this.m_project.isLoaded(), "IE00252: You can only delete address spaces from loaded projects");
        Preconditions.checkArgument(this.m_addressSpaces.contains(addressSpace), "IE00253: Address space does not belong to the project");
        Preconditions.checkState(!addressSpace.isLoaded(), "IE00868: You can only delete unloaded address spaces");
        this.m_provider.deleteAddressSpace(addressSpace);
        this.m_addressSpaces.remove(addressSpace);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.removedAddressSpace(this.m_project, addressSpace);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_project.getConfiguration().updateModificationDate();
        return true;
    }

    public void removeTrace(TraceList trace2) throws CouldntDeleteException {
        Preconditions.checkNotNull(trace2, "IE02232: Trace argument can not be null");
        if (!trace2.inSameDatabase(this.m_provider)) {
            throw new IllegalStateException("IE02233: Trace and project are not in the same database");
        }
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.deletingTrace(this.m_project, trace2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_provider.deleteTrace(trace2);
        this.m_traces.remove(trace2);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.removedTrace(this.m_project, trace2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_project.getConfiguration().updateModificationDate();
    }

    public boolean deleteViewInternal(INaviView view) {
        Preconditions.checkNotNull(view, "IE00243: View argument can't be null");
        Preconditions.checkArgument(this.m_views.contains(view), "IE00244: View is not part of the module");
        this.m_views.remove(view);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.deletedView(this.m_project, view);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_project.getConfiguration().updateModificationDate();
        return true;
    }
}

