/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.IProjectListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class CProjectConfiguration {
    private final INaviProject m_project;
    private final ListenerProvider<IProjectListener> m_listeners;
    private final SQLProvider m_provider;
    private final int m_id;
    private String m_name;
    private String m_description;
    private final Date m_creationDate;
    private Date m_modificationDate;
    private final List<DebuggerTemplate> m_assignedDebuggers;

    public CProjectConfiguration(INaviProject project, ListenerProvider<IProjectListener> listeners, SQLProvider provider, int projectId, String name, String description, Date creationDate, Date modificationDate, List<DebuggerTemplate> assignedDebuggers) {
        this.m_project = project;
        this.m_listeners = listeners;
        this.m_provider = provider;
        this.m_id = projectId;
        this.m_name = name;
        this.m_description = description;
        this.m_creationDate = new Date(creationDate.getTime());
        this.m_modificationDate = new Date(modificationDate.getTime());
        this.m_assignedDebuggers = new ArrayList<DebuggerTemplate>(assignedDebuggers);
    }

    public void addDebugger(DebuggerTemplate debugger) throws CouldntSaveDataException {
        Preconditions.checkNotNull(debugger, "IE00237: Debugger argument can't be null");
        Preconditions.checkArgument(debugger.inSameDatabase(this.m_provider), "IE00238: Debugger template and project are not in the same database");
        this.m_provider.addDebugger(this.m_project, debugger);
        this.m_assignedDebuggers.add(debugger);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.addedDebugger(this.m_project, debugger);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public Date getCreationDate() {
        return new Date(this.m_creationDate.getTime());
    }

    public List<DebuggerTemplate> getDebuggers() {
        return new ArrayList<DebuggerTemplate>(this.m_assignedDebuggers);
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getId() {
        return this.m_id;
    }

    public Date getModificationDate() {
        return new Date(this.m_modificationDate.getTime());
    }

    public String getName() {
        return this.m_name;
    }

    public boolean hasDebugger(DebuggerTemplate debugger) {
        return this.m_assignedDebuggers.contains(debugger);
    }

    public void removeDebugger(DebuggerTemplate debugger) throws CouldntSaveDataException {
        Preconditions.checkNotNull(debugger, "IE00254: Debugger argument can't be null");
        Preconditions.checkArgument(this.m_assignedDebuggers.contains(debugger), "IE00255: Debugger template was not assigned to the project");
        this.m_provider.removeDebugger(this.m_project, debugger);
        this.m_assignedDebuggers.remove(debugger);
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.removedDebugger(this.m_project, debugger);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(description, "IE00256: Project description can't be null");
        if (this.m_description.equals(description)) {
            return;
        }
        this.m_provider.setDescription(this.m_project, description);
        this.m_description = description;
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.changedDescription(this.m_project, description);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public void setName(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00257: Project name can't be null");
        if (this.m_name.equals(name)) {
            return;
        }
        this.m_provider.setName(this.m_project, name);
        this.m_name = name;
        for (IProjectListener listener : this.m_listeners) {
            try {
                listener.changedName(this.m_project, name);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.updateModificationDate();
    }

    public void updateModificationDate() {
        try {
            this.m_modificationDate = this.m_provider.getModificationDate(this.m_project);
            for (IProjectListener listener : this.m_listeners) {
                try {
                    listener.changedModificationDate(this.m_project, this.m_modificationDate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
        catch (CouldntLoadDataException e2) {
            CUtilityFunctions.logException(e2);
        }
    }
}

