/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviReplacement;
import com.google.security.zynamics.binnavi.disassembly.INaviReplacementListener;
import com.google.security.zynamics.binnavi.disassembly.OperandDisplayStyle;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainerListener;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IReference;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class COperandTreeNode
implements INaviOperandTreeNode {
    private int id;
    private COperandTreeNode parent;
    private final List<COperandTreeNode> children = new ArrayList<COperandTreeNode>();
    private String expressionValue;
    private ExpressionType expressionType;
    private final INaviReplacement replacement;
    private final List<IReference> references;
    private final SQLProvider provider;
    private INaviOperandTree operandTree;
    private final ListenerProvider<INaviOperandTreeNodeListener> listeners = new ListenerProvider();
    private final INaviReplacementListener listener = new InternalReplacementListener();
    private OperandDisplayStyle displayStyle = OperandDisplayStyle.UNSIGNED_HEXADECIMAL;
    private TypeSubstitution substitution;
    private List<TypeInstanceReference> instanceReferences = null;
    private final TypeInstanceContainerListener typeInstanceContainerListener = new InternalTypeInstanceContainerListener();

    private COperandTreeNode(int nodeId, ExpressionType type, String value, INaviReplacement replacement, List<IReference> references, SQLProvider provider) {
        this.expressionType = Preconditions.checkNotNull(type, "IE00182: Type argument can not be null");
        this.expressionValue = Preconditions.checkNotNull(value, "IE00183: Value argument can not be null");
        this.references = new ArrayList<IReference>((Collection)Preconditions.checkNotNull(references, "IE00184: References argument can not be null"));
        this.provider = Preconditions.checkNotNull(provider, "IE00185: Provider argument can not be null");
        this.id = nodeId;
        this.replacement = replacement;
        if (replacement != null) {
            replacement.addListener(this.listener);
            this.displayStyle = OperandDisplayStyle.OFFSET;
        }
    }

    public COperandTreeNode(int nodeId, int type, String value, INaviReplacement replacement, List<IReference> references, SQLProvider provider, TypeManager typeManager, TypeInstanceContainer instanceContainer) {
        this.provider = Preconditions.checkNotNull(provider, "IE02212: Provider argument can not be null");
        Preconditions.checkNotNull(value, "IE00214: Value can not be null");
        this.references = new ArrayList<IReference>((Collection)Preconditions.checkNotNull(references, "IE02211: References argument can not be null"));
        this.id = nodeId;
        for (IReference reference : references) {
            Preconditions.checkNotNull(reference, "IE00215: Invalid reference in reference list");
        }
        Preconditions.checkNotNull(typeManager, "Type manager can not be null.");
        Preconditions.checkNotNull(instanceContainer, "Type instance container can not be null");
        this.initValue(type, value);
        if (this.expressionValue == null) {
            throw new IllegalArgumentException(String.format("IE00216: Unknown operand value '%s'", value));
        }
        this.replacement = replacement;
        if (replacement != null) {
            replacement.addListener(this.listener);
            this.displayStyle = OperandDisplayStyle.OFFSET;
        }
        instanceContainer.addListener(this.typeInstanceContainerListener);
    }

    private static INaviOperandTreeNode determineAddendSibling(INaviOperandTreeNode node) {
        INaviOperandTreeNode parent = node.getParent();
        if (parent == null || parent.getChildren().size() != 2 || !parent.getValue().equals("+")) {
            return null;
        }
        INaviOperandTreeNode firstChild = parent.getChildren().get(0);
        INaviOperandTreeNode secondChild = parent.getChildren().get(1);
        if (firstChild.getType().equals((Object)ExpressionType.IMMEDIATE_INTEGER) ^ secondChild.getType().equals((Object)ExpressionType.IMMEDIATE_INTEGER)) {
            return firstChild == node ? secondChild : firstChild;
        }
        return null;
    }

    public static void link(COperandTreeNode parent, COperandTreeNode child) {
        Preconditions.checkNotNull(child, "IE00218: Child argument can not be null");
        Preconditions.checkNotNull(parent, "IE00217: Parent argument can not be null");
        parent.children.add(child);
        child.parent = parent;
    }

    private void initValue(int type, String value) {
        switch (type) {
            case 1: {
                this.expressionType = ExpressionType.SYMBOL;
                this.expressionValue = value;
                break;
            }
            case 2: {
                this.expressionType = ExpressionType.IMMEDIATE_INTEGER;
                this.expressionValue = value;
                break;
            }
            case 3: {
                this.expressionType = ExpressionType.IMMEDIATE_FLOAT;
                this.expressionValue = value;
                break;
            }
            case 4: {
                if (value.equals("{")) {
                    this.expressionType = ExpressionType.EXPRESSION_LIST;
                    this.expressionValue = value;
                    break;
                }
                this.expressionType = ExpressionType.OPERATOR;
                this.expressionValue = value;
                break;
            }
            case 5: {
                this.expressionType = ExpressionType.REGISTER;
                this.expressionValue = value;
                break;
            }
            case 6: {
                if (value.equals("b1")) {
                    this.expressionType = ExpressionType.SIZE_PREFIX;
                    this.expressionValue = "byte";
                    break;
                }
                if (value.equals("b2")) {
                    this.expressionType = ExpressionType.SIZE_PREFIX;
                    this.expressionValue = "word";
                    break;
                }
                if (value.equals("b4") || value.equals("dword")) {
                    this.expressionType = ExpressionType.SIZE_PREFIX;
                    this.expressionValue = "dword";
                    break;
                }
                if (value.equals("b6")) {
                    this.expressionType = ExpressionType.SIZE_PREFIX;
                    this.expressionValue = "fword";
                    break;
                }
                if (value.equals("b8")) {
                    this.expressionType = ExpressionType.SIZE_PREFIX;
                    this.expressionValue = "qword";
                    break;
                }
                if (value.equals("b10")) {
                    this.expressionType = ExpressionType.SIZE_PREFIX;
                    this.expressionValue = "double";
                    break;
                }
                if (value.equals("b16")) {
                    this.expressionType = ExpressionType.SIZE_PREFIX;
                    this.expressionValue = "oword";
                    break;
                }
                if (!value.equals("b_var")) break;
                this.expressionType = ExpressionType.SIZE_PREFIX;
                this.expressionValue = "b_var";
                break;
            }
            case 7: {
                this.expressionType = ExpressionType.MEMDEREF;
                this.expressionValue = value;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("IE00219: Unknown node type (%d : %s)", type, value));
            }
        }
    }

    protected void setOperand(INaviOperandTree operandTree) {
        Preconditions.checkArgument(this.operandTree == null, "IE00220: Operand tree was already initialized");
        this.operandTree = operandTree;
    }

    @Override
    public void addInstanceReference(TypeInstanceReference reference) {
        if (this.instanceReferences == null) {
            this.instanceReferences = new ArrayList<TypeInstanceReference>();
        }
        this.instanceReferences.add(reference);
    }

    @Override
    public void addListener(INaviOperandTreeNodeListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void addReference(IReference reference) throws CouldntSaveDataException {
        Preconditions.checkNotNull(reference, "IE00221: Reference argument can not be null");
        Preconditions.checkArgument(!this.references.contains(reference), "IE00222: Reference can not be added twice");
        this.provider.addReference(this, reference.getTarget(), reference.getType());
        this.references.add(reference);
        for (INaviOperandTreeNodeListener listener : this.listeners) {
            try {
                listener.addedReference(this, reference);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public COperandTreeNode cloneNode() {
        COperandTreeNode clonedNode = new COperandTreeNode(this.id, this.expressionType, this.expressionValue, this.replacement == null ? null : this.replacement.cloneReplacement(), this.references, this.provider);
        for (COperandTreeNode child : this.children) {
            COperandTreeNode.link(clonedNode, child.cloneNode());
        }
        return clonedNode;
    }

    @Override
    public void close() {
        if (this.replacement != null) {
            this.replacement.close();
            this.replacement.removeListener(this.listener);
        }
        if (this.substitution != null) {
            this.operandTree.getInstruction().getModule().getTypeManager().removeTypeSubstitutionInstance(this.substitution);
        }
        if (this.instanceReferences != null && !this.instanceReferences.isEmpty()) {
            TypeInstanceContainer container = this.operandTree.getInstruction().getModule().getContent().getTypeInstanceContainer();
            for (TypeInstanceReference reference : this.instanceReferences) {
                container.deactivateTypeInstanceReference(reference);
            }
        }
    }

    @Override
    public void deleteReference(IReference reference) throws CouldntDeleteException {
        Preconditions.checkNotNull(reference, "IE00223: Reference argument can not be null");
        Preconditions.checkArgument(this.references.contains(reference), "IE00224: No such reference at this node");
        this.provider.deleteReference(this, reference.getTarget(), reference.getType());
        this.references.remove(reference);
        for (INaviOperandTreeNodeListener listener : this.listeners) {
            try {
                listener.removedReference(this, reference);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public long determineAddendValue() {
        INaviOperandTreeNode sibling = Preconditions.checkNotNull(COperandTreeNode.determineAddendSibling(this), "Error: operand expression is not a two component sum.");
        if (sibling.getOperand().getInstruction().getArchitecture().equalsIgnoreCase("x86-64")) {
            return new BigInteger(sibling.getValue()).longValue();
        }
        return (int)Long.parseLong(sibling.getValue());
    }

    @Override
    public List<INaviOperandTreeNode> getChildren() {
        return new ArrayList<INaviOperandTreeNode>(this.children);
    }

    @Override
    public OperandDisplayStyle getDisplayStyle() {
        return this.displayStyle;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public IAddress getInstructionAddress() {
        return this.getOperand().getInstruction().getAddress();
    }

    @Override
    public INaviOperandTree getOperand() {
        return this.operandTree;
    }

    @Override
    public int getOperandPosition() {
        return this.getOperand().getInstruction().getOperandPosition(this.getOperand());
    }

    @Override
    public INaviOperandTreeNode getParent() {
        return this.parent;
    }

    @Override
    public List<IReference> getReferences() {
        return this.references;
    }

    @Override
    public INaviReplacement getReplacement() {
        return this.replacement;
    }

    @Override
    public ExpressionType getType() {
        return this.expressionType;
    }

    @Override
    public List<TypeInstanceReference> getTypeInstanceReferences() {
        if (this.instanceReferences == null) {
            return new ArrayList<TypeInstanceReference>();
        }
        return this.instanceReferences;
    }

    @Override
    public TypeSubstitution getTypeSubstitution() {
        return this.substitution;
    }

    @Override
    public String getValue() {
        return this.expressionValue;
    }

    @Override
    public boolean hasAddendSibling() {
        return COperandTreeNode.determineAddendSibling(this) != null;
    }

    @Override
    public void removeListener(INaviOperandTreeNodeListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setDisplayStyle(OperandDisplayStyle style) {
        Preconditions.checkNotNull(style, "IE00463: Style argument can not be null");
        if (this.displayStyle.equals((Object)style)) {
            return;
        }
        this.displayStyle = style;
        for (INaviOperandTreeNodeListener listener : this.listeners) {
            try {
                listener.changedDisplayStyle(this, style);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void setId(int nodeId) {
        this.id = nodeId;
    }

    @Override
    public void setTypeSubstitution(TypeSubstitution substitution) {
        this.substitution = substitution;
    }

    public String toString() {
        return this.replacement == null || this.expressionType == ExpressionType.SIZE_PREFIX ? (this.expressionValue.equals("dword") ? "" : this.expressionValue) : this.replacement.toString();
    }

    private void notifyListeners() {
        for (INaviOperandTreeNodeListener listener : this.listeners) {
            listener.changedValue(this);
        }
    }

    public class InternalTypeInstanceContainerListener
    implements TypeInstanceContainerListener {
        private void notifyOperandChanged(TypeInstanceReference reference) {
            if (COperandTreeNode.this.instanceReferences != null && COperandTreeNode.this.instanceReferences.contains(reference)) {
                COperandTreeNode.this.notifyListeners();
            }
        }

        @Override
        public void addedTypeInstance(TypeInstance instance) {
        }

        @Override
        public void addedTypeInstanceReference(TypeInstanceReference reference) {
            this.notifyOperandChanged(reference);
        }

        @Override
        public void changedTypeInstance(TypeInstance instance) {
            if (COperandTreeNode.this.instanceReferences == null) {
                return;
            }
            for (TypeInstanceReference reference : COperandTreeNode.this.instanceReferences) {
                if (instance != reference.getTypeInstance()) continue;
                COperandTreeNode.this.notifyListeners();
                return;
            }
        }

        @Override
        public void changedTypeInstanceReference(TypeInstanceReference reference) {
            this.notifyOperandChanged(reference);
        }

        @Override
        public void removedTypeInstance(TypeInstance instance) {
        }

        @Override
        public void removedTypeInstanceReference(TypeInstanceReference reference) {
            this.notifyOperandChanged(reference);
        }
    }

    private class InternalReplacementListener
    implements INaviReplacementListener {
        private InternalReplacementListener() {
        }

        @Override
        public void changed(INaviReplacement replacement) {
            for (INaviOperandTreeNodeListener listener : COperandTreeNode.this.listeners) {
                try {
                    listener.changedValue(COperandTreeNode.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

