/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNodeListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class CNaviViewNode
extends CViewNode<INaviEdge>
implements INaviViewNode {
    private final Set<CTag> m_tags;
    private final SQLProvider m_provider;
    private final ListenerProvider<INaviViewNodeListener> m_naviViewNodeListeners = new ListenerProvider();
    private final InternalTagListener m_tagListener = new InternalTagListener();
    private final List<INaviViewNode> m_parents = new ArrayList<INaviViewNode>();
    private final List<INaviViewNode> m_children = new ArrayList<INaviViewNode>();
    private INaviGroupNode m_parentGroup = null;

    public CNaviViewNode(int nodeId, double x2, double y2, double width, double height, Color color, Color borderColor, boolean selected, boolean visible, Set<CTag> tags, SQLProvider provider) {
        super(nodeId, x2, y2, width, height, color, borderColor, selected, visible);
        this.m_provider = Preconditions.checkNotNull(provider, "IE00209: SQL provider can not be can not be null");
        this.m_tags = new HashSet<CTag>((Collection)Preconditions.checkNotNull(tags, "IE00210: Tags can not be null"));
        for (CTag tag : this.m_tags) {
            tag.addListener(this.m_tagListener);
        }
    }

    public static void link(INaviViewNode parent, INaviViewNode child) {
        parent.addChild(child);
        child.addParent(parent);
    }

    @Override
    public void addChild(INaviViewNode child) {
        this.m_children.add(child);
    }

    @Override
    public void addListener(INaviViewNodeListener listener) {
        super.addListener(listener);
        this.m_naviViewNodeListeners.addListener(listener);
    }

    @Override
    public void addParent(INaviViewNode parent) {
        this.m_parents.add(parent);
    }

    @Override
    public abstract CNaviViewNode cloneNode();

    @Override
    public void close() {
        for (CTag tag : this.m_tags) {
            tag.removeListener(this.m_tagListener);
        }
    }

    @Override
    public List<INaviViewNode> getChildren() {
        return new ArrayList<INaviViewNode>(this.m_children);
    }

    @Override
    public INaviGroupNode getParentGroup() {
        return this.m_parentGroup;
    }

    @Override
    public List<INaviViewNode> getParents() {
        return new ArrayList<INaviViewNode>(this.m_parents);
    }

    @Override
    public Set<CTag> getTags() {
        return new HashSet<CTag>(this.m_tags);
    }

    @Override
    public Iterator<CTag> getTagsIterator() {
        return this.m_tags.iterator();
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return this.m_provider.equals(provider);
    }

    public boolean isStored() {
        return this.getId() != -1;
    }

    @Override
    public boolean isTagged() {
        return !this.m_tags.isEmpty();
    }

    @Override
    public boolean isTagged(CTag tag) {
        return this.m_tags.contains(tag);
    }

    @Override
    public void removeChild(INaviViewNode node) {
        this.m_children.remove(node);
    }

    public void removeListener(INaviViewNodeListener listener) {
        super.removeListener(listener);
        this.m_naviViewNodeListeners.removeListener(listener);
    }

    @Override
    public void removeParent(INaviViewNode node) {
        this.m_parents.remove(node);
    }

    @Override
    public void removeTag(CTag tag) throws CouldntSaveDataException {
        if (this.isTagged(tag)) {
            if (this.isStored()) {
                this.m_provider.removeTagFromNode(this, tag.getId());
            }
            this.m_tags.remove(tag);
            ArrayList<CTag> tagList = Lists.newArrayList(tag);
            for (INaviViewNodeListener listener : this.m_naviViewNodeListeners) {
                listener.untaggedNodes(this, tagList);
            }
            tag.removeListener(this.m_tagListener);
        }
    }

    @Override
    public void setParentGroup(INaviGroupNode group) {
        if (group != null && group.equals(this.m_parentGroup)) {
            return;
        }
        Preconditions.checkArgument(group != this, "IE00211: Invalid group hierarchy");
        this.m_parentGroup = group;
        for (INaviViewNodeListener listener : this.m_naviViewNodeListeners) {
            try {
                listener.changedParentGroup(this, group);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.m_parentGroup != null && this.m_parentGroup.isCollapsed() && this.m_parentGroup.isVisible()) {
            return;
        }
        super.setVisible(visible);
    }

    @Override
    public void tagNode(CTag tag) throws CouldntSaveDataException {
        if (!this.isTagged(tag)) {
            if (this.isStored()) {
                this.m_provider.saveTagToNode(this, tag.getId());
            }
            this.m_tags.add(tag);
            for (INaviViewNodeListener listener : this.m_naviViewNodeListeners) {
                listener.taggedNode(this, tag);
            }
            tag.addListener(this.m_tagListener);
        }
    }

    @Deprecated
    public void tagNodeSilent(CTag tag) {
        if (!this.isTagged(tag)) {
            this.m_tags.add(tag);
            for (INaviViewNodeListener listener : this.m_naviViewNodeListeners) {
                listener.taggedNode(this, tag);
            }
            tag.addListener(this.m_tagListener);
        }
    }

    private class InternalTagListener
    implements ITagListener {
        private InternalTagListener() {
        }

        @Override
        public void changedDescription(CTag tag, String description) {
        }

        @Override
        public void changedName(CTag tag, String name) {
        }

        @Override
        public void deletedTag(CTag tag) {
            CNaviViewNode.this.m_tags.remove(tag);
            ArrayList<CTag> tagList = Lists.newArrayList(tag);
            for (INaviViewNodeListener listener : CNaviViewNode.this.m_naviViewNodeListeners) {
                listener.untaggedNodes(CNaviViewNode.this, tagList);
            }
            tag.removeListener(CNaviViewNode.this.m_tagListener);
        }
    }
}

