/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.IAddressNode;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviEdgeCommentListener;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdgeListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public final class CNaviViewEdge
extends CViewEdge<INaviViewNode>
implements INaviEdge {
    private final SQLProvider m_provider;
    private final InternalCommentListener m_internalCommentListener = new InternalCommentListener();

    public CNaviViewEdge(int id, INaviViewNode sourceNode, INaviViewNode targetNode, EdgeType type, double sourceX, double sourceY, double targetX, double targetY, Color color, boolean selected, boolean visible, ArrayList<IComment> localComment, List<CBend> edgePaths, SQLProvider provider) {
        super(id, sourceNode, targetNode, type, sourceX, sourceY, targetX, targetY, color, selected, visible, edgePaths);
        this.m_provider = Preconditions.checkNotNull(provider, "IE00204: Provider argument can not be null");
        CNaviViewNode.link(sourceNode, targetNode);
        CommentManager.get(provider).addListener(this.m_internalCommentListener);
        if (localComment != null && !localComment.isEmpty()) {
            CommentManager.get(this.m_provider).initializeLocalEdgeComment(this, localComment);
        }
    }

    @Override
    public List<IComment> appendGlobalComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        if (this.getSource() instanceof IAddressNode && this.getSource() instanceof IAddressNode) {
            return CommentManager.get(this.m_provider).appendGlobalEdgeComment(this, commentText);
        }
        return null;
    }

    @Override
    public List<IComment> appendLocalComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        return CommentManager.get(this.m_provider).appendLocalEdgeComment(this, commentText);
    }

    @Override
    public void deleteGlobalComment(IComment comment) throws CouldntDeleteException {
        if (this.getSource() instanceof IAddressNode && this.getTarget() instanceof IAddressNode) {
            CommentManager.get(this.m_provider).deleteGlobalEdgeComment(this, comment);
        }
    }

    @Override
    public void deleteLocalComment(IComment comment) throws CouldntDeleteException {
        CommentManager.get(this.m_provider).deleteLocalEdgeComment(this, comment);
    }

    @Override
    public void dispose() {
        CommentManager.get(this.m_provider).unloadGlobalEdgeComment(this, this.getGlobalComment());
        CommentManager.get(this.m_provider).unloadLocalEdgeComment(this, this.getLocalComment());
        CommentManager.get(this.m_provider).removeListener(this.m_internalCommentListener);
    }

    @Override
    public IComment editGlobalComment(IComment oldComment, String commentText) throws CouldntSaveDataException {
        if (this.getSource() instanceof IAddressNode && this.getTarget() instanceof IAddressNode) {
            return CommentManager.get(this.m_provider).editGlobalEdgeComment(this, oldComment, commentText);
        }
        return null;
    }

    @Override
    public IComment editLocalComment(IComment oldComment, String commentText) throws CouldntSaveDataException {
        return CommentManager.get(this.m_provider).editLocalEdgeComment(this, oldComment, commentText);
    }

    @Override
    public List<IComment> getGlobalComment() {
        if (this.getSource() instanceof IAddressNode && this.getTarget() instanceof IAddressNode) {
            return CommentManager.get(this.m_provider).getGlobalEdgeComment(this);
        }
        return null;
    }

    @Override
    public List<IComment> getLocalComment() {
        return CommentManager.get(this.m_provider).getLocalEdgeComment(this);
    }

    @Override
    public void initializeGlobalComment(List<IComment> comment) {
        if (this.getSource() instanceof IAddressNode && this.getTarget() instanceof IAddressNode) {
            CommentManager.get(this.m_provider).initializeGlobalEdgeComment(this, comment);
        }
    }

    @Override
    public void initializeLocalComment(List<IComment> comments) {
        CommentManager.get(this.m_provider).initializeLocalEdgeComment(this, comments);
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return this.m_provider.equals(provider);
    }

    @Override
    public boolean isOwner(IComment comment) {
        return CUserManager.get(this.m_provider).isOwner(comment);
    }

    @Override
    public boolean isStored() {
        return this.getId() != -1;
    }

    public String toString() {
        int n2 = this.getId();
        String string2 = String.valueOf(this.getSource());
        String string3 = String.valueOf(this.getTarget());
        return new StringBuilder(18 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("[").append(n2).append("] ").append(string2).append(" -> ").append(string3).toString();
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedGlobalEdgeComment(INaviEdge edge, IComment comment) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).appendedGlobalEdgeComment(edge, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void appendedLocalEdgeComment(INaviEdge edge, IComment comment) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).appendedLocalEdgeComment(edge, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedGlobalEdgeComment(INaviEdge edge, IComment comment) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).deletedGlobalEdgeComment(edge, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedLocalEdgeComment(INaviEdge edge, IComment comment) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).deletedLocalEdgeComment(edge, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedGlobalEdgeComment(INaviEdge edge, IComment comment) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).editedGlobalEdgeComment(edge, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedLocalEdgeComment(INaviEdge edge, IComment comment) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).editedLocalEdgeComment(edge, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedGlobalEdgeComments(INaviEdge edge, List<IComment> comments) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).initializedGlobalEdgeComment(edge, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedLocalEdgeComments(INaviEdge edge, List<IComment> comments) {
            if (CNaviViewEdge.this.equals(edge)) {
                for (IViewEdgeListener listener : CNaviViewEdge.this.m_listeners) {
                    if (!(listener instanceof INaviEdgeCommentListener)) continue;
                    try {
                        ((INaviEdgeCommentListener)listener).initializedLocalEdgeComment(edge, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
    }
}

