/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class CLoopHighlighter {
    private CLoopHighlighter() {
    }

    private static EdgeType loopify(EdgeType type) {
        switch (type) {
            case JUMP_CONDITIONAL_FALSE: {
                return EdgeType.JUMP_CONDITIONAL_FALSE_LOOP;
            }
            case JUMP_CONDITIONAL_TRUE: {
                return EdgeType.JUMP_CONDITIONAL_TRUE_LOOP;
            }
            case JUMP_UNCONDITIONAL: {
                return EdgeType.JUMP_UNCONDITIONAL_LOOP;
            }
        }
        return type;
    }

    public static void colorLoops(IDirectedGraph<INaviViewNode, INaviEdge> graph, INaviViewNode entryNode) throws MalformedGraphException {
        List<INaviEdge> edges = graph.getEdges();
        if (entryNode != null) {
            HashMap<INaviViewNode, ArrayList<INaviViewNode>> backedges = GraphAlgorithms.getBackEdges(graph, entryNode);
            for (INaviEdge edge : edges) {
                if (edge.getSource() == edge.getTarget()) {
                    edge.setEdgeType(CLoopHighlighter.loopify(edge.getType()));
                }
                if (!backedges.containsKey(edge.getSource()) || !backedges.get(edge.getSource()).contains(edge.getTarget())) continue;
                edge.setEdgeType(CLoopHighlighter.loopify(edge.getType()));
            }
        }
    }
}

