/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.CommentListener;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.IInstructionListener;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTree;
import com.google.security.zynamics.zylib.ZyTree.IZyTreeNode;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.util.ArrayList;
import java.util.List;

public final class CInstruction
implements INaviInstruction {
    private final IAddress m_address;
    private final String m_mnemonic;
    private final List<COperandTree> m_operands;
    private final INaviModule m_module;
    private final byte[] m_data;
    private final String m_architecture;
    private final SQLProvider m_provider;
    private final ListenerProvider<IInstructionListener> m_listeners = new ListenerProvider();
    private final CommentListener m_internalCommentListener = new InternalCommentListener();
    private boolean m_saved;

    public CInstruction(boolean saved, INaviModule module, IAddress address, String mnemonic, List<COperandTree> operands, byte[] data, String architecture, SQLProvider provider) {
        this.m_module = Preconditions.checkNotNull(module, "IE00126: Module argument can not be null");
        this.m_address = Preconditions.checkNotNull(address, "IE00127: Address argument can not be null");
        this.m_mnemonic = Preconditions.checkNotNull(mnemonic, "IE00128: Mnemonic argument can not be null");
        Preconditions.checkArgument(!mnemonic.isEmpty(), "IE00129: Mnemonic argument can not be empty");
        Preconditions.checkNotNull(operands, "IE00130: Operands argument can not be null");
        CInstruction.verifyOperands(operands);
        Preconditions.checkNotNull(data, "IE02195: Data argument can not be null");
        this.m_architecture = Preconditions.checkNotNull(architecture, "IE02196: Architecture argument can not be null");
        Preconditions.checkArgument(!architecture.isEmpty(), "IE02197: Architecture argument can not be empty");
        this.m_provider = Preconditions.checkNotNull(provider, "IE00132: SQL provider argument can not be null");
        this.m_saved = saved;
        this.m_operands = new ArrayList<COperandTree>(operands);
        this.m_data = (byte[])data.clone();
        CommentManager.get(this.m_provider).addListener(this.m_internalCommentListener);
        for (COperandTree operand : operands) {
            operand.setNaviInstruction(this);
        }
    }

    private static List<COperandTree> clone(List<COperandTree> operands) {
        FilledList<COperandTree> clonedOperands = new FilledList<COperandTree>();
        for (COperandTree operand : operands) {
            clonedOperands.add(operand.cloneTree());
        }
        return clonedOperands;
    }

    private static void verifyNode(IZyTreeNode node) {
        Preconditions.checkNotNull(node, "IE00133: Operand tree node with value null detected");
        for (IZyTreeNode iZyTreeNode : node.getChildren()) {
            CInstruction.verifyNode(iZyTreeNode);
        }
    }

    private static void verifyOperands(List<COperandTree> operands) {
        for (IOperandTree iOperandTree : operands) {
            CInstruction.verifyNode(iOperandTree.getRootNode());
        }
    }

    @Override
    public void addListener(IInstructionListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public List<IComment> appendGlobalComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        Preconditions.checkNotNull(commentText, "IE02536: comment argument can not be null");
        return CommentManager.get(this.m_provider).appendGlobalInstructionComment(this, commentText);
    }

    @Override
    public CInstruction cloneInstruction() {
        CInstruction instruction = new CInstruction(this.m_saved, this.m_module, this.m_address, this.m_mnemonic, CInstruction.clone(this.m_operands), this.m_data, this.m_architecture, this.m_provider);
        CommentManager.get(this.m_provider).initializeGlobalInstructionComment(instruction, this.getGlobalComment());
        return instruction;
    }

    @Override
    public void close() {
        for (COperandTree operand : this.m_operands) {
            operand.close();
        }
        CommentManager.get(this.m_provider).unloadGlobalInstructionComment(this, this.getGlobalComment());
        CommentManager.get(this.m_provider).removeListener(this.m_internalCommentListener);
    }

    @Override
    public void deleteGlobalComment(IComment comment) throws CouldntDeleteException {
        Preconditions.checkNotNull(comment, "IE02537: comment argument can not be null");
        CommentManager.get(this.m_provider).deleteGlobalInstructionComment(this, comment);
    }

    @Override
    public IComment editGlobalComment(IComment comment, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(comment, "IE02538: comment argument can not be null");
        return CommentManager.get(this.m_provider).editGlobalInstructionComment(this, comment, commentText);
    }

    @Override
    public IAddress getAddress() {
        return this.m_address;
    }

    @Override
    public String getArchitecture() {
        return this.m_architecture;
    }

    @Override
    public byte[] getData() {
        return (byte[])this.m_data.clone();
    }

    @Override
    public List<IComment> getGlobalComment() {
        return CommentManager.get(this.m_provider).getGlobalInstructionComment(this);
    }

    @Override
    public String getInstructionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_mnemonic);
        stringBuffer.append(' ');
        for (int i2 = 0; i2 < this.m_operands.size(); ++i2) {
            stringBuffer.append(this.m_operands.get(i2).toString());
            if (i2 == this.m_operands.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    @Override
    public long getLength() {
        return this.m_data.length;
    }

    @Override
    public String getMnemonic() {
        return this.m_mnemonic;
    }

    @Override
    public Integer getMnemonicCode() {
        return this.m_mnemonic.hashCode();
    }

    @Override
    public INaviModule getModule() {
        return this.m_module;
    }

    @Override
    public int getOperandPosition(INaviOperandTree operand) {
        return this.m_operands.indexOf(operand);
    }

    @Override
    public List<COperandTree> getOperands() {
        return new ArrayList<COperandTree>(this.m_operands);
    }

    @Override
    public void initializeGlobalComment(ArrayList<IComment> comment) {
        Preconditions.checkNotNull(comment, "IE00134: Instruction comment can not be null");
        CommentManager.get(this.m_provider).initializeGlobalInstructionComment(this, comment);
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return provider.equals(this.m_provider);
    }

    @Override
    public boolean isOwner(IComment comment) {
        return CUserManager.get(this.m_provider).getCurrentActiveUser().equals(comment.getUser());
    }

    @Override
    public boolean isStored() {
        return this.m_saved;
    }

    @Override
    public void removeListener(IInstructionListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void setSaved(boolean saved) {
        this.m_saved = saved;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_address.toHexString());
        stringBuffer.append(' ');
        stringBuffer.append(this.m_mnemonic);
        stringBuffer.append(' ');
        for (int i2 = 0; i2 < this.m_operands.size(); ++i2) {
            stringBuffer.append(this.m_operands.get(i2).toString());
            if (i2 == this.m_operands.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedGlobalInstructionComment(INaviInstruction instruction, IComment comment) {
            if (instruction.getAddress().equals(CInstruction.this.getAddress())) {
                for (IInstructionListener listener : CInstruction.this.m_listeners) {
                    try {
                        listener.appendedComment(instruction, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedGlobalInstructionComment(INaviInstruction instruction, IComment comment) {
            if (instruction.getAddress().equals(CInstruction.this.getAddress())) {
                for (IInstructionListener listener : CInstruction.this.m_listeners) {
                    try {
                        listener.deletedComment(instruction, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedGlobalInstructionComment(INaviInstruction instruction, IComment comment) {
            if (instruction.getAddress().equals(CInstruction.this.getAddress())) {
                for (IInstructionListener listener : CInstruction.this.m_listeners) {
                    try {
                        listener.editedComment(instruction, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedGlobalInstructionComments(INaviInstruction instruction, List<IComment> comments) {
            if (instruction.getAddress().equals(CInstruction.this.getAddress())) {
                for (IInstructionListener listener : CInstruction.this.m_listeners) {
                    try {
                        listener.initializedComment(instruction, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
    }
}

