/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.CommentListener;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNodeListener;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNodeListener;
import java.awt.Color;
import java.util.List;
import java.util.Set;

public final class CFunctionNode
extends CNaviViewNode
implements INaviFunctionNode {
    private final INaviFunction m_function;
    private final SQLProvider m_provider;
    private final CommentListener m_internalCommentListener = new InternalCommentListener();

    public CFunctionNode(int nodeId, INaviFunction function, double x2, double y2, double width, double height, Color color, boolean selected, boolean visible, List<IComment> localComments, Set<CTag> tags, SQLProvider provider) {
        super(nodeId, x2, y2, width, height, color, Color.BLACK, selected, visible, tags, provider);
        this.m_function = Preconditions.checkNotNull(function, "IE00086: Function argument can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE02390: provider argument can not be null");
        CommentManager.get(this.m_provider).addListener(this.m_internalCommentListener);
        CommentManager.get(this.m_provider).initializeFunctionNodeComment(this, localComments);
    }

    @Override
    public List<IComment> appendLocalFunctionComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        return CommentManager.get(this.m_provider).appendFunctionNodeComment((INaviFunctionNode)this, commentText);
    }

    @Override
    public CFunctionNode cloneNode() {
        return new CFunctionNode(1, this.getFunction(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getColor(), this.isSelected(), this.isVisible(), this.getLocalFunctionComment(), this.getTags(), this.m_provider);
    }

    @Override
    public void deleteLocalFunctionComment(IComment comment) throws CouldntDeleteException {
        CommentManager.get(this.m_provider).deleteFunctionNodeComment(this, comment);
    }

    @Override
    public IComment editLocalFunctionComment(IComment oldComment, String commentText) throws CouldntSaveDataException {
        return CommentManager.get(this.m_provider).editFunctionNodeComment(this, oldComment, commentText);
    }

    @Override
    public IAddress getAddress() {
        return this.m_function.getAddress();
    }

    @Override
    public List<IComment> getLocalFunctionComment() {
        return CommentManager.get(this.m_provider).getFunctionNodeComment(this);
    }

    @Override
    public INaviFunction getFunction() {
        return this.m_function;
    }

    @Override
    public List<IComment> getLocalComment() {
        return this.getLocalFunctionComment();
    }

    @Override
    public void initializeLocalFunctionComment(List<IComment> comments) {
        CommentManager.get(this.m_provider).initializeFunctionNodeComment(this, comments);
    }

    @Override
    public boolean isOwner(IComment comment) {
        Preconditions.checkNotNull(comment, "IE02534: comment argument can not be null");
        return CUserManager.get(this.m_provider).getCurrentActiveUser().equals(comment.getUser());
    }

    @Override
    public boolean isStored() {
        return super.isStored();
    }

    @Override
    public void close() {
        super.close();
        CommentManager.get(this.m_provider).unloadFunctionNodeComment(this, this.getLocalFunctionComment());
        CommentManager.get(this.m_provider).removeListener(this.m_internalCommentListener);
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedFunctionNodeComment(INaviFunctionNode functionNode, IComment comment) {
            if (CFunctionNode.this.equals(functionNode)) {
                for (IViewNodeListener listener : CFunctionNode.this.getListeners()) {
                    if (!(listener instanceof INaviFunctionNodeListener)) continue;
                    try {
                        ((INaviFunctionNodeListener)listener).appendedFunctionNodeComment(functionNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedFunctionNodeComment(INaviFunctionNode functionNode, IComment comment) {
            if (CFunctionNode.this.equals(functionNode)) {
                for (IViewNodeListener listener : CFunctionNode.this.getListeners()) {
                    if (!(listener instanceof INaviFunctionNodeListener)) continue;
                    try {
                        ((INaviFunctionNodeListener)listener).deletedFunctionNodeComment(functionNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedFunctionNodeComment(INaviFunctionNode functionNode, IComment comment) {
            if (CFunctionNode.this.equals(functionNode)) {
                for (IViewNodeListener listener : CFunctionNode.this.getListeners()) {
                    if (!(listener instanceof INaviFunctionNodeListener)) continue;
                    try {
                        ((INaviFunctionNodeListener)listener).editedFunctionNodeComment(functionNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedFunctionNodeComments(INaviFunctionNode functionNode, List<IComment> comments) {
            if (CFunctionNode.this.equals(functionNode)) {
                for (IViewNodeListener listener : CFunctionNode.this.getListeners()) {
                    if (!(listener instanceof INaviFunctionNodeListener)) continue;
                    try {
                        ((INaviFunctionNodeListener)listener).initializedFunctionNodeComment(functionNode, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
    }
}

