/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CommentListener;
import com.google.security.zynamics.binnavi.disassembly.CommentListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.List;

public final class CCodeNodeComments {
    private final CCodeNode m_codeNode;
    private final INaviFunction m_parentFunction;
    private final SQLProvider m_provider;
    private final CommentListener m_internalCommentListener = new InternalCommentListener();
    private final ListenerProvider<INaviCodeNodeListener> m_listeners;

    public CCodeNodeComments(CCodeNode codeNode, INaviFunction parentFunction, List<IComment> localComments, ListenerProvider<INaviCodeNodeListener> listeners, SQLProvider provider) {
        this.m_codeNode = Preconditions.checkNotNull(codeNode, "IE02391: codeNode argument can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE02392: provider argument can not be null");
        this.m_parentFunction = parentFunction;
        this.m_listeners = listeners;
        CommentManager.get(this.m_provider).addListener(this.m_internalCommentListener);
        if (localComments != null && !localComments.isEmpty()) {
            CommentManager.get(this.m_provider).initializeLocalCodeNodeComment(this.m_codeNode, localComments);
        }
    }

    public List<IComment> appendGlobalCodeNodeComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        if (this.m_parentFunction != null) {
            return CommentManager.get(this.m_provider).appendGlobalCodeNodeComment(this.m_codeNode, commentText);
        }
        return null;
    }

    public List<IComment> appendLocalCodeNodeComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        return CommentManager.get(this.m_provider).appendLocalCodeNodeComment(this.m_codeNode, commentText);
    }

    public List<IComment> appendLocalInstructionComment(INaviInstruction instruction, String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        return CommentManager.get(this.m_provider).appendLocalInstructionComment(instruction, this.m_codeNode, commentText);
    }

    public void deleteGlobalCodeNodeComment(IComment comment) throws CouldntDeleteException {
        if (this.m_parentFunction != null) {
            CommentManager.get(this.m_provider).deleteGlobalCodeNodeComment(this.m_codeNode, comment);
        }
    }

    public void deleteLocalCodeNodeComment(IComment comment) throws CouldntDeleteException {
        CommentManager.get(this.m_provider).deleteLocalCodeNodeComment(this.m_codeNode, comment);
    }

    public void deleteLocalInstructionComment(INaviInstruction instruction, IComment comment) throws CouldntDeleteException {
        CommentManager.get(this.m_provider).deleteLocalInstructionComment(instruction, this.m_codeNode, comment);
    }

    public void dispose() {
        CommentManager commentManager = CommentManager.get(this.m_provider);
        commentManager.unloadGlobalCodeNodeComment(this.m_codeNode, this.getGlobalCodeNodeComment());
        commentManager.unloadLocalCodeNodeComment(this.m_codeNode, this.getLocalCodeNodeComment());
        commentManager.removeListener(this.m_internalCommentListener);
    }

    public IComment editGlobalCodeNodeComment(IComment oldComment, String commentText) throws CouldntSaveDataException {
        if (this.m_parentFunction != null) {
            return CommentManager.get(this.m_provider).editGlobalCodeNodeComment(this.m_codeNode, oldComment, commentText);
        }
        return null;
    }

    public IComment editLocalCodeNodeComment(IComment oldComment, String commentText) throws CouldntSaveDataException {
        return CommentManager.get(this.m_provider).editLocalCodeNodeComment(this.m_codeNode, oldComment, commentText);
    }

    public IComment editLocalInstructionComment(INaviInstruction instruction, IComment oldComment, String commentText) throws CouldntSaveDataException {
        return CommentManager.get(this.m_provider).editLocalInstructionComment(this.m_codeNode, instruction, oldComment, commentText);
    }

    public List<IComment> getGlobalCodeNodeComment() {
        if (this.m_parentFunction != null) {
            return CommentManager.get(this.m_provider).getGlobalCodeNodeComment(this.m_codeNode);
        }
        return null;
    }

    public List<IComment> getLocalCodeNodeComment() {
        return CommentManager.get(this.m_provider).getLocalCodeNodeComment(this.m_codeNode);
    }

    public List<IComment> getLocalInstructionComment(INaviInstruction instruction) {
        return CommentManager.get(this.m_provider).getLocalInstructionComment(instruction, this.m_codeNode);
    }

    public void initializeGlobalCodeNodeComment(List<IComment> comments) {
        if (this.m_parentFunction != null) {
            CommentManager.get(this.m_provider).initializeGlobalCodeNodeComment(this.m_codeNode, comments);
        }
    }

    public void initializeLocalCodeNodeComment(List<IComment> comments) {
        CommentManager.get(this.m_provider).initializeLocalCodeNodeComment(this.m_codeNode, comments);
    }

    public void initializeLocalInstructionComment(INaviInstruction instruction, List<IComment> comments) {
        CommentManager.get(this.m_provider).initializeLocalInstructionComment(this.m_codeNode, instruction, comments);
    }

    private class InternalCommentListener
    extends CommentListenerAdapter {
        private InternalCommentListener() {
        }

        @Override
        public void appendedGlobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.appendedGlobalCodeNodeComment(CCodeNodeComments.this.m_codeNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void appendedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.appendedLocalCodeNodeComment(CCodeNodeComments.this.m_codeNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void appendedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.appendedLocalInstructionComment(codeNode, instruction, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedGlobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.deletedGlobalCodeNodeComment(CCodeNodeComments.this.m_codeNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.deletedLocalCodeNodeComment(CCodeNodeComments.this.m_codeNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void deletedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.deletedLocalInstructionComment(codeNode, instruction, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedGLobalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.editedGlobalCodeNodeComment(CCodeNodeComments.this.m_codeNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedLocalCodeNodeComment(INaviCodeNode codeNode, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.editedLocalCodeNodeComment(CCodeNodeComments.this.m_codeNode, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void editedLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, IComment comment) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.editedLocalInstructionComment(codeNode, instruction, comment);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedGlobalCodeNodeComments(INaviCodeNode codeNode, List<IComment> comments) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.initializedGlobalCodeNodeComment(codeNode, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedLocalCodeNodeComments(INaviCodeNode codeNode, List<IComment> comments) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.initializedLocalCodeNodeComment(codeNode, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void initializedLocalInstructionComments(INaviCodeNode codeNode, INaviInstruction instruction, List<IComment> comments) {
            if (CCodeNodeComments.this.m_codeNode.equals(codeNode)) {
                for (INaviCodeNodeListener listener : CCodeNodeComments.this.m_listeners) {
                    try {
                        listener.initializedLocalInstructionComment(codeNode, instruction, comments);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
    }
}

