/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.NodeParser.IInstructionContainer;
import com.google.security.zynamics.binnavi.disassembly.INaviBasicBlock;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class CBasicBlock
implements INaviBasicBlock,
IInstructionContainer {
    private final int m_id;
    private final String m_globalComment;
    private final List<INaviInstruction> m_instructions;

    public CBasicBlock(int blockId, String globalComment, List<INaviInstruction> instructions) {
        Preconditions.checkArgument(blockId >= 0, "IE00050: Basic Block IDs can not be negative");
        this.m_globalComment = Preconditions.checkNotNull(globalComment, "IE00052: Global comment can not be null");
        this.m_instructions = Preconditions.checkNotNull(instructions, "IE01783: Instructions argument can not be null");
        this.m_id = blockId;
    }

    @Override
    public IAddress getAddress() {
        return this.m_instructions.get(0).getAddress();
    }

    @Override
    public String getGlobalComment() {
        return this.m_globalComment;
    }

    @Override
    @Deprecated
    public int getId() {
        return this.m_id;
    }

    @Override
    public List<INaviInstruction> getInstructions() {
        return Collections.unmodifiableList(this.m_instructions);
    }

    @Override
    public Iterator<INaviInstruction> iterator() {
        return this.m_instructions.iterator();
    }
}

