/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.AddressSpaces;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.AddressSpaceContentBackend;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.ProjectTargetSettings;
import com.google.security.zynamics.binnavi.debug.debugger.TcpDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceContentListener;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CAddressSpaceContent {
    private final INaviAddressSpace m_addressSpace;
    private final AddressSpaceContentBackend m_provider;
    private final ListenerProvider<IAddressSpaceContentListener> m_listeners = new ListenerProvider();
    private final List<INaviModule> m_modules = new ArrayList<INaviModule>();
    private final Map<INaviModule, IAddress> m_imageBases = new HashMap<INaviModule, IAddress>();

    public CAddressSpaceContent(INaviAddressSpace addressSpace, AddressSpaceContentBackend provider, List<Pair<IAddress, INaviModule>> modules) {
        this.m_addressSpace = Preconditions.checkNotNull(addressSpace, "IE01791: Address space argument can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE01792: Provider argument can not be null");
        Preconditions.checkNotNull(modules, "IE01793: Modules argument can not be null");
        for (Pair<IAddress, INaviModule> pair : modules) {
            IAddress address = pair.first();
            INaviModule module = pair.second();
            this.m_modules.add(module);
            this.m_imageBases.put(module, address);
            IDebugger debugger = addressSpace.getConfiguration().getDebugger();
            if (debugger == null) continue;
            debugger.setAddressTranslator(module, module.getConfiguration().getFileBase(), this.getImageBase(module));
        }
        IDebugger debugger = addressSpace.getConfiguration().getDebugger();
        if (debugger == null || !debugger.isConnected()) {
            DebuggerTemplate template = addressSpace.getConfiguration().getDebuggerTemplate();
            if (template == null) {
                addressSpace.getConfiguration().setDebugger(null);
            } else {
                TcpDebugger newDebuggerdebugger = new TcpDebugger(template, new ProjectTargetSettings(this.m_addressSpace.getProject()));
                for (INaviModule module : this.m_modules) {
                    newDebuggerdebugger.setAddressTranslator(module, module.getConfiguration().getFileBase(), this.getImageBase(module));
                }
                addressSpace.getConfiguration().setDebugger(newDebuggerdebugger);
            }
        }
    }

    public void addListener(IAddressSpaceContentListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void addModule(INaviModule module) throws CouldntSaveDataException {
        Preconditions.checkNotNull(module, "IE00030: Module argument can not be null");
        Preconditions.checkArgument(!this.m_modules.contains(module), "IE00032: Module can not be added more than once");
        Preconditions.checkArgument(module.inSameDatabase(this.m_addressSpace), "IE00033: Module and address space are not in the same database");
        this.m_provider.addModule(this.m_addressSpace, module);
        this.m_modules.add(module);
        for (IAddressSpaceContentListener listener : this.m_listeners) {
            try {
                listener.addedModule(this.m_addressSpace, module);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.setImageBase(module, module.getConfiguration().getImageBase());
    }

    public IAddress getImageBase(INaviModule module) {
        Preconditions.checkNotNull(module, "IE00034: Module argument can not be null");
        Preconditions.checkArgument(this.m_modules.contains(module), "IE00037: Module is not part of the address space");
        return this.m_imageBases.containsKey(module) ? this.m_imageBases.get(module) : module.getConfiguration().getFileBase();
    }

    public int getModuleCount() {
        return this.m_modules.size();
    }

    public List<INaviModule> getModules() {
        return new ArrayList<INaviModule>(this.m_modules);
    }

    public void removeListener(IAddressSpaceContentListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void removeModule(INaviModule module) throws CouldntDeleteException, CouldntSaveDataException {
        Preconditions.checkNotNull(module, "IE00041: Module argument can not be null");
        Preconditions.checkArgument(this.m_modules.contains(module), "IE00043: Module does not belong to this address space");
        this.m_provider.removeModule(this.m_addressSpace, module);
        this.m_modules.remove(module);
        for (IAddressSpaceContentListener listener : this.m_listeners) {
            try {
                listener.removedModule(this.m_addressSpace, module);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_addressSpace.getConfiguration().updateModificationDate();
    }

    public void setImageBase(INaviModule module, IAddress imageBase) throws CouldntSaveDataException {
        Preconditions.checkNotNull(module, "IE00045: Module argument can not be null");
        Preconditions.checkNotNull(imageBase, "IE00046: Address argument can not be null");
        Preconditions.checkArgument(this.m_modules.contains(module), "IE00048: Module is not part of the address space");
        if (imageBase.equals(this.m_imageBases.get(module))) {
            return;
        }
        this.m_provider.setImageBase(this.m_addressSpace, module, imageBase);
        this.m_imageBases.put(module, imageBase);
        IDebugger debugger = this.m_addressSpace.getConfiguration().getDebugger();
        if (debugger != null) {
            debugger.setAddressTranslator(module, module.getConfiguration().getFileBase(), this.getImageBase(module));
        }
        for (IAddressSpaceContentListener listener : this.m_listeners) {
            try {
                listener.changedImageBase(this.m_addressSpace, module, imageBase);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.m_addressSpace.getConfiguration().updateModificationDate();
    }
}

