/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.disassembly.AddressSpaces;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.AddressSpaceLoadEvents;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceConfiguration;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceContent;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceLoaderReporter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceListener;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class CAddressSpace
implements INaviAddressSpace {
    private final INaviProject m_project;
    private final SQLProvider m_provider;
    private final ListenerProvider<IAddressSpaceListener> m_listeners = new ListenerProvider();
    private final int m_moduleCount;
    private boolean m_isLoading = false;
    private final CAddressSpaceLoaderReporter m_loadReporter = new CAddressSpaceLoaderReporter(this.m_listeners);
    private final CAddressSpaceConfiguration m_configuration;
    private CAddressSpaceContent m_content;

    public CAddressSpace(int addressSpaceId, String name, String description, Date creationDate, Date modificationDate, Map<INaviModule, IAddress> imageBases, DebuggerTemplate debuggerTemplate, SQLProvider provider, INaviProject project) {
        Preconditions.checkArgument(addressSpaceId > 0, "IE00023: ID argument must be positive");
        Preconditions.checkNotNull(name, "IE00024: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE00025: Description argument can not be null");
        Preconditions.checkNotNull(creationDate, "IE00026: Creation date argument can not be null");
        Preconditions.checkNotNull(modificationDate, "IE00027: Modification date argument can not be null");
        Preconditions.checkNotNull(imageBases, "IE00028: Image bases argument can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE00029: Provider argument can not be null");
        this.m_project = Preconditions.checkNotNull(project, "IE01790: project argument can not be null");
        this.m_configuration = new CAddressSpaceConfiguration(this, provider, addressSpaceId, name, description, creationDate, modificationDate, debuggerTemplate);
        this.m_moduleCount = imageBases.size();
    }

    @Override
    public void addListener(IAddressSpaceListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public boolean close() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("IE00035: Address space is not loaded");
        }
        for (IAddressSpaceListener listener : this.m_listeners) {
            try {
                if (listener.closing(this)) continue;
                return false;
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        CAddressSpaceContent oldContent = this.m_content;
        this.m_content = null;
        for (IAddressSpaceListener listener : this.m_listeners) {
            try {
                listener.closed(this, oldContent);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return true;
    }

    @Override
    public CAddressSpaceConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public CAddressSpaceContent getContent() {
        Preconditions.checkNotNull(this.m_content, "IE00191: Address space must be loaded first");
        return this.m_content;
    }

    @Override
    public int getModuleCount() {
        return this.isLoaded() ? this.m_content.getModuleCount() : this.m_moduleCount;
    }

    @Override
    public INaviProject getProject() {
        return this.m_project;
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject object) {
        Preconditions.checkNotNull(object, "IE00039: Object argument can not be null");
        return object.inSameDatabase(this.m_provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return provider.equals(this.m_provider);
    }

    @Override
    public boolean isLoaded() {
        return this.m_content != null;
    }

    @Override
    public boolean isLoading() {
        return this.m_isLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws CouldntLoadDataException, LoadCancelledException {
        CAddressSpaceLoaderReporter cAddressSpaceLoaderReporter = this.m_loadReporter;
        synchronized (cAddressSpaceLoaderReporter) {
            if (this.isLoaded()) {
                return;
            }
            this.m_isLoading = true;
            try {
                if (!this.m_loadReporter.report(AddressSpaceLoadEvents.Starting)) {
                    throw new LoadCancelledException();
                }
                if (!this.m_loadReporter.report(AddressSpaceLoadEvents.LoadingModules)) {
                    throw new LoadCancelledException();
                }
                List<Pair<IAddress, INaviModule>> modules = this.m_provider.loadModules(this);
                this.m_content = new CAddressSpaceContent(this, this.m_provider, modules);
            }
            catch (CouldntLoadDataException | LoadCancelledException e2) {
                this.m_isLoading = false;
                throw e2;
            }
            finally {
                this.m_loadReporter.report(AddressSpaceLoadEvents.Finished);
            }
            for (IAddressSpaceListener listener : this.m_listeners) {
                try {
                    listener.loaded(this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            this.m_isLoading = false;
        }
    }

    @Override
    public void removeListener(IAddressSpaceListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        return String.format("Address Space %s (%d)", this.m_configuration.getName(), this.m_configuration.getId());
    }
}

