/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.trace;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugEventListenerAdapter;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.helpers.EchoBreakpointCollector;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceEventType;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceRegister;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceLoggerListener;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class TraceLogger {
    private TraceList eventList;
    private final Map<BreakpointAddress, Integer> activeEchoBreakpoints = new HashMap<BreakpointAddress, Integer>();
    private final BreakpointManager breakpointManager;
    private final ITraceListProvider traceProvider;
    private final IDebugger debugger;
    private final InternalBreakpointManagerListener m_breakpointManagerListener = new InternalBreakpointManagerListener();
    private final InternalProcessListener m_processListener = new InternalProcessListener();
    private final ListenerProvider<ITraceLoggerListener> listeners = new ListenerProvider();
    private final Lock lock = new ReentrantLock();
    private final IDebugEventListener m_debuggerListener = new DebugEventListenerAdapter(){

        private Pair<ThreadRegisters, BreakpointAddress> getAddress(EchoBreakpointHitReply reply) {
            for (ThreadRegisters threadRegisters : reply.getRegisterValues()) {
                if (reply.getThreadId() != threadRegisters.getTid()) continue;
                for (RegisterValue registerValue : threadRegisters) {
                    if (!registerValue.isPc()) continue;
                    BreakpointAddress address = DebuggerHelpers.getBreakpointAddress(TraceLogger.this.debugger, new RelocatedAddress(new CAddress(registerValue.getValue())));
                    return new Pair<ThreadRegisters, BreakpointAddress>(threadRegisters, address);
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public void receivedReply(EchoBreakpointHitReply reply) {
            TraceLogger.this.lock.lock();
            Pair<ThreadRegisters, BreakpointAddress> addressPair = this.getAddress(reply);
            BreakpointAddress address = addressPair.second();
            if (TraceLogger.this.hasEchoBreakpoint(address)) {
                NaviLogger.info("Adding echo breakpoint event %s to event list %s", address.getAddress().getAddress().toHexString(), TraceLogger.this.eventList.getName());
                ArrayList<TraceRegister> registers = new ArrayList<TraceRegister>();
                for (RegisterValue registerValue : addressPair.first()) {
                    registers.add(new TraceRegister(registerValue.getName(), new CAddress(registerValue.getValue()), registerValue.getMemory()));
                }
                ArrayList<TraceRegister> valueSet = Lists.newArrayList(registers);
                TraceEvent newEvent = new TraceEvent(reply.getThreadId(), address, TraceEventType.ECHO_BREAKPOINT, valueSet);
                TraceLogger.this.eventList.addEvent(newEvent);
                Integer count = (Integer)TraceLogger.this.activeEchoBreakpoints.get(address);
                if (count != null) {
                    int remaining = count - 1;
                    if (remaining <= 0) {
                        TraceLogger.this.breakpointManager.removeBreakpoints(BreakpointType.ECHO, Sets.newHashSet(address));
                    } else {
                        TraceLogger.this.activeEchoBreakpoints.put(address, remaining);
                    }
                }
            } else {
                NaviLogger.info("Unknown echo breakpoint event for address [%s]", address.getAddress().getAddress().toHexString());
            }
            TraceLogger.this.lock.unlock();
        }
    };

    public TraceLogger(ITraceListProvider traceProvider, IDebugger debugger) {
        this.traceProvider = Preconditions.checkNotNull(traceProvider, "IE00785: Trace provider can not be null");
        this.debugger = Preconditions.checkNotNull(debugger, "IE00786: Debugger can not be null");
        this.breakpointManager = debugger.getBreakpointManager();
    }

    private boolean hasEchoBreakpoint(BreakpointAddress address) {
        return this.activeEchoBreakpoints.containsKey(address);
    }

    private void removeListeners() {
        this.debugger.removeListener(this.m_debuggerListener);
        this.breakpointManager.removeListener(this.m_breakpointManagerListener);
        this.debugger.getProcessManager().removeListener(this.m_processListener);
    }

    public int activeEchoBreakpointCount() {
        return this.activeEchoBreakpoints.size();
    }

    public void addListener(ITraceLoggerListener listener) {
        this.listeners.addListener(listener);
    }

    public TraceList getTrace() {
        return this.eventList;
    }

    public ITraceListProvider getTraceProvider() {
        return this.traceProvider;
    }

    public boolean hasEchoBreakpoints() {
        return !this.activeEchoBreakpoints.isEmpty();
    }

    public void removeListener(ITraceLoggerListener listener) {
        this.listeners.removeListener(listener);
    }

    public void start(TraceList trace2, Set<BreakpointAddress> relocatedAddresses, int maximumHits) {
        Preconditions.checkNotNull(relocatedAddresses, "IE00762: Address list can not be null");
        Preconditions.checkArgument(!relocatedAddresses.isEmpty(), "IE00787: Address list can not be empty");
        for (BreakpointAddress address : relocatedAddresses) {
            Preconditions.checkNotNull(address, "IE00788: Address list contains invalid elements");
        }
        this.lock.lock();
        this.eventList = trace2;
        this.debugger.addListener(this.m_debuggerListener);
        this.debugger.getProcessManager().addListener(this.m_processListener);
        this.breakpointManager.addListener(this.m_breakpointManagerListener);
        NaviLogger.info("Starting new event list with name %s", trace2.getName());
        HashSet<BreakpointAddress> collectedAddresses = new HashSet<BreakpointAddress>();
        for (BreakpointAddress address : relocatedAddresses) {
            if (EchoBreakpointCollector.isBlocked(this.breakpointManager, address)) continue;
            if (!this.debugger.isConnected()) {
                this.lock.unlock();
                return;
            }
            collectedAddresses.add(address);
        }
        this.breakpointManager.addBreakpoints(BreakpointType.ECHO, collectedAddresses);
        for (BreakpointAddress address : collectedAddresses) {
            try {
                this.activeEchoBreakpoints.put(address, maximumHits);
                for (ITraceLoggerListener listener : this.listeners) {
                    listener.addedBreakpoint();
                }
            }
            catch (IllegalArgumentException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        if (this.activeEchoBreakpoints.isEmpty()) {
            this.removeListeners();
        }
        this.lock.unlock();
    }

    public Set<BreakpointAddress> stop() {
        NaviLogger.info("Finalizing event list %s with %d events", this.eventList.getName(), this.eventList.getEventCount());
        if (this.activeEchoBreakpointCount() == 0) {
            return new HashSet<BreakpointAddress>();
        }
        this.lock.lock();
        this.removeListeners();
        HashSet<BreakpointAddress> ebps = new HashSet<BreakpointAddress>(this.activeEchoBreakpoints.keySet());
        this.breakpointManager.removeBreakpoints(BreakpointType.ECHO, ebps);
        try {
            for (ITraceLoggerListener listener : this.listeners) {
                listener.removedBreakpoint();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.activeEchoBreakpoints.clear();
        this.lock.unlock();
        for (ITraceLoggerListener listener : this.listeners) {
            try {
                listener.finished(this.eventList);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return ebps;
    }

    public TraceList switchTargetList(TraceList trace2) {
        TraceList oldList = this.eventList;
        this.eventList = trace2;
        return oldList;
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void detached() {
            TraceLogger.this.removeListeners();
            TraceLogger.this.activeEchoBreakpoints.clear();
            for (ITraceLoggerListener listener : TraceLogger.this.listeners) {
                listener.finished(TraceLogger.this.eventList);
            }
        }
    }

    private class InternalBreakpointManagerListener
    extends BreakpointManagerListenerAdapter {
        private InternalBreakpointManagerListener() {
        }

        @Override
        public void breakpointsRemoved(Set<Breakpoint> breakpoints) {
            if (!TraceLogger.this.debugger.isConnected()) {
                return;
            }
            HashSet<BreakpointAddress> echoBreakpoints = Sets.newHashSet();
            for (Breakpoint breakpoint : breakpoints) {
                if (breakpoint.getType() != BreakpointType.ECHO) continue;
                echoBreakpoints.add(breakpoint.getAddress());
                TraceLogger.this.activeEchoBreakpoints.remove(breakpoint.getAddress());
            }
            for (ITraceLoggerListener listener : TraceLogger.this.listeners) {
                listener.removedBreakpoint();
            }
            if (TraceLogger.this.activeEchoBreakpointCount() == 0) {
                TraceLogger.this.removeListeners();
                for (ITraceLoggerListener listener : TraceLogger.this.listeners) {
                    listener.finished(TraceLogger.this.eventList);
                }
            }
            NaviLogger.info("Removed %d echo breakpoints from the breakpoint manager", echoBreakpoints.size());
        }
    }
}

