/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.trace;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.debug.models.trace.AbstractTraceProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceManagerListener;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CProjectListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ProjectTraceProvider
extends AbstractTraceProvider {
    private final INaviProject project;
    private final List<ListenerWrapper> listenerWrappers = new ArrayList<ListenerWrapper>();

    public ProjectTraceProvider(INaviProject project) {
        this.project = project;
    }

    @Override
    public void addListener(ITraceManagerListener listener) {
        ListenerWrapper newListener = new ListenerWrapper(listener);
        this.listenerWrappers.add(newListener);
        this.project.addListener(newListener);
    }

    @Override
    public TraceList createTrace(String name, String description) throws CouldntSaveDataException {
        return this.project.getContent().createTrace(name, description);
    }

    @Override
    public TraceList getList(int index) {
        return this.project.getContent().getTraces().get(index);
    }

    @Override
    public int getNumberOfTraceLists() {
        return this.project.getContent().getTraceCount();
    }

    @Override
    public List<TraceList> getTraces() {
        return this.project.getContent().getTraces();
    }

    @Override
    public boolean isLoaded() {
        return this.project.isLoaded();
    }

    @Override
    public Iterator<TraceList> iterator() {
        return this.project.getContent().getTraces().iterator();
    }

    @Override
    public void removeList(TraceList trace2) throws CouldntDeleteException {
        this.project.getContent().removeTrace(trace2);
    }

    @Override
    public void removeListener(ITraceManagerListener listener) {
        for (ListenerWrapper wrapper : new ArrayList<ListenerWrapper>(this.listenerWrappers)) {
            if (wrapper.getListener() != listener) continue;
            this.project.removeListener(wrapper);
            this.listenerWrappers.remove(wrapper);
        }
    }

    private static class ListenerWrapper
    extends CProjectListenerAdapter {
        private final ITraceManagerListener listener;

        public ListenerWrapper(ITraceManagerListener listener) {
            this.listener = Preconditions.checkNotNull(listener, "IE00774: Listener argument can't be null");
        }

        @Override
        public void addedTrace(INaviProject project, TraceList trace2) {
            this.listener.addedTrace(trace2);
        }

        public ITraceManagerListener getListener() {
            return this.listener;
        }

        @Override
        public void loadedProject(CProject project) {
            this.listener.loaded();
        }

        @Override
        public void removedTrace(INaviProject project, TraceList trace2) {
            this.listener.removedTrace(trace2);
        }
    }
}

