/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.trace;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.debug.models.trace.AbstractTraceProvider;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceManagerListener;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.Modules.CTraceContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.ITraceContainerListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ModuleTraceProvider
extends AbstractTraceProvider {
    private final INaviModule module;
    private final List<ListenerWrapper> listenerWrapper = new ArrayList<ListenerWrapper>();

    public ModuleTraceProvider(INaviModule module) {
        this.module = Preconditions.checkNotNull(module, "IE00772: Module argument can not be null");
    }

    @Override
    public void addListener(ITraceManagerListener listener) {
        ListenerWrapper newListener = new ListenerWrapper(listener);
        this.listenerWrapper.add(newListener);
        this.module.addListener(newListener);
        if (this.module.isLoaded()) {
            this.module.getContent().getTraceContainer().addListener(newListener);
        }
    }

    @Override
    public TraceList createTrace(String name, String description) throws CouldntSaveDataException {
        return this.module.getContent().getTraceContainer().createTrace(name, description);
    }

    @Override
    public TraceList getList(int index) {
        return this.module.getContent().getTraceContainer().getTraces().get(index);
    }

    @Override
    public int getNumberOfTraceLists() {
        return this.module.getContent().getTraceContainer().getTraceCount();
    }

    @Override
    public List<TraceList> getTraces() {
        return this.module.getContent().getTraceContainer().getTraces();
    }

    @Override
    public boolean isLoaded() {
        return this.module.isLoaded();
    }

    @Override
    public Iterator<TraceList> iterator() {
        return this.module.getContent().getTraceContainer().getTraces().iterator();
    }

    @Override
    public void removeList(TraceList trace2) throws CouldntDeleteException {
        this.module.getContent().getTraceContainer().deleteTrace(trace2);
    }

    @Override
    public void removeListener(ITraceManagerListener listener) {
        for (ListenerWrapper wrapper : new ArrayList<ListenerWrapper>(this.listenerWrapper)) {
            if (wrapper.getListener() != listener) continue;
            this.module.removeListener(wrapper);
            this.listenerWrapper.remove(wrapper);
            if (!this.module.isLoaded()) continue;
            this.module.getContent().getTraceContainer().removeListener(wrapper);
        }
    }

    private static class ListenerWrapper
    extends CModuleListenerAdapter
    implements ITraceContainerListener {
        private final ITraceManagerListener listener;

        public ListenerWrapper(ITraceManagerListener listener) {
            this.listener = Preconditions.checkNotNull(listener, "IE00773: Listener argument can not be null");
        }

        @Override
        public void addedTrace(CTraceContainer container, TraceList trace2) {
            this.listener.addedTrace(trace2);
        }

        @Override
        public void deletedTrace(CTraceContainer container, TraceList trace2) {
            this.listener.removedTrace(trace2);
        }

        public ITraceManagerListener getListener() {
            return this.listener;
        }

        @Override
        public void loadedModule(INaviModule module) {
            this.listener.loaded();
            module.getContent().getTraceContainer().addListener(this);
        }
    }
}

