/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.targetinformation;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DebuggerOptions {
    private final boolean canDetach;
    private final boolean canAttach;
    private final boolean canTerminate;
    private final boolean canMemmap;
    private final boolean canMultithread;
    private final boolean canValidMemory;
    private final boolean canSoftwareBreakpoints;
    private final int breakpointCounter;
    private final boolean canHalt;
    private final boolean haltBeforeCommunicating;
    private final boolean stackAvailable;
    private final int pageSize;
    private final boolean canBreakOnModuleLoad;
    private final boolean canBreakOnModuleUnload;
    private Collection<DebuggerException> exceptions;
    private final boolean canTraceCount;

    public DebuggerOptions(boolean canDetach, boolean canAttach, boolean canTerminate, boolean canMemmap, boolean stackAvailable, boolean canValidMemory, boolean canHalt, boolean haltBeforeCommunicating, boolean canMultithread, boolean canSoftwareBreakpoints, int breakpointCounter, int pageSize, List<DebuggerException> exceptions2, boolean canBreakOnModuleLoad, boolean canBreakOnModuleUnload, boolean canTraceCount) {
        Preconditions.checkArgument(breakpointCounter > 0, "IE01036: Breakpoint counter argument must be positive");
        this.canDetach = canDetach;
        this.canAttach = canAttach;
        this.canTerminate = canTerminate;
        this.canMemmap = canMemmap;
        this.stackAvailable = stackAvailable;
        this.canValidMemory = canValidMemory;
        this.canMultithread = canMultithread;
        this.canHalt = canHalt;
        this.haltBeforeCommunicating = haltBeforeCommunicating;
        this.canSoftwareBreakpoints = canSoftwareBreakpoints;
        this.breakpointCounter = breakpointCounter;
        this.pageSize = pageSize;
        this.exceptions = new ArrayList<DebuggerException>(exceptions2);
        this.canBreakOnModuleLoad = canBreakOnModuleLoad;
        this.canBreakOnModuleUnload = canBreakOnModuleUnload;
        this.canTraceCount = canTraceCount;
    }

    public static DebuggerOptions newInstance(DebuggerOptions options) {
        return new DebuggerOptions(options.canDetach, options.canAttach, options.canTerminate, options.canMemmap, options.stackAvailable, options.canValidMemory, options.canHalt, options.haltBeforeCommunicating, options.canMultithread, options.canSoftwareBreakpoints, options.breakpointCounter, options.pageSize, new ArrayList<DebuggerException>(options.exceptions), options.canBreakOnModuleLoad, options.canBreakOnModuleUnload, options.canTraceCount);
    }

    public boolean canBreakOnModuleLoad() {
        return this.canBreakOnModuleLoad;
    }

    public boolean canBreakOnModuleUnload() {
        return this.canBreakOnModuleUnload;
    }

    public boolean canDetach() {
        return this.canDetach;
    }

    public boolean canAttach() {
        return this.canAttach;
    }

    public boolean canHalt() {
        return this.canHalt;
    }

    public boolean canMemmap() {
        return this.canMemmap;
    }

    public boolean canMultithread() {
        return this.canMultithread;
    }

    public boolean canSoftwareBreakpoint() {
        return this.canSoftwareBreakpoints;
    }

    public boolean canTerminate() {
        return this.canTerminate;
    }

    public boolean canTraceCount() {
        return this.canTraceCount;
    }

    public boolean canValidMemory() {
        return this.canValidMemory;
    }

    public int getBreakpointCounter() {
        return this.breakpointCounter;
    }

    public Collection<DebuggerException> getExceptions() {
        return this.exceptions;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isStackAvailable() {
        return this.stackAvailable;
    }

    public boolean mustHaltBeforeCommunicating() {
        return this.haltBeforeCommunicating;
    }

    public void setExceptions(Collection<DebuggerException> exceptions2) {
        this.exceptions = exceptions2;
    }

    public static class DebuggerOptionsBuilder {
        boolean canDetach = true;
        boolean canAttach = true;
        boolean canTerminate = true;
        boolean canMemmap = true;
        boolean stackAvailable = true;
        boolean canValidateMemory = true;
        boolean canHalt = false;
        boolean canHaltBeforeCommunicating = false;
        boolean canMultithread = true;
        boolean canSoftwareBreakpoints = true;
        int maximumBreakpoints = Integer.MAX_VALUE;
        int pageSize = 0;
        List<DebuggerException> exceptions = new ArrayList<DebuggerException>();
        boolean canBreakOnModuleLoad = false;
        boolean canBreakOnModuleUnload = false;
        boolean canTraceCount = true;

        public DebuggerOptionsBuilder canDetach(boolean value) {
            this.canDetach = value;
            return this;
        }

        public DebuggerOptionsBuilder canAttach(boolean value) {
            this.canAttach = value;
            return this;
        }

        public DebuggerOptionsBuilder canTerminate(boolean value) {
            this.canTerminate = value;
            return this;
        }

        public DebuggerOptionsBuilder canMemmap(boolean value) {
            this.canMemmap = value;
            return this;
        }

        public DebuggerOptionsBuilder stackAvailable(boolean value) {
            this.stackAvailable = value;
            return this;
        }

        public DebuggerOptionsBuilder canValidateMemory(boolean value) {
            this.canValidateMemory = value;
            return this;
        }

        public DebuggerOptionsBuilder canHalt(boolean value) {
            this.canHalt = value;
            return this;
        }

        public DebuggerOptionsBuilder canHaltBeforeCommunicating(boolean value) {
            this.canHaltBeforeCommunicating = value;
            return this;
        }

        public DebuggerOptionsBuilder canMultithread(boolean value) {
            this.canMultithread = value;
            return this;
        }

        public DebuggerOptionsBuilder canSoftwareBreakpoints(boolean value) {
            this.canSoftwareBreakpoints = value;
            return this;
        }

        public DebuggerOptionsBuilder breakpointCounter(int value) {
            this.maximumBreakpoints = value;
            return this;
        }

        public DebuggerOptionsBuilder pageSize(int value) {
            this.pageSize = value;
            return this;
        }

        public DebuggerOptionsBuilder addException(DebuggerException value) {
            this.exceptions.add(value);
            return this;
        }

        public DebuggerOptionsBuilder canBreakOnModuleLoad(boolean value) {
            this.canBreakOnModuleLoad = value;
            return this;
        }

        public DebuggerOptionsBuilder canBreakOnModuleUnload(boolean value) {
            this.canBreakOnModuleUnload = value;
            return this;
        }

        public DebuggerOptionsBuilder canTraceCounts(boolean value) {
            this.canTraceCount = value;
            return this;
        }

        public DebuggerOptions build() {
            return new DebuggerOptions(this.canDetach, this.canAttach, this.canTerminate, this.canMemmap, this.stackAvailable, this.canValidateMemory, this.canHalt, this.canHaltBeforeCommunicating, this.canMultithread, this.canSoftwareBreakpoints, this.maximumBreakpoints, this.pageSize, this.exceptions, this.canBreakOnModuleLoad, this.canBreakOnModuleUnload, this.canTraceCount);
        }
    }
}

