/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.debug.models.targetinformation;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerExceptionHandlingAction;

public final class DebuggerException {
    private final long exceptionCode;
    private final String name;
    private final DebuggerExceptionHandlingAction exceptionAction;

    public DebuggerException(String exceptionName, long exceptionCode, DebuggerExceptionHandlingAction exceptionAction) {
        Preconditions.checkArgument(!exceptionName.isEmpty(), "IE00181: Exception name can not be empty");
        this.name = Preconditions.checkNotNull(exceptionName, "IE00047: exceptionName argument can not be null");
        this.exceptionCode = exceptionCode;
        this.exceptionAction = Preconditions.checkNotNull(exceptionAction, "IE02119: exceptionAction argument can not be null");
    }

    public static String getSettingKey(DebuggerException exception, int debuggerId) {
        long l2 = exception.getExceptionCode();
        return new StringBuilder(46).append("dbg_").append(debuggerId).append("_exception_").append(l2).toString();
    }

    public DebuggerExceptionHandlingAction getExceptionAction() {
        return this.exceptionAction;
    }

    public long getExceptionCode() {
        return this.exceptionCode;
    }

    public String getExceptionName() {
        return this.name;
    }
}

